/* hdTestHiaInfo.c;
 *
 *	module to test Helios Daemon.
 *		created by k3sato on June 2nd in 1994.
 *
 *	modification history:	
 *	(1) add test02 agent to hdTestHiaInfo[]
 *		on July 25th in '94.
 *	(2) add the data of two members funcDir and methodDir in hdTestHiaInfo[]
 *		on November 17th in '94.
 *	(3) modified the agent data for adding two member to struct AgentInfo,
 *	    and added new agent 'meeting'
 *		on November 6th in '94.
 *	(4) add f_agent agent to hdTestHiaInfo[]
 *		on February 3rd in '95.
 *
 * $Id: hdTestHiaInfo.c,v 2.11 1995/03/02 09:26:27 k3sato Exp $
 */

#include <stdio.h>

#include <helios/heliosd.h>
#include <helios/hdMessage.h>

#ifdef _DEBUG_HELIOSD

FuncDirInfo boardFuncDir[] = {
    {"queen_problem",	"board",	&boardFuncDir[1]},
    {"board_manager",	"board",	NULL},
};

FuncDirInfo nQueenFuncDir[] = {
    {"4queens",	"queen1, queen2, queen3, queen4",
       &nQueenFuncDir[1]},
    {"5queens",	"queen1, queen2, queen3, queen4, queen5",
       &nQueenFuncDir[2]},
    {"6queens",	"queen1, queen2, queen3, queen4, queen5, queen6",
       &nQueenFuncDir[3]},
    {"7queens",	"queen1, queen2, queen3, queen4, queen5, queen6, queen7",
       &nQueenFuncDir[4]},
    {"8queens",	"queen1, queen2, queen3, queen4, queen5, queen6, queen7, queen8",
       &boardFuncDir[0]},
};

/* test informations gotten from files named *.hia
 */
AgentInfo hdTestHiaInfo[] = {
    {HdAT_Complex,	"0.1",	NULL,	"nQueen",
       NULL,	&nQueenFuncDir[0],	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       NULL,	&hdTestHiaInfo[9],	&hdTestHiaInfo[11]},
    {HdAT_Single,	"0.1.1",
       "/db/HKB/v1/test/local/app/nQueen/queen1",	"queen1",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[2]},
    {HdAT_Single,	"0.1.2",
       "/db/HKB/v1/test/local/app/nQueen/queen2",	"queen2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[3]},
    {HdAT_Single,	"0.1.3",
       "/db/HKB/v1/test/local/app/nQueen/queen3",	"queen3",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[4]},
    {HdAT_Single,	"0.1.4",
       "/db/HKB/v1/test/local/app/nQueen/queen4",	"queen4",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[5]},
    {HdAT_Single,	"0.1.5",
       "/db/HKB/v1/test/local/app/nQueen/queen5",	"queen5",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[6]},
    {HdAT_Single,	"0.1.6",
       "/db/HKB/v1/test/local/app/nQueen/queen6",	"queen6",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[7]},
    {HdAT_Single,	"0.1.7",
       "/db/HKB/v1/test/local/app/nQueen/queen7",	"queen7",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[8]},
    {HdAT_Single,	"0.1.8",
       "/db/HKB/v1/test/local/app/nQueen/queen8",	"queen8",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	NULL},
    {HdAT_Single,	"0.1.9",
       "/db/HKB/v1/test/local/app/nQueen/board",	"board",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[0],	NULL,	&hdTestHiaInfo[1]},
    {HdAT_Single,	"0.1.10",
       "/db/HKB/v1/test/local/app/nQueen/cmd_gui/gui",	"gui",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       NULL,	NULL,	NULL},


    /*	for app/test02
     *		from hdTestHiaInfo[11]
     *		to   hdTestHiaInfo[17]
     */
    /* [11]
     */
    {HdAT_Complex,	"0.2",
       NULL,	"A0",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       NULL,	&hdTestHiaInfo[12],	&hdTestHiaInfo[18]},

    /* [12]
     */
    {HdAT_Single,	"0.2.1",
       "/db/HKB/v1/test/local/app/test02/a1",	"A1",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[11],	NULL,	&hdTestHiaInfo[13]},

    /* [13]
     */
    {HdAT_Complex,	"0.2.2",
       NULL,	"A2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[11],	&hdTestHiaInfo[14],	&hdTestHiaInfo[17]},

    /* [14]
     */
    {HdAT_Single,	"0.2.2.1",
       "/db/HKB/v1/test/local/app/test02/a3",	"A3",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[13],	NULL,	&hdTestHiaInfo[15]},

    /* [15]
     */
    {HdAT_Single,	"0.2.2.2",
       "/db/HKB/v1/test/local/app/test02/a4",	"A4",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[13],	NULL,	&hdTestHiaInfo[16]},

    /* [16]
     */
    {HdAT_Single,	"0.2.2.3",
       "/db/HKB/v1/test/local/app/test02/a5",	"A5",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[13],	NULL,	NULL},

    /* [17]
     */
    {HdAT_Single,	"0.2.3",
       "/db/HKB/v1/test/local/app/test02/a6",	"A6",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[11],	NULL,	NULL},

    /*
     * nQueen Part.2
     * Queen Agents do backtracks among them
     */
    /* [18] - [26]
     */
    /* [18] nQueen2 (complex agent of nQueen2)
     */
    {HdAT_Complex,	"0.3",
       NULL,	"nQueen2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       NULL,	&hdTestHiaInfo[19],	&hdTestHiaInfo[28]},

    /* [19] queen1 of nQueen2
     */
    {HdAT_Single,	"0.3.1",
       "/db/HKB/v1/test/local/app/nQueen2/queen1",	"queen1",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[20]},

    /* [20] queen2 of nQueen2
     */
    {HdAT_Single,	"0.3.2",
       "/db/HKB/v1/test/local/app/nQueen2/queen2",	"queen2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[21]},

    /* [21] queen3 of nQueen2
     */
    {HdAT_Single,	"0.3.3",
       "/db/HKB/v1/test/local/app/nQueen2/queen3",	"queen3",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[22]},

    /* [22] queen4 of nQueen2
     */
    {HdAT_Single,	"0.3.4",
       "/db/HKB/v1/test/local/app/nQueen2/queen4",	"queen4",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[23]},

    /* [23] queen5 of nQueen2
     */
    {HdAT_Single,	"0.3.5",
       "/db/HKB/v1/test/local/app/nQueen2/queen5",	"queen5",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[24]},

    /* [24] queen6 of nQueen2
     */
    {HdAT_Single,	"0.3.6",
       "/db/HKB/v1/test/local/app/nQueen2/queen6",	"queen6",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[25]},

    /* [25] queen7 of nQueen2
     */
    {HdAT_Single,	"0.3.7",
       "/db/HKB/v1/test/local/app/nQueen2/queen7",	"queen7",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[26]},

    /* [26] queen8 of nQueen2
     */
    {HdAT_Single,	"0.3.8",
       "/db/HKB/v1/test/local/app/nQueen2/queen8",	"queen8",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	&hdTestHiaInfo[27]},

    /* [27] board of nQueen2
     */
    {HdAT_Single,	"0.3.9",
       "/db/HKB/v1/test/local/app/nQueen2/board",	"board",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[18],	NULL,	NULL},

    /* [28] parser-top
     */
    {HdAT_Complex,	"0.4",
       NULL,	"parser-top",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL}, NULL,	AS_NotActive,	0,	NULL,
   
       NULL, &hdTestHiaInfo[29],	&hdTestHiaInfo[32]},

    /* [29] parser
     */
    {HdAT_Single,	"0.4.1",
       "/db/HKB/v1/test/local/app/parser/parser",	"parser",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[28],	NULL,	&hdTestHiaInfo[30]},

    /* [30] dict
     */
    {HdAT_Single,	"0.4.2",
       "/db/HKB/v1/test/local/app/parser/dict","dict",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[28],	NULL,	&hdTestHiaInfo[31]},

    /* [31] dict2
     */
    {HdAT_Single,	"0.4.3",
       "/db/HKB/v1/test/local/app/parser/dict2","dict2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[28],	NULL,	NULL},

    /* [32] prm_test by z-yanaga
     */
    {HdAT_Complex,	"0.5",
       NULL,	"prm_test",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       NULL,	&hdTestHiaInfo[33],	&hdTestHiaInfo[37]},

    /* [33] prm_template1
     */
    {HdAT_Parametric,	"0.5.1",
       "/db/HKB/v1/test/local/app/prm_test/template/prm_template1",	"prm_template1",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[32],	NULL,	&hdTestHiaInfo[34]},

    /* [34] prm_template2
     */
    {HdAT_Parametric,	"0.5.2",
       "/db/HKB/v1/test/local/app/prm_test/template2/prm_template2",	"prm_template2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[32],	NULL,	NULL},

    /* [35] agent1
     * << ######### not linked agent ##############>>
     */
    {HdAT_Single,	"0.5.1",
       "/db/HKB/v1/test/local/app/prm_test/agent1/agent1",	"agent1",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[32],	NULL,	&hdTestHiaInfo[36]},

    /* [36] agent2
     * << ######### not linked agent ##############>>
     */
    {HdAT_Single,	"0.5.2",
       "/db/HKB/v1/test/local/app/prm_test/agent2/agent2",	"agent2",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[32],	NULL,	NULL},

    /* [37] test agent by k3sato on November 25th, '94.
     */
    {HdAT_Single,	"0.10",
       "/db/HKB/v1/test/local/test/sendAskMes/sendAskMes",	"testAgent",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       NULL,	NULL,	&hdTestHiaInfo[38]},

    /* [38] demo agents; meeting defined by wazumi on Nov. 30th in '94
     *		from hdTestHiaInfo[38]
     *		to   hdTestHiaInfo[]
     */
    {HdAT_Complex,	"0.20",
       NULL,	"scheduling",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	1,	NULL,
       NULL,	&hdTestHiaInfo[39],	&hdTestHiaInfo[71]},

    /* [39] meeting1
     */
    {HdAT_Single,	"0.20.1",
       "/db/HKB/v1/test/local/app/demo01/meeting1",	"meeting1",
       NULL,	NULL,	NULL,	{"zeus", NULL, NULL},
       NULL,	AS_NotActive,	2,
       "{  Meeting Name: meeting1} {  Date: 12/14 14:00 - 17:00} {  Planned Participants:} {    memberA(100), memberC(80), memberD(70), memberF(50),} {    memberG(40),  memberI(20), memberJ(10)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[40]},

    /* [40] meeting2
     */
    {HdAT_Single,	"0.20.2",
       "/db/HKB/v1/test/local/app/demo01/meeting2",	"meeting2",
       NULL,	NULL,	NULL,	{"ss126", NULL, NULL},
       NULL,	AS_NotActive,	2,
       "{  Meeting Name: meeting2} {  Date: 12/14 14:00 - 17:00} {  Planned Participants (Utility):} {    memberA(60),  memberB(50), memberD(30), memberE(20),} {    memberG(100), memberH(90), member(70)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[41]},

    /* [41] meeting3
     */
    {HdAT_Single,	"0.20.3",
       "/db/HKB/v1/test/local/app/demo01/meeting3",	"meeting3",
       NULL,	NULL,	NULL,	{"ss123", NULL, NULL},
       NULL,	AS_NotActive,	2,
       "{  Meeting Name: meeting3} {  Date: 12/14 14:00 - 17:00} {  Planned Participants (Utility):} {    memberA(20), memberC(100), memberE(80),} {    memberF(70), memberH(50),  memberI(40).}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[42]},

    /* [42] memberA
     */
    {HdAT_Single,	"0.20.4",
       "/db/HKB/v1/test/local/app/demo01/memberA",	"memberA",
       NULL,	NULL,	NULL,	{"zeus", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(100)} {    meeting2(20)} {    meeting3(80)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[43]},

    /* [43] memberB
     */
    {HdAT_Single,	"0.20.5",
       "/db/HKB/v1/test/local/app/demo01/memberB",	"memberB",
       NULL,	NULL,	NULL,	{"zeus", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(90)} {    meeting2(10)} {    meeting3(70)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[44]},

    /* [44] memberC
     */
    {HdAT_Single,	"0.20.6",
       "/db/HKB/v1/test/local/app/demo01/memberC",	"memberC",
       NULL,	NULL,	NULL,	{"zeus", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(100)} {    meeting2(50)} {    meeting3(30)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[45]},

    /* [45] memberD
     */
    {HdAT_Single,	"0.20.7",
       "/db/HKB/v1/test/local/app/demo01/memberD",	"memberD",
       NULL,	NULL,	NULL,	{"zeus", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(20)} {    meeting2(00)} {    meeting3(50)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[46]},

    /* [46] memberE
     */
    {HdAT_Single,	"0.20.8",
       "/db/HKB/v1/test/local/app/demo01/memberE",	"memberE",
       NULL,	NULL,	NULL,	{"ss126", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(30)} {    meeting2(50)} {    meeting3(70)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[47]},

    /* [47] memberF
     */
    {HdAT_Single,	"0.20.9",
       "/db/HKB/v1/test/local/app/demo01/memberF",	"memberF",
       NULL,	NULL,	NULL,	{"ss126", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(10)} {    meeting2(30)} {    meeting3(90)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[48]},

    /* [48] memberG
     */
    {HdAT_Single,	"0.20.10",
       "/db/HKB/v1/test/local/app/demo01/memberG",	"memberG",
       NULL,	NULL,	NULL,	{"ss126", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(100)} {    meeting2(50)} {    meeting3(10)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[49]},

    /* [49] memberH
     */
    {HdAT_Single,	"0.20.11",
       "/db/HKB/v1/test/local/app/demo01/memberH",	"memberH",
       NULL,	NULL,	NULL,	{"ss123", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(40)} {    meeting2(70)} {    meeting3(20)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[50]},

    /* [50] memberI
     */
    {HdAT_Single,	"0.20.12",
       "/db/HKB/v1/test/local/app/demo01/memberI",	"memberI",
       NULL,	NULL,	NULL,	{"ss123", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(50)} {    meeting2(40)} {    meeting3(10)}",
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[51]},

    /* [51] memberJ
     */
    {HdAT_Single,	"0.20.13",
       "/db/HKB/v1/test/local/app/demo01/memberJ",	"memberJ",
       NULL,	NULL,	NULL,	{"ss123", NULL, NULL},
       NULL,	AS_NotActive,	3,
       "{  Preference:} {    meeting1(100)} {    meeting2(90)} {    meeting3(70)}",
       &hdTestHiaInfo[38],	NULL,	NULL},

    /* [52] meeting4
     */
    {HdAT_Single,	"0.20.14",
       "/db/HKB/v1/test/local/app/demo01/meeting4",	"meeting4",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	2,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[53]},

    /* [53] meeting5
     */
    {HdAT_Single,	"0.20.15",
       "/db/HKB/v1/test/local/app/demo01/meeting5",	"meeting5",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	2,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[54]},

    /* [54] meeting6
     */
    {HdAT_Single,	"0.20.16",
       "/db/HKB/v1/test/local/app/demo01/meeting6",	"meeting6",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	0,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[55]},

    /* [55] memberK
     */
    {HdAT_Single,	"0.20.17",
       "/db/HKB/v1/test/local/app/demo01/memberK",	"memberK",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[56]},

    /* [56] memberL
     */
    {HdAT_Single,	"0.20.18",
       "/db/HKB/v1/test/local/app/demo01/memberL",	"memberL",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[57]},

    /* [57] memberM
     */
    {HdAT_Single,	"0.20.19",
       "/db/HKB/v1/test/local/app/demo01/memberM",	"memberM",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[58]},

    /* [58] memberN
     */
    {HdAT_Single,	"0.20.20",
       "/db/HKB/v1/test/local/app/demo01/memberN",	"memberN",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[59]},

    /* [59] memberO
     */
    {HdAT_Single,	"0.20.21",
       "/db/HKB/v1/test/local/app/demo01/memberO",	"memberO",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[60]},

    /* [60] memberP
     */
    {HdAT_Single,	"0.20.22",
       "/db/HKB/v1/test/local/app/demo01/memberP",	"memberP",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[61]},

    /* [61] memberQ
     */
    {HdAT_Single,	"0.20.23",
       "/db/HKB/v1/test/local/app/demo01/memberQ",	"memberQ",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[62]},

    /* [62] memberR
     */
    {HdAT_Single,	"0.20.24",
       "/db/HKB/v1/test/local/app/demo01/memberR",	"memberR",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[63]},

    /* [63] memberS
     */
    {HdAT_Single,	"0.20.25",
       "/db/HKB/v1/test/local/app/demo01/memberS",	"memberS",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[64]},

    /* [64] memberT
     */
    {HdAT_Single,	"0.20.26",
       "/db/HKB/v1/test/local/app/demo01/memberT",	"memberT",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[65]},

    /* [65] memberU
     */
    {HdAT_Single,	"0.20.27",
       "/db/HKB/v1/test/local/app/demo01/memberU",	"memberU",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[66]},

    /* [66] memberV
     */
    {HdAT_Single,	"0.20.28",
       "/db/HKB/v1/test/local/app/demo01/memberV",	"memberV",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[67]},

    /* [67] memberW
     */
    {HdAT_Single,	"0.20.29",
       "/db/HKB/v1/test/local/app/demo01/memberW",	"memberW",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[68]},

    /* [68] memberX
     */
    {HdAT_Single,	"0.20.30",
       "/db/HKB/v1/test/local/app/demo01/memberX",	"memberX",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[69]},

    /* [69] memberY
     */
    {HdAT_Single,	"0.20.31",
       "/db/HKB/v1/test/local/app/demo01/memberY",	"memberY",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	&hdTestHiaInfo[70]},

    /* [70] memberZ
     */
    {HdAT_Single,	"0.20.32",
       "/db/HKB/v1/test/local/app/demo01/memberZ",	"memberZ",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[38],	NULL,	NULL},

    /* [71] f_agent; parametric agents defined by z-yanaga on Febraury 3rd in '95
     *		from hdTestHiaInfo[71]
     *		to   hdTestHiaInfo[75]
     */
    {HdAT_Complex,	"0.30",
       NULL,	"f_agent",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	1,	NULL,
       NULL,	&hdTestHiaInfo[72],	NULL},

    /* [72] player
     */
    {HdAT_Parametric,	"0.30.1",
       "/db/HKB/v1/test/local/app/f_agent/cmd_player/player",	"player",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[71],	NULL,	&hdTestHiaInfo[73]},

    /* [73] team
     */
    {HdAT_Parametric,	"0.30.2",
       "/db/HKB/v1/test/local/app/f_agent/cmd_team/team",	"team",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[71],	NULL,	&hdTestHiaInfo[74]},

    /* [74] sync
     */
    {HdAT_Single,	"0.30.3",
       "/db/HKB/v1/test/local/app/f_agent/cmd_sync/sync",	"sync",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[71],	NULL,	&hdTestHiaInfo[75]},

    /* [75] arithmetic
     */
    {HdAT_Single,	"0.30.4",
       "/db/HKB/v1/test/local/app/f_agent/cmd_arithmetic/arithmetic",
       "arithmetic",
       NULL,	NULL,	NULL,	{NULL, NULL, NULL},
       NULL,	AS_NotActive,	3,	NULL,
       &hdTestHiaInfo[71],	NULL,	NULL},

};

#endif /* _DEBUG_HELIOSD */
