/* hdAppGuiInfo.c
 *	module to handle Application Gui information
 *
 *		created by k3sato on September 1st in 1994.
 *
 * $Id: hdAppGuiInfo.c,v 1.2 1994/11/25 06:03:43 k3sato Exp $
 */

#include <stdio.h>

#include <helios/heliosd.h>
#include <helios/hdMessage.h>
#include "hdcommon.h"

#ifdef _DEBUG_HELIOSD
/*	defined in hdTestAppGuiInfo.c
 */
extern AgentInfo	hdTestAppGuiInfo;
#endif /* _DEBUG_HELIOSD */


static HdBoolean hdSetupHostName2AppGuiInfo();

/*
 *	get informations from files named helios.gui
 */
HdBoolean hdGetAppGuiInfo(hdCtlInfo, allAppGuis)
    HeliosdCtlInfo	*hdCtlInfo;
    HAgentInfo		*allAppGuis;
{
    HeliosdErrorMsgType	eMsgType;

#ifdef _DEBUG_HELIOSD
    *allAppGuis = &hdTestAppGuiInfo;
#endif /* _DEBUG_HELIOSD */

    if (hdSetupHostName2AppGuiInfo(*allAppGuis, hdCtlInfo->machInfo->hostName)
	== HdFalse) {
	eMsgType = HdEMsg_SetupHostName2AppGuiInfo;
	goto Error_Rtn;
    }

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *
 */
static HdBoolean hdSetupHostName2AppGuiInfo(agentInfo, hostName)
    HAgentInfo	agentInfo;
    char	*hostName;
{
    HeliosdErrorMsgType	eMsgType;

    for (; agentInfo != NULL; agentInfo = agentInfo->next) {
	if ((agentInfo->sockInfo.hostName = HdMallocString(hostName)) == NULL) {
	    eMsgType = HdEMsg_HdMallocStringError;
	    goto Error_Rtn;
	}
    }

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *
 */
HdBoolean hdSearchAppGuiInfo(hHdCtlInfo, agentName, agentInfo)
    HHeliosdCtlInfo	hHdCtlInfo;
    char		*agentName;
    HAgentInfo		*agentInfo;
{
    HAgentInfo		currInfo;
    HeliosdErrorMsgType	eMsgType;

    if (hHdCtlInfo == NULL) {
	eMsgType = HdEMsg_NotDefinedHdCtlInfo;
	goto Error_Rtn;
    }

    if (agentName == NULL) {
	eMsgType = HdEMsg_NotDefinedAgentName;
	goto Error_Rtn;
    }

    for (currInfo = hHdCtlInfo->appGuiInfo; currInfo!= NULL
	 ; currInfo = currInfo->next) {
	if (strcmp(currInfo->agentName, agentName) == 0) {
	    *agentInfo = currInfo;
	    return HdTrue;
	}
    }

    eMsgType = HdEMsg_NotDefinedAppGuiInfo;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}
