#include <stdio.h>
#include "mem.h"

/* memory management routine cited from K&R */
#define FREE_MEM 32768
unsigned char mem[FREE_MEM];

struct head {
  struct head *ptr;
  unsigned int size;
};

static struct head base;
static struct head *freep = NULL;

static struct head *
morecore (unsigned int nu)
{
  static struct head *b = (struct head *)&mem;
  struct head *ob = b;

  if ((int)(b + nu) - (int)mem > FREE_MEM)
    return NULL;

  b += nu;
  ob->size = nu;
  my_free ((void *)(ob+1));
  return freep;
}

void *
my_malloc (unsigned int size)
{
  struct head *p, *prevp;
  unsigned nunits;

  nunits = (size + sizeof (struct head *)-1)/sizeof (struct head *) + 1;
  if ((prevp = freep) == NULL)
    {
      base.ptr = freep = prevp = &base;
      base.size = 0;
    }
  for (p = prevp->ptr; ; prevp = p, p = p->ptr)
    {
      if (p->size >= nunits)
	{
	  if (p->size == nunits)
	    prevp->ptr = p->ptr;
	  else
	    {
	      p->size -= nunits;
	      p += p->size;
	      p->size = nunits;
	    }
	  freep = prevp;
	  return (void *) (p+1);
	}
      if (p == freep)
	if ((p = morecore (nunits)) == NULL)
	  return NULL;
    }
}

void
my_free (void *ap)
{
  struct head *bp, *p;

  bp = (struct head *)ap - 1;
  for (p = freep; !(bp > p && bp < p->ptr); p = p->ptr)
    if (p >= p->ptr && (bp > p || bp < p->ptr))
      break;

  if (bp + bp->size == p->ptr)
    {
      bp->size += p->ptr->size;
      bp->ptr = p->ptr->ptr;
    }
  else
    bp->ptr = p->ptr;

  if (p + p->size == bp)
    {
      p->size += bp->size;
      p->ptr = bp->ptr;
    }
  else
    p->ptr = bp;
  freep = p;
}
