#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <signal.h>
#include <helios/comm.h>
#include <helios/event.h>

static int alarm_set;
fd_set io_r_fds, io_w_fds, io_e_fds;
int fd_to_event[FD_SETSIZE];

int
select_event (int *data_p)
{
  static int event;
  fd_set io_r_fds1, io_w_fds1, io_e_fds1;
  struct timeval ev_timeout;
  int i, r;

  while (1)
    {
      if (alarm_set)
	{
	  alarm_set = 0;
	  return EVENT_ALARM;
	}

      if (event & EVENT_MESSAGE_RECEIVE_READY)
	{
	  event &= ~EVENT_MESSAGE_RECEIVE_READY;
	  return EVENT_MESSAGE_RECEIVE_READY;
	}

      if (event & EVENT_MESSAGE_SEND_READY)
	{
	  event &= ~EVENT_MESSAGE_SEND_READY;
	  return EVENT_MESSAGE_SEND_READY;
	}

      if (event & EVENT_DEBUG)
	{
	  int r;
	  struct timeval timeout;
	  fd_set fds;

	  timeout.tv_sec  = 0;
	  timeout.tv_usec = 0;

	  FD_ZERO (&fds);
	  FD_SET (udp_sock, &fds);
	  r = select (FD_SETSIZE, &fds, 0, 0, &timeout);
	  if (r == 0 || receive_datagram () == 0)
	    event &= ~EVENT_DEBUG;
	  else
	    return EVENT_DEBUG;
	}

      if (event & EVENT_IO_READY_ALL)
	{
	  for (i=0; i<FD_SETSIZE; i++)
	    if (fd_to_event[i])
	      {
		int e = fd_to_event[i];
		*data_p = i;
		fd_to_event[i] = 0;

		return e;
	      }

	  event &= ~EVENT_IO_READY_ALL;
	}

      /* no event, so select and wait */
      ev_timeout.tv_sec = 10000;
      ev_timeout.tv_usec = 0;
      memcpy (&io_r_fds1, &io_r_fds, sizeof (fd_set));
      memcpy (&io_w_fds1, &io_w_fds, sizeof (fd_set));
      memcpy (&io_e_fds1, &io_e_fds, sizeof (fd_set));
      r = select (FD_SETSIZE, &io_r_fds1, &io_w_fds1, &io_e_fds1, &ev_timeout);
      if (r <= 0)
	{
	  r = 0;
	  continue;
	}

      if (FD_ISSET (listen_sock, &io_r_fds1))
	{
	  FD_CLR (listen_sock, &io_r_fds1);
	  r--;
	  accept_socket ();
	}

      if (udp_sock > 0 && FD_ISSET (udp_sock, &io_r_fds1))
	{
	  FD_CLR (udp_sock, &io_r_fds1);
	  r--;
	  event |= EVENT_DEBUG;
	}

      for (i=0; r > 0 && i < FD_SETSIZE; i++)
	{
	  fd_to_event[i] = 0;
	  if (FD_ISSET (i, &io_r_fds1))
	    {
	      FD_CLR (i, &io_r_fds1);
	      r--;

	      if (fd_to_agent[i])
		{
		  if (read_from_socket (fd_to_agent[i]))
		    event |= EVENT_MESSAGE_RECEIVE_READY;
		}
	      else
		{
		  fd_to_event[i] = EVENT_IO_READY_READ;
		  event |= EVENT_IO_READY_READ;
		}
	    }

	  if (FD_ISSET (i, &io_w_fds1))
	    {
	      FD_CLR (i, &io_w_fds1);
	      r--;
	      if (fd_to_agent[i])
		{
		  if (write_to_socket (fd_to_agent[i]))
		    event |= EVENT_MESSAGE_SEND_READY;
		}
	      else
		{
		  fd_to_event[i] = EVENT_IO_READY_WRITE;
		  event |= EVENT_IO_READY_WRITE;
		}
	    }

	  if (FD_ISSET (i, &io_e_fds1))
	    {
	      FD_CLR (i, &io_e_fds1);
	      r--;
	      fd_to_event[i] = EVENT_IO_READY_EXCEPT;
	      event |= EVENT_IO_READY_EXCEPT;
	    }
	}
    }
}

int
register_fd (int fd, int operation)
{
  if (operation & FD_EV_READ)
    FD_SET (fd, &io_r_fds);
  if (operation & FD_EV_WRITE)
    FD_SET (fd, &io_w_fds);
  if (operation & FD_EV_EXCEPT)
    FD_SET (fd, &io_e_fds);
  return 0;
}

int
register_timer (int microsecond, int interval, int data)
{
  struct  itimerval it;
  if (interval)
    {
      it.it_interval.tv_sec = 0;
      it.it_interval.tv_usec = microsecond;
      it.it_value.tv_sec = 0;
      it.it_value.tv_usec = microsecond;
    }
  else
    {
      it.it_interval.tv_sec = 0;
      it.it_interval.tv_usec = 0;
      it.it_value.tv_sec = 0;
      it.it_value.tv_usec = microsecond;
    }

  setitimer (ITIMER_REAL, &it, NULL);
  return 0;
}

static void
got_alarm (void)
{
  alarm_set = 1;
}

void
poll (void)
{
  sigpause (0);
}

void
init_event (void)
{
  alarm_set = 0;
  signal (SIGALRM, got_alarm);
  FD_ZERO (&io_r_fds);
  FD_ZERO (&io_w_fds);
  FD_ZERO (&io_e_fds);
}
