#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"multiParse.h"
#include"CommonType.h"
#include"commonParse.h"
#include"liblocal.h"
#include"libcommon.h"
#include"localParse.h"
#include"localConst.h"
#include"CAppConv.h"

#define SEPA ','

CDATA CLocalConv(char *def0,CDATA stack0);
CDATA CCommonConv(char *def0,CDATA stack0);
CDATA CLocalTypeConv(char *fromType,char *toType,CDATA element);
int selectType(char *string);
CDATA intToATOM(CDATA element);
CDATA strToATOM(CDATA element);
CDATA boolToATOM(CDATA element);
CDATA AtomToint(CDATA element);
CDATA ATOMTostr(CDATA element);
CDATA AOMTTobool(CDATA element);



CDATA CLocalConv(char *def0,CDATA stack0){ /* common to local */

 char *def;
 char *tag;
 char *commonType;
 char *localType;
 char buf[1024];
 CDATA stack;
 CDATA newStack;
 CDATA newStack1;
 CDATA element;
 CDATA element1;
 CDATA element2;
 CDATA data;
 CDATA data2;
 CDATA data3;
 int i,j;

 newStack = CNew(0,3);
 
 def = strdup(def0);
 stack = CDuplicate(stack0);
 
 for(i=0;tag = CTGetTag(stack,i);i++){
   if(strchr(tag,':')) continue;
   
   sprintf(buf,"%s:",tag);
   element = CTGetElement(stack,buf);
   commonType = CBGetString(element);
   
   localType =  CGetTypeLocal(tag,def);
   if(localType == NULL) return NULL;

   data = CTGetElement(stack,tag);
   
   data2 = CNew(0,2);
   for(j=0;(element1 = CLGetElement(data,j));j++){
     element2 = CAPPTypeConvCommonLocal(commonType,localType,element1);
     data3 = CLPutElement(data2,j,element2);
     CDelete(data2);
     data2 = data3;
   }
   newStack1 = CTPutElement(newStack,tag,data2);
   CDelete(data2);
   CDelete(newStack);
   sprintf(buf,"%s:",tag);
   data3 = CNew(2,0);
   data3 = CBPutString(data3,localType);
   newStack = CTPutElement(newStack1,buf,data3);
   CDelete(newStack1);
 }
 free(localType);
 free(commonType);
 return newStack;
}


CDATA CCommonConv(char *def0,CDATA stack0){ /* local to common */

 char *def;
 char *tag;
 char *commonType;
 char *localType;
 char buf[1024];
 CDATA stack;
 CDATA newStack;
 CDATA newStack1;
 CDATA element;
 CDATA element1;
 CDATA element2;
 CDATA data;
 CDATA data2;
 CDATA data3;
 int i,j;

 newStack = CNew(0,3);
 
 def = strdup(def0);
 stack = CDuplicate(stack0);
 
 for(i=0;tag = CTGetTag(stack,i);i++){
   if(strchr(tag,':')) continue;
   
   sprintf(buf,"%s:",tag);
   element = CTGetElement(stack,buf);
   localType = CBGetString(element);
   
    commonType =  CGetTypeCommon(tag,def);
   if(localType == NULL) return NULL;

   data = CTGetElement(stack,tag);
   
   data2 = CNew(0,2);
   for(j=0;(element1 = CLGetElement(data,j));j++){
     element2 = CAPPTypeConvLocalCommon(commonType,localType,element1);
     data3 = CLPutElement(data2,j,element2);
     CDelete(data2);
     CDelete(element1);
     CDelete(element2);
     data2 = data3;
   }
   free(localType);
   free(commonType);
   newStack1 = CTPutElement(newStack,tag,data2);
   CDelete(data);
   CDelete(data2);
   CDelete(newStack);
   sprintf(buf,"%s:",tag);
   data3 = CNew(2,0);
   data3 = CBPutString(data3,localType);
   newStack = CTPutElement(newStack1,buf,data3);
   CDelete(newStack1);
 }
 return newStack;
}

CDATA CLocalTypeConv(char *fromType,char *toType,CDATA element){

  CDATA ret;

  switch(selectType(fromType)) {
  case 1:
    ret = intToATOM(element);
    break;
  case 2:
    ret = strToATOM(element);
    break;
  case 3:
    ret = boolToATOM(element);
    break;
  case 11:
    switch(selectType(toType)){
    case 1:
      ret = AtomToint(element);
      break;
    case 2:
      ret = ATOMTostr(element);
      break;
    case 3:
      ret = AOMTTobool(element);
      break;
    }
    break;
  case 0:
    ret = CAPPTypeConvLocalCommon(fromType,toType,element);
  }
  return ret;
}


int selectType(char *string){

  if(strcmp(string,"int") == NULL) return 1;
  if(strcmp(string,"str") == NULL) return 2;
  if(strcmp(string,"bool") == NULL) return 3;
  
  if(strcmp(string,"ATOM") == NULL) return 11;

  return 0;
}


CDATA intToATOM(CDATA element){

 long val;
 char *sval;
 char buf[1024];
 CDATA ret;

 val = CBGetInt(element);

 sprintf(buf,"%ld",val);

 sval =strdup(buf);

 ret = CNew(2,0);
 ret = CBPutString(ret,sval);

 return ret;
}


CDATA strToATOM(CDATA element){

 return CDuplicate(element);
}


CDATA boolToATOM(CDATA element){

 int val;
 char *sval;
 char buf[1024];
 CDATA ret;

 val = CBGetBool(element);

 if(val) sprintf(buf,"true");
 else    sprintf(buf,"false");

 sval =strdup(buf);

 ret = CNew(2,0);
 ret = CBPutString(ret,sval);

 return ret;
}


CDATA AtomToint(CDATA element){
  
  char *val;
  CDATA ret;
  
  ret = CNew(1,0);
  
  val = CBGetString(element);

  ret = CBPutInt(ret,atoi(val));
	   
  return ret;
}

CDATA ATOMTostr(CDATA element){

 return CDuplicate(element);  
}

CDATA AOMTTobool(CDATA element){

 int val;
 char *sval;
 CDATA ret;

 sval = CBGetString(element);

 if(strcmp(sval,"true") == 0) val = 1;
 else  val = 0;
 
 ret = CNew(1,0);
 ret = CBPutInt(ret,val);
 
 return ret;
}
