#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#define BUFFERSIZE 65536
#define LINEBUF 1024

char **pline(int status,char *buffer,char *args[]);
void  dummy();

char buffer[LINEBUF];
char method[BUFFERSIZE],*mp;
char convert[BUFFERSIZE],*cp;

int main(int argc,char *argv[]) {

  int status,i;

  FILE *fp;

  char *p;  
  for(i=0;i<BUFFERSIZE;i++) method[i]='\0';
  for(i=0;i<BUFFERSIZE;i++) convert[i]='\0';

  mp = method;
  cp = convert;

  dummy();

  if(argc < 2 ) {
    printf("clec conv file\n");
    return 9;
  }

  status = 0;
  
  for(i=1;i<argc;i++) {
    fp = fopen(argv[i],"r");
    if(fp == NULL) {
      printf("File open error %s\n",argv[1]);
      return 7;
    }
    
    fgets(buffer,BUFFERSIZE,fp); /* Agent type must be common */
    if(strncmp(buffer,"complex",7)!=0) continue;

    fgets(buffer,BUFFERSIZE,fp); /* agent Name */
    
    fgets(buffer,BUFFERSIZE,fp); /* AgentID */

    p = strchr(buffer,'\n');
    if(p) *p = '\0';

    sprintf(mp,"\"%s\",\n",buffer);
    mp += strlen(mp);
    sprintf(cp,"\"%s\",\n",buffer);
    cp += strlen(cp);
    
    fgets(buffer,BUFFERSIZE,fp); /* Agent type is not effective */

    
    makeBuf(fp);
    
    sprintf(mp,"NULL,   /* end of Agent */ \n");
    mp += strlen(mp);
    sprintf(cp,"NULL,   /* end of Agent */\n");
    cp += strlen(cp);
    fclose(fp);
  }

  fp = fopen("CEnvConvData.c","w");

  if(fp == NULL) {
    printf("File open error CEnvConvData.c\n");
    return 0;
  }

  *mp = NULL;
  *cp = NULL;
  mp = method;
  cp = convert;

  fputs("#include <stdio.h>\n",fp);
  fputs("#include <stdlib.h>\n",fp);
  fputs("char *CEMethodTable[] = {\n",fp);

  while(*mp) putc(*mp++,fp);
  fputs("NULL\n};  /* end of method */ \n",fp);

  fputs("char *CETypeTable[] = {\n",fp);
  while(*cp) putc(*cp++,fp);
  fputs("NULL\n};  /* end of convert */ \n",fp);

  fclose(fp);

  return 0;
}


int makeBuf(FILE *fp){

  int status;
  char *p;
  char *args[11];

  while(fgets(buffer,BUFFERSIZE,fp)){

    p = buffer;
    while(p = strchr(buffer,'.')) *p = ' ';

    if(strcmp(buffer,"import\n")== 0) status = 1;
    else if(strcmp(buffer,"export\n")== 0) status = 2;
    else if(strcmp(buffer,"conv\n")== 0) status = 5;
    else {
      pline(status,buffer,args);
      if(args[0] == NULL) break;
      switch(status) {
      case 0:
	break;
      case 1: /* import */
	sprintf(mp,"\"%s\",  /* begin of method */\n",args[0]);
	mp += strlen(mp);
	sprintf(mp,"%s,\n","NULL");
	mp += strlen(mp);
	sprintf(mp,"%s,\n","NULL");
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[1]);
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[2]);
	mp += strlen(mp);
	sprintf(mp,"\"%s\",\n",args[5]);
	mp += strlen(mp);
	if(args[3]) 
	  sprintf(mp,"\"%s\",\n",args[3]);
	else
	  sprintf(mp,"%s,\n","NULL");	  
	mp += strlen(mp);
	if(args[4]) 
	  sprintf(mp,"\"%s\",\n",args[4]);
	else
	  sprintf(mp,"%s,\n","NULL");	  
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[6]);
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[7]);
	mp += strlen(mp);
	break;
      case 2: /* export */
	sprintf(mp,"\"%s\",  /* begin of method */\n",args[5]);
	mp += strlen(mp);
	if(args[3]) 
	  sprintf(mp,"\"%s\",\n",args[3]);
	else
	  sprintf(mp,"%s,\n","NULL");	  
	mp += strlen(mp);
	if(args[4]) 
	  sprintf(mp,"\"%s\",\n",args[4]);
	else
	  sprintf(mp,"%s,\n","NULL");	  
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[6]);
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[7]);
	mp += strlen(mp);
	sprintf(mp,"\"%s\",\n",args[0]);
	mp += strlen(mp);
	sprintf(mp,"%s,\n","NULL");
	mp += strlen(mp);
	sprintf(mp,"%s,\n","NULL");
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[1]);
	mp += strlen(mp);
	sprintf(mp,"\"<%s>\",\n",args[2]);
	mp += strlen(mp);
	break;
      case 5: /* comvert */
	sprintf(cp,"\"%s\",  /* begin of conv */ \n",args[1]);
	cp += strlen(cp);
	sprintf(cp,"\"%s\",\n",args[0]);
	cp += strlen(cp);
	sprintf(cp,"\"%s\",\n",args[3]);
	cp += strlen(cp);
	sprintf(cp,"\"%s\",\n",args[2]);
	cp += strlen(cp);
	break;
      }
    }
  }
}



char **pline(int status,char *buffer,char *args[]) {

 char *p;
 char *q;

 p = buffer;

 if(*buffer == '\n') {
   args[0] = NULL;
   return NULL;
 }

 switch(status) {
 case 1:
 case 2:
   args[0] = p;

   p = strchr(p,'@');
   *p++ = '\0';
   args[1] = p;
   p = strstr(p,"->");
   *p++ = '\0';
   p++;
   args[2] = p;
   p = strstr(p,"=>");
   *p++ = '\0';
   p++;
   args[3] = p;
   p = strchr(p,'!');
   *p++ = '\0';
   args[5] = p;

   if((q = strchr(args[3],','))) {
     *q++ = '\0';
     args[4] = q;
   } else args[4] = NULL;

   p = strchr(p,'@');
   *p++ = '\0';
   args[6] = p;
   p = strstr(p,"->");
   *p++ = '\0';
   p++;
   args[7] = p;
   p = strchr(p,'\n');
   *p = NULL;
   args[8] = NULL;
   break;
 case 5:
   args[0] = p;
   p = strstr(p,"<=>");
   *p++ = NULL;
   p++;
   p++;
   args[2] = p;
   p = strrchr(p,':');
   *p++ = NULL;
   args[3] = p;
   p = strchr(p,'\n');
   *p = NULL;
   p = strrchr(args[0],':');
   *p++ = NULL;
   args[1] = p;
   args[4] = NULL;
   break;
 }

return args;
}

void dummy() {
;
}
