#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"multiParse.h"
#include"CommonType.h"
#include"commonParse.h"

int checkStructLocal(char *string);
char **parseStructLocal(char *string,int type);
char *CStructToLocal(CDATA data,char *buf);
CDATA CLocalToStruct(char *string0);

int checkStructLocal(char *string){
  
  if(checkParse(0,'(',' ',')',string)) return 2;  /* list      2*/    
  if(checkParse(1,'(',' ',')',string)) return 5;  /* clisr     5*/
  return 0; /* not struct */
}

char **parseStructLocal(char *string,int type){

  char **p;

  switch(type){

  case 0:
    p = malloc(sizeof(char*)*2);
    p[0] = string;
    p[1] = NULL;
    return p;
  case 2:
    return multiParse(0,'(',' ',')',string);   /* list      2*/    
    break;
  case 5:
    return multiParse(1,'(',' ',')',string);   /* clist   5*/
  default:
    return NULL;
  }
}

char *CStructToLocal(CDATA data,char *buf){

 int base,type;
 char *p;
 CDATA tmp;

 if(data == NULL) return NULL;

 base = data->base;
 type = data->type;

 switch(base){
 case 0: /* Structure */
   p = buf;
   tmp = data;

   switch(type) {
   case 2: /* list */
     *p++ = '(';
       while(tmp != NULL) {
       p = CStructToLocal(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ' ';
     }
     *p++ = ')';
     break;
   case 5: /* functor */
       p = CStructToLocal(tmp->data.element,p);
       tmp = tmp->next.element;
     *p++ = '(';
       while(tmp != NULL) {
       p = CStructToLocal(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ' ';
     }
     *p++ = ')';
     break;

   }
   break;
 case 2: /* ATOM */
   sprintf(buf,"%s",data->data.string);
   p = buf + strlen(buf);
   break;
 default:
    return NULL;
 }
 *p = NULL;
 return p;
}

CDATA CLocalToStruct(char *string0){

  int i;
  int type;
  char **parsed;
  char string[2048];
  CDATA element0;
  CDATA data0,data1;


  strcpy(string,string0);

  type = checkStructLocal(string);
  
  switch(type){
  case 0: /* Not Structed */
    /* ATOM */
    data0 = CNew(2,0);
    data0 = CBPutString(data0,string);
    break;
  case 2: /* list */
    data0 = CNew(0,2);
    parsed = multiParse(0,'(',' ',')',string);
    i = 0;
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CLocalToStruct(parsed[i]);
      data1 = CLPutElement(data0,i,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;
    }
    break;
  case 5: /* clist */
    data0 = CNew(0,5);
    parsed = multiParse(1,'(',' ',')',string);
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CLocalToStruct(parsed[i]);
      data1 = CFPutElement(data0,i,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;
    }
    break;


  default:
    break;
  }
  return data0;
}

