#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include <multiParse.h>
#include <CommonType.h>
#include <commonParse.h>

int checkStructCommon(char *string);
char **parseStructCommon(char *string,int type);
char *CStructToCommon(CDATA data,char *buf);
CDATA CCommonToStruct(char *string0);

int checkStructCommon(char *string){
  
  if(checkParse(0,'<',',','>',string)) return 1;  /* vector    1*/
  if(checkParse(0,'[',',',']',string)) return 2;  /* list      2*/    
  if(checkParse(0,'(',',',')',string)) return 3;  /* tupple    3*/
  if(checkParse(0,'{',',','}',string)) return 4;  /* set       4*/
  if(checkParse(1,'(',',',')',string)) return 5;  /* functor   5*/
  return 0; /* not struct */
  
}

char **parseStructCommon(char *string,int type){

  char **p;

  switch(type){

  case 0:
    p = malloc(sizeof(char*)*2);
    p[0] = string;
    p[1] = NULL;
    return p;
  case 1:
    return multiParse(0,'<',',','>',string);   /* vector    1*/
    break;
  case 2:
    return multiParse(0,'[',',',']',string);   /* list      2*/    
    break;
  case 3:
    return multiParse(0,'(',',',')',string);   /* tupple    3*/
    break;
  case 4:
    return multiParse(0,'{',',','}',string);   /* set       4*/
    break;
  case 5:
    return multiParse(1,'(',',',')',string);   /* functor   5*/
  default:
    return NULL;
  }
}

char *CStructToCommon(CDATA data,char *buf){

 int base,type;
 char *p;
 CDATA tmp;

 if(data == NULL) return NULL;

 base = data->base;
 type = data->type;

 switch(base){
 case 0: /* Structure */
   p = buf;
   tmp = data;

   switch(type) {
   case 1: /* vector */
     *p++ = '<';
       while(tmp != NULL) {
       p = CStructToCommon(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ',';
     }
     *p++ = '>';
     break;
   case 2: /* list */
     *p++ = '[';
       while(tmp != NULL) {
       p = CStructToCommon(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ',';
     }
     *p++ = ']';
     break;
   case 3: /* tupple */
     *p++ = '(';
       while(tmp != NULL) {
       p = CStructToCommon(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       *p++ = '=';
       p = CStructToCommon(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ',';
     }
     *p++ = ')';
     break;
   case 4: /* set */
     *p++ = '{';
       while(tmp != NULL) {
       p = CStructToCommon(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ',';
     }
     *p++ = '}';
     break;
   case 5: /* vector */
     p = CStructToCommon(tmp->data.element,p);
     tmp = tmp->next.element;
     *p++ = '(';
       while(tmp != NULL) {
       p = CStructToCommon(tmp->data.element,p);
       if(p == NULL) return NULL;
       tmp = tmp->next.element;
       if(tmp) *p++ = ',';
     }
     *p++ = ')';
     break;
   default:
     break;
   }
   break;
 case 1: /* integer */
   sprintf(buf,"%ld",data->data.integer);
   p = buf + strlen(buf);
   break;
 case 2: /* string */
   sprintf(buf,"\"%s\"",data->data.string);
   p = buf + strlen(buf);
   break;
 case 3: /* bool */
   if(data->data.bool) {
     sprintf(buf,"true");
   }else {
     sprintf(buf,"false");
   }
   p = buf + strlen(buf);
   break;
 }
 *p = NULL;
 return p;
}

CDATA CCommonToStruct(char *string0){

  int i;
  int type;
  char **parsed;
  char *tag,*val;
  char *p,*q;
  char buf1[256];
  char buf2[256];
  char string[2048];
  CDATA element0;
  CDATA data0,data1;

  if(string0 == NULL) return NULL;
  if(*string0 == '\0') return NULL;

  strcpy(string,string0);

  type = checkStructCommon(string);

  switch(type){
  case 0: /* Not Structed */
    for(p = string;*p != NULL;p++) {
      if(!isdigit(*p)) {
	type = 1;
	break;
      }
    }
    if(type != 1) {
      /* integer */
      data0 = CNew(1,0);
      data0 = CBPutInt(data0,atoi(string));
    }else if(strcmp(string,"true") == 0 || strcmp(string,"TRUE") == 0 ){
      /* bool */
      data0 = CNew(3,0);
      data0 = CBPutBool(data0,1);
    }else if(strcmp(string,"false") == 0 || strcmp(string,"FALSE") == 0){
      /* bool */
      data0 = CNew(3,0);
      data0 = CBPutBool(data0,0);
    }else {
      /* string */
      data0 = CNew(2,0);
      p = string;
      if(*p == '"') {
	q = ++p;
	q = strrchr(q,'"');
	*q = NULL;
      }
      data0 = CBPutString(data0,p);
    }
    break;
  case 1: /* vector */
    data0 = CNew(0,1);
    parsed = multiParse(0,'<',',','>',string);
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CCommonToStruct(parsed[i]);
      data1 = CVPutElement(data0,i,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;
    }
    break;
  case 2: /* list */
    data0 = CNew(0,2);
    parsed = multiParse(0,'[',',',']',string);
    i = 0;
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CCommonToStruct(parsed[i]);
      data1 = CLPutElement(data0,i,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;
    }
    break;
  case 3: /* tupple */
    data0 = CNew(0,3);
    parsed = multiParse(0,'(',',',')',string);
    for(i = 0;parsed[i] != NULL;i++){
      tag = CGetTag(parsed[i],buf1);
      val = CGetVal(parsed[i],buf2);
      while(*val != '=') val++;
      val++;
      element0 = CCommonToStruct(val);
      data1 = CTPutElement(data0,tag,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;      
    }
    break;
  case 4: /* set */
    data0 = CNew(0,4);
    parsed = multiParse(0,'{',',','}',string);
    i = 0;
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CCommonToStruct(parsed[i]);
      data1 = CSPutData(data0,i,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;
    }
    break;
  case 5: /* functor */
    data0 = CNew(0,1);
    parsed = multiParse(1,'(',',',')',string);
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CCommonToStruct(parsed[i]);
      data1 = CVPutElement(data0,i,element0);
      CDelete(data0);
      CDelete(element0);
      data0 = data1;
    }
    break;
  default:
    break;
  }
  return data0;
}

