#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include <multiParse.h>
#include <libcommon.h>
#include <CommonType.h>


CDATA CCommonParse(char *def,CDATA data);
CDATA CParseLoop(char *def,CDATA stack,CDATA data);
char *CGetTag(char *tupple,char *buf);
char *CGetVal(char *tupple,char *buf);
int checkConst(char *string);
char *CGetTypeCommon(char *tag,char *string0);
char *CGetNum(char *basic,char *buf);



CDATA CCommonParse(char *def,CDATA data){

  CDATA stack,ret;

  stack = CNew(0,3);
  
  ret = CParseLoop(def,stack,data);

  return ret;
}


CDATA CParseLoop(char *def0,CDATA stack,CDATA data){
  
  int i;
  int type;
  long length;
  char **parsed;
  char *tag,*val;
  char buf1[256];
  char buf2[256];
  char *def;  
  CDATA stack0;
  CDATA element,element0;
  CDATA data0;

  def = strdup(def0);

  type = checkStructCommon(def);

  switch(type){
  case 0: /* Not Structed */
    type = checkConst(def);
    switch(type){
    case 0:  /* data with type */
      tag = CGetNum(def,buf1);
      val = CGetTypeCommon(tag,def);
      element = CTGetElement(stack,tag);
      if(element == NULL) {
	element = CNew(0,2);
      }
      element0 = CLPutElement(element,-1,data);
      stack0 = CTPutElement(stack,tag,element0);
      CDelete(stack);
      CDelete(element);
      CDelete(element0);

      data0 = CNew(2,0);
      sprintf(buf1,"%s:",tag);
      data0 = CBPutString(data0,val);
      stack = CTPutElement(stack0,buf1,data0);
      CDelete(data0);
      CDelete(stack0);
      break;
    case 1:  /* inputted constant is not effective here*/
      break;
    case -1: /* Grobal Value is  not effective here */
      break;
    }
    break;
  case 1: /* vector */
    parsed = multiParse(0,'<',',','>',def);
    for(i = 0;parsed[i] != NULL;i++){
      element = CVGetElement(data,i);
      stack = CParseLoop(parsed[i],stack,element);
    }
    break;
  case 2: /* list */
    parsed = multiParse(0,'[',',',']',def);
    length = CLLength(data);
    for(i = 0;i <length;i++){
      stack = CParseLoop(parsed[0],stack,CLGetElement(data,i));
    }
    break;
  case 3: /* tupple */
    parsed = multiParse(0,'(',',',')',def);
    for(i = 0;parsed[i] != NULL;i++){
      tag = CGetTag(parsed[i],buf1);
      val = CGetVal(parsed[i],buf2);
      while(*val != '=') val++;
      val++;
      element = CTGetElement(data,tag);
      stack = CParseLoop(val,stack,element);
    }
    break;
  case 4: /* set */
    parsed = multiParse(0,'{',',','}',def);
    length = CSLength(data);
    for(i = 0;i <length;i++){
      element = CSGetData(data,i);
      stack = CParseLoop(parsed[0],stack,element);
    }
    break;
  case 5: /* functor */
    parsed = multiParse(1,'(',',',')',def);
    for(i = 0;parsed[i] != NULL;i++){
      element = CFGetElement(data,i);
      stack = CParseLoop(parsed[i],stack,element);
    }
    break;
  default:
    break;
  }
  free(def);
  return stack;
}

char *CGetTag(char *tupple,char *buf){

  char *p;

  buf = strcpy(buf,tupple);
  p = strchr(buf,'=');

  if((*(p-1)) == NULL) p--; 

  *p = NULL;

  return buf;
}


char *CGetNum(char *basic,char *buf){

  char *p;

  buf = strcpy(buf,basic);
  p = strchr(buf,':');

  if((*(p-1)) == NULL) p--; 

  *p = NULL;

  return buf;
}

char *CGetVal(char *tupple,char *buf){

  char *p;

  p = strchr(tupple,'=');

  buf = strcpy(buf,p);

  if(*p == NULL) p++; 

  return buf;
}

int checkConst(char *string) {
  
  if(*string == '$') return -1;
  if(strchr(string,':')) return 0;

  return 1;
}

char *CGetTypeCommon(char *tag,char *string0){
  
  
  int i;
  int type;
  char string[1024];
  char **parsed;
  char *ret;
  char *p;
  
  strcpy(string,string0);

  type = checkStructCommon(string);
  
  if(type) {
    parsed = parseStructCommon(string,type);
    for(i = 0;parsed[i];i++) {
      ret= CGetTypeCommon(tag,parsed[i]);
      if(ret) {
	return ret;
	free(parsed);
      }
    }
  }else {
    p = strchr(string,':');
    if(p == NULL) return NULL;
    *p++ = NULL;
    if(strcmp(tag,string)== 0) return strdup(p);
    else return NULL;
  }
  return NULL;
}
