#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include <multiParse.h>
#include <libcommon.h>
#include <CommonType.h>
#include <commonParse.h>

CDATA CCommonConst(char *def,CDATA stack);
CDATA CConstLoop(char *def,CDATA stack,CDATA *newStack);

char tmp[1024];

CDATA CCommonConst(char *def0,CDATA stack){
  
  CDATA newstack,ret;
  char *def;
  
  def = strdup(def0);
  
  ret =  CConstLoop(def,stack,&newstack);
  
  CDelete(newstack);  
  free(def);
  
  return ret;
}

CDATA CConstLoop(char *def,CDATA stack0,CDATA *newStack){

  int i;
  int type;
  char **parsed;
  char *tag,*val;
  char buf1[256];
  char buf2[256];
  CDATA element0,element1;
  CDATA stack,stacktmp;
  CDATA data0,data1;

  stack = CDuplicate(stack0);

  type = checkStructCommon(def);

  switch(type){
  case 0: /* Not Structed */
    type = checkConst(def);
    switch(type){
    case 0:  /* data with type */
      tag = CGetNum(def,buf1);
      element0 = CTGetElement(stack,tag);
      if(element0 == NULL) {
	*newStack = stack;
	return NULL;
      }
      if(element0->data.element == NULL) {
	*newStack = stack;
	return NULL;
      }
      data0 = CLCar(element0);


      if(data0 == NULL) {
	*newStack = stack;
	return NULL;
      }
      element1 = CLCdr(element0);
      if(element1 == NULL)  element1 = CNew(0,2);
      *newStack = CTPutElement(stack,tag,element1);

      CDelete(element0);
      CDelete(element1);

      return data0;
      break;
    case 1:  /* inputted constant is not effective here*/
      break;
    case -1: /* Grobal Value is  not effective here */
      break;
    }
    break;
  case 1: /* vector */
    data0 = CNew(0,1);
    parsed = multiParse(0,'<',',','>',def);
    for(i = 0;parsed[i] != NULL;i++){
      element0 = CConstLoop(parsed[i],stack,&stacktmp);
      data1 = CVPutElement(data0,i,element0);
      CDelete(stack); 
      CDelete(data0);
      CDelete(element0);
      stack = stacktmp;
      data0 = data1;
    }
    break;
  case 2: /* list */
    data0 = CNew(0,2);
    parsed = multiParse(0,'[',',',']',def);
    i = 0;
    while(element0 = CConstLoop(parsed[0],stack,&stacktmp)) {
      data1 = CLPutElement(data0,-1,element0);
      CDelete(stack);
      CDelete(data0);
      CDelete(element0);
      stack = stacktmp;
      data0 = data1;      
    }
    CDelete(stack);
    stack = stacktmp;
    break;
  case 3: /* tupple */
    data0 = CNew(0,3);
    parsed = multiParse(0,'(',',',')',def);
    for(i = 0;parsed[i] != NULL;i++){
      tag = CGetTag(parsed[i],buf1);
      val = CGetVal(parsed[i],buf2);
      while(*val != '=') val++;
      val++;
      element0 = CConstLoop(val,stack,&stacktmp);
      data1 = CTPutElement(data0,tag,element0);
      CDelete(stack);
      CDelete(data0);
      CDelete(element0);
      stack = stacktmp;
      data0 = data1;      
    }
    break;
  case 4: /* set */
    data0 = CNew(0,4);
    parsed = multiParse(0,'{',',','}',def);
    i = 0;
    while(element0 = CConstLoop(parsed[0],stack,&stacktmp)){
      data1 = CSPutData(data0,i++,element0);
      CDelete(stack);
      CDelete(data0);
      CDelete(element0);
      stack = stacktmp;
      data0 = data1;      
    }
    break;
  default:
    break;
  }
  *newStack = stack;
  return data0;
}
