#include <CommonType.h>
#include <commonParse.h>
#include <commonConst.h>
#include <commonConv.h>
#include <libcommon.h>
#include <multiParse.h>
#include <SMessage.h>

extern char *CEMethodTable[];
extern char *CETypeTable[];


SMessage CoETransfer(char* AgentID,SMessage Message_in,int Mode);
CDATA CENVTypeConv(char *commonType,char *localType,
                                             CDATA data,int Mode);


SMessage CoETransfer(char* AgentID,SMessage Message_in,int Mode){
/* Mode 0: To Inner 1: To Outer  */

 int i;
 char *method,*data;
 char *ret;
 char buf[1024];
 CDATA stack0,stack1,data1,data0;


 if(Message_in == NULL) return NULL;
 method = CSMGetMethodStr(Message_in);
 data = CSMGetDataStr(Message_in);

 i = 0;

/* Search AgentID */
 while(strcmp(CEMethodTable[i++],AgentID) != 0) {
   for(;CEMethodTable[i] == NULL;i += 10);
   i++;
   if(CEMethodTable[i] == NULL) return NULL;
 }


 if(Mode) { /* To Outer */
   /* Search Method */
   for(;(strcmp(CEMethodTable[i+5],method) != 0);i += 10);

   data0 = CCommonToStruct(data);
   stack0 = CCommonParse(CEMethodTable[i+9],data0);
   data1 = CCommonConst(CEMethodTable[i+4],stack0);
   ret = CStructToCommon(data1,buf);
   CDelete(stack0);
   CDelete(data0);
   CDelete(data1);
   CSMPutDataStr(Message_in,ret);
   
   if(CEMethodTable[i+1] != NULL) {
     CSMPutToAFStr(Message_in,CEMethodTable[i+1]);
   }
   if(CEMethodTable[i+2] != NULL) {
     CSMPutToManagementStr(Message_in,CEMethodTable[i+2]);
   }

   
 }else { /* To Inner */
   /* Search Method */
   for(;(strcmp(CEMethodTable[i],method) != 0);i += 10);
   
   data0 = CCommonToStruct(data);
   stack0 = CCommonParse(CEMethodTable[i+3],data0);
   data1 = CCommonConst(CEMethodTable[i+8],stack0);
   ret = CStructToCommon(data1,buf);
   CDelete(stack0);
   CDelete(data0);
   CDelete(data1);
   CSMPutDataStr(Message_in,ret);
   
   if(CEMethodTable[i+6] != NULL) {
     CSMPutToAFStr(Message_in,CEMethodTable[i+6]);
   }
   if(CEMethodTable[i+7] != NULL) {
     CSMPutToManagementStr(Message_in,CEMethodTable[i+7]);
   }
   
 }
 
 return Message_in;
}

 
CDATA CENVTypeConv(char *commonType,char *localType,
                                             CDATA data,int Mode){
  
  int i;
  CDATA stack0,stack1,ret;
  
  if(Mode) { 
    
    for(i=0;CETypeTable[i];i += 4){
      if(strcmp(commonType,CETypeTable[i])== 0 &&
	 strcmp(localType,CETypeTable[i+2]) == 0){
	stack0 = CCommonParse(CETypeTable[i+3],data);
	stack1 = CCommonConv(CETypeTable[i+1],stack0);
	ret = CCommonConst(CETypeTable[i+1],stack1);
	CDelete(stack0);
	CDelete(stack1);
	return ret;
      }
    }
  }else{
    for(i=0;CETypeTable[i];i += 4){
      if(strcmp(commonType,CETypeTable[i])== 0 &&
	 strcmp(localType,CETypeTable[i+2]) == 0){
	stack0 = CCommonParse(CETypeTable[i+1],data);
	stack1 = CCommonConv(CETypeTable[i+3],stack0);
	ret = CCommonConst(CETypeTable[i+3],stack1);
	CDelete(stack0);
	CDelete(stack1);
	return ret;
      }
    }
  }
  return CCommonTypeConv(commonType,localType,data);
}
