#include <CommonType.h>
#include <commonParse.h>
#include <commonConst.h>
#include <libcommon.h>
#include <multiParse.h>
#include <localConv.h>
#include <localParse.h>
#include <localConst.h>
#include <liblocal.h>
  
extern char* SubstanceTable[];
extern char* MethodTable[];
extern char* TypeTable[];


CDATA CAPPMethodConvEnvCommon(char *method,char *data);
char* CAPPMethodConvCommonEnv(char *method,CDATA data);

CDATA CAPPTypeConvCommonLocal(char *commonType,char *localType,CDATA data);
CDATA CAPPTypeConvLocalCommon(char *commonType,char *localType,CDATA data);
char* CAPPSubstanceConvCommonLocal(char *method,CDATA data);
CDATA CAPPSubstanceConvLocalCommon(char *method,char *data0);

char tmpbuffer[1024];

char* CAPPSubstanceConvCommonLocal(char *method,CDATA data){
  
  int i;
  CDATA stack0,stack1,data1;
  char buf[1024];
  
  for(i = 0;SubstanceTable[i];i += 5){
    if(strcmp(method,SubstanceTable[i])== 0) {
      stack0 = CCommonParse(SubstanceTable[i+1],data);
      stack1 = CLocalConv(SubstanceTable[i+2],stack0);
      data1 = CLocalConst(SubstanceTable[i+2],stack1);
      CStructToLocal(data1,buf);
      CDelete(stack0);
      CDelete(stack1);
      CDelete(data1);
      return strdup(buf);
    }
  }
  return NULL;
}


CDATA CAPPSubstanceConvLocalCommon(char *method,char *data0){
  
  int i;
  CDATA stack0,stack1,data1;
  char *data;
  CDATA ret;
  
  data = strdup(data0);

  for(i = 0;SubstanceTable[i];i += 5){
    if(strcmp(method,SubstanceTable[i])== 0) {
      data1 = CLocalToStruct(data);
      stack0 = CLocalParse(SubstanceTable[i+3],data1);
      stack1 = CCommonConv(SubstanceTable[i+4],stack0);
      ret = CCommonConst(SubstanceTable[i+4],stack1);
      CDelete(stack0);
      CDelete(stack1);
      CDelete(data1);
      free(data);
      return ret;
    }
  }
  free(data);
  return NULL;
}

char* CAPPMethodConvCommonEnv(char *method,CDATA data){
  int i,type;
  CDATA stack0,data1;
  char *ret;
  char buf[1024];
  
  for(i = 0;MethodTable[i];i += 5){
    if(strcmp(method,MethodTable[i])== 0) {
      stack0 = CCommonParse(MethodTable[i+1],data);
      data1 = CCommonConst(MethodTable[i+2],stack0);
      ret = CStructToCommon(data1,buf);
      CDelete(stack0);
      CDelete(data1);
      return strdup(ret);
    }
  }
  return NULL;
}

CDATA CAPPMethodConvEnvCommon(char *method,char *data0){
  
  int i;
  CDATA stack0,data1,data2;
  char *ret,*data;
  char buf[1024];
  
  data = strdup(data0);
  
  for(i = 0;MethodTable[i];i += 5){
    if(strcmp(method,MethodTable[i])== 0) {
      data1 = CCommonToStruct(data);
      stack0 = CCommonParse(MethodTable[i+3],data1);
      data2 = CCommonConst(MethodTable[i+4],stack0);
      CDelete(stack0);
      CDelete(data1);
      free(data);
      return data2;
    }
  }
  return NULL;
}


CDATA CAPPTypeConvCommonLocal(char *commonType,char *localType,CDATA data){
  
  int i;
  CDATA stack0,stack1,ret;
  
  for(i=0;TypeTable[i];i += 4){
    if(strcmp(commonType,TypeTable[i])== 0 &&
       strcmp(localType,TypeTable[i+2]) == 0){
      stack0 = CCommonParse(TypeTable[i+1],data);
      stack1 = CLocalConv(TypeTable[i+3],stack0);
      ret = CLocalConst(TypeTable[i+3],stack1);
      CDelete(stack0);
      CDelete(stack1);
      return ret;
    }
  }
  return CLocalTypeConv(commonType,localType,data);
}


CDATA CAPPTypeConvLocalCommon(char *commonType,char *localType,CDATA data){
  
  int i;
  CDATA stack0,stack1,ret;
  
  for(i=0;TypeTable[i];i += 4){
    if(strcmp(commonType,TypeTable[i])== 0 &&
       strcmp(localType,TypeTable[i+2]) == 0){
      stack0 = CLocalParse(TypeTable[i+3],data);
      stack1 = CCommonConv(TypeTable[i+1],stack0);
      ret = CCommonConst(TypeTable[i+1],stack1);
      CDelete(stack0);
      CDelete(stack1);
      return ret;
    }
  }
  return CLocalTypeConv(localType,commonType,data);
}
