/* top_parser.c
 *     $B4X?t(B main() $B$,8F$S=P$9%H%C%W%l%Y%k$N(B parser
 *
 */

#include <stdio.h>
#include <define.h>
#include <warn.h>
#include <parsers.h>
#include <tokens.h>

char clcword[BUFSIZE];
extern int method_lex(void);

int top_parser()
{
  int token;
  int result;

  result = TRUE;
  while((token = method_lex()) != EOF){
    switch(token){
    case AGENT_TYPE:
      fprintf(stderr, "enter a parser for agent type.\n");
      result = type_parser();
      break;
    case AGENT_NAME:
      fprintf(stderr, "enter a parser for agent name.\n");
      result = name_parser();
      result = get_agent_info(agent_name, agent_id, ap_name);
      break;
    case PARA_DEF:
      fprintf(stderr, "enter a parser for parameter.\n");
      result = para_parser();
      break;
    case INSIDE:
      fprintf(stderr, "enter a parser for inside.\n");
      result = inside_parser();
      break;
    case SUBSTANCE_TYPE:
      fprintf(stderr, "enter a parser for substance type.\n");
      break;
    case CONNECT:
      fprintf(stderr, "enter a parser for connect.\n");
      result = connect_parser();
      break;
    case LOCK:
      fprintf(stderr, "enter a parser for lock.\n");
      result = lock_parser();
      break;
    case TRANSACTION:
      fprintf(stderr, "enter a parser for transaction.\n");
      result = trans_parser();
      break;
    case IMPORT_METHOD:
      fprintf(stderr, "enter a parser for import method.\n");
       result = import_parser();
      break;
    case EXPORT_METHOD:
      fprintf(stderr, "enter a parser for export method.\n");
       result = export_parser();
      break;
    case SUBSTANCE_QUERY:
      fprintf(stderr, "enter a parser for substance query.\n");
      result = query_parser();
      break;
    case SUBSTANCE_CALL:
      fprintf(stderr, "enter a parser for substance call.\n");
      result = call_parser();
      break;
    case NEGOTIATION_STRATEGY:
      fprintf(stderr, "enter a parser for negotiation strategy.\n");
/*    result = nego_parser() */
      break;
    case CAPSULE_PROCEDURE:
      fprintf(stderr, "enter a parser for capsule procedure.\n");
/*    result = proc_parser() */
      break;
    case SELF_MODEL:
      fprintf(stderr, "enter a parser for self model.\n");
      result = self_model_parser();
      break;
    default:
      warning("illegal definition keyword");
      break;
    }
  }
  return result;
}

/* end of top_a parser.c */
