/* sub_type_parser.c
 *        $B<B$N8F$S=P$7Dj5A$N$?$a$N%Q!<%5!<(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int sub_type_parser(void)
{
  int token;

  if((token = method_lex()) == EOF){
    return FAIL;
  }
  else if(token == STRING){
    sub_type = strdup(clcword);
  }
  else if(token_is_keyword(token) == TRUE){
    clcunlex(token);
    return FAIL;
  }

  if((token = method_lex()) == EOF){
    return FAIL;
  } else if(token != '{'){
    warning("illegal substance type definition");
  }
  else if(token_is_keyword(token) == TRUE){
    clcunlex(token);
    return FAIL;
  }

  while(1){
    if((token = method_lex()) == EOF){
      return FAIL;
    }
    else if(token == '}'){
      break;
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      return FAIL;
    }
    else if(token != STRING){
      warning("illegal substance local type name");
    }
    if((token = method_lex()) == EOF){
      return FAIL;
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      return FAIL;
    }
    else if(token != ASSIGN){
      warning("illegal substance local type definition");
    }
    while(1){
      if((token = method_lex()) == EOF){
	return FAIL;
      }
      else if(token_is_keyword(token) == TRUE){
	clcunlex(token);
	return FAIL;
      }
      else if(token == ';'){
	break;
      }
    }
  }
  skip_end_of_def();
  return TRUE;
}
/* end of sub_type_parser.c */
