/* self_model_parser.c
 *
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <tokens.h>

extern int method_lex(void);

int self_model_parser(void)
{
  int token;

  while(1){
    token = method_lex();
    switch(token){
    case COMMENT:
      if((token = method_lex()) == QSTRING){
	comment = strdup(clcword);
      }
      else{
	warning("illegal definition of self model");
	return FAIL;
      }
      if((token = method_lex()) == ';'){
	break;
      }
      else{
	warning("cannot find an end of sentence");
	fprintf(stderr, "capl compiler set comment %s\n", comment);
      }
      break;
    default:
      clcunlex(token);
#ifdef DEBUG
      fprintf(stderr, "comment = %s\n", comment);
#endif
      return TRUE;
    }
  }
  return FAIL;
}
/* end of self_model_parser.c */
