/* query_parser.c
 *        $BM"F~%a%=%C%IDj5AMQ$N%Q!<%5!<(B
 *        $BM"F~%a%=%C%I$NDj5A$+$i$O0J2<$K<($9%3!<%I$r@8@.$9$k(B
 *          $B!&%a%=%C%I(B-$B%a%=%C%IBP1~I=(B
 *                $BJQ494X?tL>$O@8@.$9$k(B
 *          $B!&%a%=%C%I(B-$B=hM}BP1~I=(B
 *                $B=hM}4X?t$O%G%U%)%k%H(B or $B@8@.(B
 *                AskTo...
 *          $B!&>uBV(B-$B%a%=%C%IBP1~I=(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);
extern FILE *conv_fp;

static int skip_end_of_def(void)
{ int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int query_parser(void){
  int token;
  int result;
  int each_result;
  char buffer[BUFSIZE], *ptr;
  int i;

  result = TRUE;
  each_result = TRUE;
  num_of_query = -1;
  while(1){
    if(each_result == TRUE){
      num_of_query += 1;
      if(num_of_query == TABLE_MAX){
	warning("overflow of query method table");
	result = FAIL;
	break;
      }
    }
    else{
      result = FAIL;
    }

    if((token = method_lex()) == STRING){
      query[num_of_query].out_method = strdup(clcword);
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      break;
    }
    else if(token == EOF){
      break;
    }
    else{
      warning("illegal method description in substance query");
      if(skip_end_of_def() == FAIL) return FAIL;
      each_result = FAIL;
      continue;
    }
    if((token = method_lex()) == '@'){
      ptr = buffer;
      memset(buffer, '\0', BUFSIZE);
      while((token = method_lex())!= METHOD_SEP){
	if(token == EOF){
	  return FAIL;
	}
	else if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == VARIABLE){
	  sprintf(ptr, "#%s", clcword);
	}
	else if(token == PARAMETER){
	  sprintf(ptr, "$%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	ptr = strchr(ptr, '\0');
      }
      query[num_of_query].out_sig = strdup(buffer);
    }
    else if(token == EOF){
      return FAIL;
    }
    else{
      warning("illegal method description in substance query");
      if(skip_end_of_def() == FAIL) return FAIL;
      each_result = FAIL;
      continue;
    }

    /* $BCf4V%a%=%C%IL>(B or &negotiation or &procedure $B$N3MF@(B */
    if((token = method_lex()) == EOF){
      return FAIL;
    }
    else if(token == STRING){
      query[num_of_query].in_method = strdup(clcword);
      query[num_of_query].np_name = NULL;
      query[num_of_query].dist = EX_ASK;
    }
    else if(token == CALL_NEGO || token == CALL_PROC){
      query[num_of_query].dist = token;

      /* $B8r>DL>!&<jB3$-L>$N3MF@(B */
      CLCLEX(token, FAIL);
      if(token == STRING){
	query[num_of_query].np_name = strdup(clcword);
      }
      else{
	warning("illegal substance query name");
	if(skip_end_of_def() == FAIL) return FAIL;
	each_result = FAIL;
	continue;
      }
      /* $BCf4V%a%=%C%IL>$N3MF@(B */
      CLCLEX(token, FAIL);
      if(token == STRING){
	query[num_of_query].in_method = strdup(clcword);
      }
      else{
	warning("illegal query method definition");
	if(skip_end_of_def() == FAIL) return FAIL;
	each_result = FAIL;
	continue;
      }
    }
    if((token = method_lex()) == EOF){
      return FAIL;
    } else if(token == '@'){
      memset(buffer, '\0', BUFSIZE);
      ptr = buffer;
      while(1){
	if((token = method_lex()) == EOF){
	  return FAIL;
	}	
	else if(token == ';'){
	  break;
	}
	else if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s",clcword);
	}
	else if(token == VARIABLE){
	  sprintf(ptr,"#%s", clcword);
	}
	else if(token == PARAMETER){
	  sprintf(ptr, "$%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	ptr = strchr(ptr, '\0');
      }
      query[num_of_query].in_sig = strdup(buffer);
      clcunlex(token);
    }
    else{
      warning("illegal query method definition");
      if(skip_end_of_def() == FAIL) return FAIL;
      each_result = FAIL;
      continue;
    }

    /* $BDj5A$N=*$j$^$GFI$_9~$`(B */
    if(skip_end_of_def() == FAIL) return FAIL;
    continue;
  }
  fprintf(conv_fp, "substance_query\n");
  for(i = 0; i < num_of_query; i++){
    fprintf(conv_fp, "%s=>%s@%s\n",
	    query[i].out_sig,
	    query[i].in_method, query[i].in_sig);
  }

#ifdef DEBUG
  for(i = 0; i < num_of_query; i++){
    if(query[i].dist == EX_ASK)
      fprintf(stderr, "sub proc %s => ask_method %s\n",
	      query[i].out_method, query[i].in_method);
    else if(query[i].dist == CALL_NEGO)
      fprintf(stderr, "sub proc %s => nego %s\n",
	      query[i].out_method, query[i].in_method);
    else if(query[i].dist == CALL_PROC)
      fprintf(stderr, "sub proc %s => proc %s\n",
	      query[i].out_method, query[i].in_method);
  }
#endif
  return result;
}

/* end of query_parser.c */
