/* para_parser.c
 *        $B%Q%i%a!<%?@k8@$N$?$a$N%Q!<%5(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);

static void skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';');
}

int para_parser(para_data para_list[])
{
  int token;
  int num_of_para;
  int result;
  int i;
  char tmp[BUFSIZE];
  char *ptr;

  for(i = 0; i < PARA_MAX; i++){
    para_list[i].para_name = NULL;
    para_list[i].para_type = NULL;
    para_list[i].para_init = NULL;
  }
  result = TRUE;
  num_of_para = 0;
  while((token = method_lex()) != '{');
  while(1){
    if(num_of_para == PARA_MAX){
      warning("overflow of parameter table");
      result = FAIL;
      break;
    }
    if((token = method_lex()) == '}'){
      break;
    }
    else if(token == PARAMETER)
      para_list[num_of_para].para_name = strdup(clcword);
    else{
      warning("illegal parameter declaration");
      skip_end_of_def();
      result = FAIL;
      continue;
    }

    /* $B7?L>$NFI$_9~$_(B */
    if((token = method_lex()) == ':'){
      if((token = method_lex()) == STRING)
	para_list[num_of_para].para_type = strdup(clcword);
      else{
	warning("illegal common type name");
	skip_end_of_def();
	result = FAIL;
	continue;
      }
    }
    else{
      warning("illegal common type name");
      skip_end_of_def();
      result = FAIL;
      continue;
    }

    /* $B=i4|CM$NFI$_9~$_(B */
    if((token = method_lex()) == ASSIGN){
      memset(tmp, '\0', BUFSIZE);
      ptr = tmp;
      while((token = method_lex()) != ';'){
	if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s", clcword);
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	else{
	  warning("illgal initial value of parameter");
	  skip_end_of_def();
	  result = FAIL;
	  continue;
	}
	ptr = strchr(ptr, '\0');
      }
      para_list[num_of_para].para_init = strdup(tmp);
    }
    else{
      para_list[num_of_para].para_init = NULL;
    }
    clcunlex(token);
    if((token = method_lex()) == ';'){
      num_of_para += 1;
    }
    else{
      warning("illegal definiton of parameter");
      result = FAIL;
    }
  }
  if((token = method_lex()) != ';'){
    warning("illegal end of definition");
    result = FAIL;
  }
#ifdef DEBUG
  for(i = 0; i < num_of_para; i++){
    fprintf(stderr, "%s:%s", para_list[i].para_name, para_list[i].para_type);
    if(para_list[i].para_init != NULL)
      fprintf(stderr, " := %s\n", para_list[i].para_init);
    else
      fprintf(stderr, "\n");
  }
#endif
  if(result == TRUE) return num_of_para;
  else               return 0;
}
/* end of para_parser.c */
