/* para_lex.c
 *        $B%Q%i%a!<%?@k8@$N$?$a$N;z6g2r@OIt(B
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <warn.h>
#include <lex.h>
#include <tokens.h>

int para_lex(void)
{
  int token;
  int c;

  if(ungettoken != 0){
    token = ungettoken;
    ungettoken = 0;
    return token;
  }

  memset(clcword, '\0', BUFSIZE);
  while((c = clcgetc()) != EOF){
    if(c == '%'){ /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while((c = clcgetc()) == '\n');
      lineno += 1;
      continue;
    }
    else if(c == ' ' || c == '\t') continue;
    else if(c == '\n'){
      lineno += 1;
      continue;
    }
    else if(c == '-'){
      if((c = clcgetc()) == '>') return SIG_SEP;
      else{
	clcungetc(c);
	return '-';
      }
    }
    else if(c == '='){
      if((c = clcgetc()) == '>') return METHOD_SEP;
      else if(c == '=') return EQL;
      else{
	clcungetc(c);
	return '=';
      }
    }
    else if(c == ':'){
      c = clcgetc();
      if(c == '=') return ASSIGN;
      else{
	clcungetc(c);
	return ':';
      }
    }
    else if(c == '<'){
      if((c == clcgetc()) == '=') return LESSEQ;
      else{
	clcungetc('=');
	return LESS;
      }
    }
    else if(c == '>'){
      if((c == clcgetc()) == '=') return GREATEREQ;
      else{
	clcungetc('=');
	return GREATER;
      }
    }
    else if(isdigit(c)){
      clc_get_number(c);
      return NUMBER;
    }
    else if(c == '&'){
      clc_get_string('\0');
      return check_keyword_id(keyword_list);
    }
    else if(isalpha(c) || c == '_'){
      clc_get_string(c);
      return STRING;
    }
    else if(c == '"'){
      clc_get_qstring();
      return QSTRING;
    }
    else if(c == '#'){
      clc_get_number('\0');
      return VARIABLE;
    }
    else if(c == '$'){
      clc_get_string('\0');
      return PARAMETER;
    }
    else return c;
  }
  return c;
}
/* end of para_lex.c */
