/* np_proc_sig_parser.c */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parsers.h>
#include <parser.h>
#include <tokens.h>
#include <check_type.h>
#include <make_table.h>
#include <np_proc_sig_parser.h>

extern int method_lex(void);
extern FILE *def_fp;
extern FILE *func_fp;
extern FILE *table_fp;

#define CHG_FLAG(flag) ((++flag)%2)

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int np_proc_args_parser(char *np_name,
			para_data args[], int num_of_args,
			para_data para_list[], int num_of_para,
			para_data np_para_list[], int num_of_np_para,
			int top, int type, int flag, char mark)
{
  int token;
  int result;

  result = TRUE;
  CLCLEX(token, FAIL);
  if(token == mark){
    fprintf(func_fp, "  sprintf(strPtr, \"%c\");\n", mark);
    fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    return TRUE;
  }
  clcunlex(token);
  while(1){
    CLCLEX(token, FAIL);
    if(type == TUPLE_TYPE){
      if(token != STRING){
	fprintf(stderr, "illegal common data description of siganture");
      }
      CLCLEX(token, FAIL);
      if(token != '='){
	fprintf(stderr, "illegal common data description of siganture");
      }
    }
    if(token == PARAMETER ||token == VARIABLE){
      result = np_proc_arg_parser(np_name,
				  args, num_of_args,
				  para_list, num_of_para,
				  np_para_list, num_of_np_para,
				  token, token, flag);
    }
    else if(token == STRING || token == QSTRING || token == NUMBER){
      fprintf(func_fp, "  sprintf(strPtr, \"%s\");\n", clcword);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
    else if(token == '['){
      fprintf(func_fp, "  sprintf(strPtr, \"[\");\n");
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
      result = np_proc_args_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   np_para_list, num_of_np_para,
				   token, LIST_TYPE, flag, ']');
    }
    else if(token == '<'){
      fprintf(func_fp, "  sprintf(strPtr, \"<\");\n");
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
      result = np_proc_args_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   np_para_list, num_of_np_para,
				   token, VEC_TYPE, flag, '>');
    }
    else if(token == '('){
      fprintf(func_fp, "  sprintf(strPtr, \"(\");\n");
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
      result = np_proc_args_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   np_para_list, num_of_np_para,
				   token, TUPLE_TYPE, flag, ')');
    }
    else{
      warning("illegal signature of procedure");
    }
    CLCLEX(token, FAIL);
    if(token == mark){
      break;
    }
    else if(clcword[0] == '\0'){
      fprintf(func_fp, "  sprintf(strPtr, \"%c\");\n", token);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
  }
  if(result == TRUE){
    fprintf(func_fp, "  sprintf(strPtr, \"%c\");\n", mark);
    fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
  }
  else{
    return FAIL;
  }
  return result;
}

int np_proc_arg_parser(char *np_name,
		       para_data args[], int num_of_args,
		       para_data para_list[], int num_of_para,
		       para_data np_para_list[], int num_of_np_para,
		       int top, int type, int flag)
{
  int i;
  int pre_flag;
  int token;
  int result;
  result = TRUE;
  if(top == PARAMETER){
    if(check_common_type(clcword, np_para_list, num_of_np_para) != NO_TYPE){
      fprintf(func_fp, "  tmp%d = CDuplicate(WIlPar.%s_par.%s);\n",
	      flag, np_name, clcword);
    }
    else if(check_common_type(clcword, para_list, num_of_para) != NO_TYPE){
      fprintf(func_fp, "  tmp%d = CDuplicate(AIcPar.%s);\n",
	      flag, clcword);
    }
    else{
      result = FAIL;
      warning("undefined parameter");
      fprintf(stderr, "\t$%s is not defined.", clcword);
    }
  }
  else if(top == VARIABLE){
    for(i = 0; i < num_of_args; i++){
      if(strcmp(clcword, args[i].para_name) == 0) break;
    }
    if(i < num_of_args){
      fprintf(func_fp, "  tmp%d = CDuplicate(arg[%d]);\n", flag, i);
    }
    else{
      result = FAIL;
      warning("undefine data");
      fprintf(stderr, "\t#%s dose not exit in event signature.\n", clcword);
    }
  }
  else{
    fprintf(stderr, "capl compiler errorin np_proc_arg_parser()\n");
  }

  while(1){
    CLCLEX(token, FAIL);
    if(token == '.'){
      CLCLEX(token, FAIL);
      if(token == STRING){
	pre_flag = flag;
	flag = (++flag)%2;
	fprintf(func_fp,
		"  tmp%d = CLGetElement(tmp%d, \"%s\");\n",
		flag, pre_flag, clcword);
	fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
	fprintf(func_fp, "  CDelete(tmp%d);\n", pre_flag);
      }
      else if(token == NUMBER){
	pre_flag = flag;
	flag = (++flag)%2;
	fprintf(func_fp,
		"tmp%d = CLGetElement(tmp%d, %s);\n", flag, pre_flag, clcword);
	fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
	fprintf(func_fp, "  CDelete(tmp%d);\n", pre_flag);
      }
    }
    else{
      clcunlex(token);
      break;
    }
  }
  if(result == TRUE){
    fprintf(func_fp,
	    "  sprintf(strPtr, \"\%%s\", CStructToCommon(tmp%d, arg_str));\n", flag);
    fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    fprintf(func_fp, "  CDelete(tmp%d);\n", flag);
    return TRUE;
  }
  else{
    return FAIL;
  }
}

int np_proc_from_parser(char *np_name,
			para_data args[], int num_of_args,
			para_data para_list[], int num_of_para,
			para_data np_para_list[], int num_of_np_para,
			int flag)
			
{
  /*
   * - member #1 #2 , bag_of ! 
   * + #1 #2 #3 , bag_of !
   * meeting , bag_of !
   * &external_reply meeting1 ! method @
   * &exernal_reply ! meeting
   */
  int token;
  int result;

  result = TRUE;
  while(1){
    CLCLEX(token, FAIL);
    if(token == STRING || token == NUMBER){
      fprintf(func_fp, "  sprintf(strPtr, \"%s \");\n", clcword);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
    else if(token == PARAMETER || token == VARIABLE){
      result = np_proc_arg_parser(np_name,
				  args, num_of_args,
				  para_list, num_of_para,
				  np_para_list, num_of_np_para,
				  token, token, flag);
    }
    else if(token == ','){
      fprintf(func_fp, "  CCommonToTOstring(buffer, to);\n");
      CLCLEX(token, FAIL);
      if(token == STRING){
	fprintf(func_fp, "  sprintf(manage, \"%s\");\n", clcword);
      }
      else{
	warning("illegal destination address.");
	result = FAIL;
      }
      CLCLEX(token, FAIL);
      if(token != '!'){
	warning("separtor between address and method.");
      }
      break;
    }
    else if(token == '!'){
      fprintf(func_fp, "  CCommonToTOstring(buffer, to);\n");
      break;
    }
    else if(clcword[0] == '\0'){ 
      fprintf(func_fp, "  sprintf(strPtr, \"%c \");\n", (char)token);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
  }
  return result;
}

int free_para_list(para_data para_list[], int num_of_para)
{
  int i;
  for(i = 0; i < num_of_para; i++){
    free(para_list[i].para_name);
    free(para_list[i].para_type);
    free(para_list[i].para_init);
  }
  return TRUE;
}

int np_state_parser(int mode, char *np_name, char *state[], int st_max)
{
  int token;
  int result;
  int num_of_st;
  char buffer[BUFSIZE];
  int i;

  CLCLEX(token, -1);
  if(token != '{'){
    warning("illegal definition of state");
    return -1;
  }
  result = TRUE;
  sprintf(buffer, "%s_init", np_name);
  state[0] = strdup(buffer);
  sprintf(buffer, "%s_finish", np_name);
  state[1] = strdup(buffer);

  num_of_st = 2;
  while(1){
    CLCLEX(token, -1);
    if(token == '}'){
      break;
    }
    else if(token == STRING){
      if(num_of_st == st_max){
	warning("state table is overflow");
	result = FAIL;
	break;
      }
      sprintf(buffer, "%s_%s", np_name, clcword);
      state[num_of_st++] = strdup(buffer);
      CLCLEX(token, -1);
      if(token != ';'){
	result = FAIL;
	break;
      }
    }
    else{
      warning("illegal definition of state");
      result = FAIL;
      break;
    }
  }
  if(result == TRUE){
    CLCLEX(token, -1);
    if(token != ';'){
      warning("cannot find end of definition ';'");
      num_of_st = -1;
    }
  }
  else{
    while(1){
      CLCLEX(token, -1);
      if(token != '}') break;
    }
    while(1){
      CLCLEX(token, -1);
      if(token != ';') break;
    }
    num_of_st = -1;
  }
  for(i = 0; i < num_of_st; i++){
    np_state[num_of_np_state] = strdup(state[i]);
    num_of_np_state++;
  }
  return num_of_st;
}

/* end of np_proc_sig_parser.c */
