/* np_para_parser.c */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "define.h"
#include "capldata.h"
#include "warn.h"
#include "lex.h"
#include "parsers.h"
#include "parser.h"
#include "tokens.h"
#include "check_type.h"
#include "make_table.h"
#include "np_proc_sig_parser.h"

extern int method_lex(void);
extern FILE *func_fp;
extern FILE *def_fp;

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}
int np_para_parser(int flag, char *np_name,
		   para_data para_list[], int para_max)
{
  int token;
  int result;
  int num_of_para;
  char buffer[BUFSIZE], *ptr;
  int i;

  CLCLEX(token, -1);
  if(token != '{'){
    warning("illegal definition of state");
    return -1;
  }
  num_of_para = -1;
  result = TRUE;
  while(1){
  loop:
    if(++num_of_para == para_max){
      warning("parameter table is overflow.");
      result = FAIL;
      break;
    }

    CLCLEX(token, -1);
    /* get parameter name */
    if(token == PARAMETER){
      para_list[num_of_para].para_name = strdup(clcword);
    }
    else if(token == '}'){
      break;
    }
    else{
      warning("illegal definiton of parameter name");
      while((token = method_lex()) != ';');
      result = FAIL;
      continue;
    }
    CLCLEX(token, -1);
    if(token != ':'){
      result = FAIL;
      skip_end_of_def();
      continue;
    }
    CLCLEX(token, -1);
    if(token == STRING){
      for(i = 0; i < num_of_type; i++){
	if(strcmp(clcword, type_list[i].type_name) == 0) break;
      }
      if(i < num_of_type){
	para_list[num_of_para].para_type = strdup(clcword);
      }
      else{
	warning("no definiton common type");
	fprintf(stderr, "\t%s\n", clcword);
	result = -1;
      }
    }
    else{
      warning("illegal definition of parameter");
      skip_end_of_def();
      result = FAIL;
      continue;
    }
    
    CLCLEX(token, -1);
    if(token == ASSIGN){
      memset(buffer, '\0', BUFSIZE);
      ptr = buffer;
      while(1){
	CLCLEX(token, -1);
	if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == ';') break;
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	else{
	  warning("illegal initial value of parameter");
	  result = FAIL;
	  goto loop;
	}
	ptr = strchr(ptr, '\0');
      }
      para_list[num_of_para].para_init = strdup(buffer);
    }
    if(token != ';'){
      warning("not find end of parameter definition.");
      result = FAIL;
    }
  }

  if(result == TRUE){
    CLCLEX(token, -1);
    else if(token != ';'){
      clcunlex(token);
      warning("cannot find end of definition ';'");
    }
    fprintf(func_fp, "int ParaInit_%s(void)\n{\n", np_name); 
    fprintf(func_fp, "  char buffer[BUFSIZE];\n");
    for(i = 0; i < num_of_para; i++){
      if(para_list[i].para_init != NULL){
	fprintf(func_fp,"  WIlPar.%s_par.%s = CCommonToStruct(\"%s\");\n",
		np_name, para_list[i].para_name, para_list[i].para_init);
      }
      else{
	fprintf(func_fp, "  worldInfo[worldID].LPAR.%s_par.%s = NULL;\n",
		np_name, para_list[i].para_name);
      }
    }
    fprintf(func_fp, "  return TRUE;\n}\n\n");

    fprintf(func_fp, "int ParaFree_%s(void)\n{\n", np_name); 

    for(i = 0; i < num_of_para; i++){
      fprintf(func_fp,"  if(worldInfo[worldID].LPAR.%s_par.%s == NULL)\n",
	      np_name, para_list[i].para_name);
      fprintf(func_fp,"    CDelete(worldInfo[worldID].LPAR.%s_par.%s);\n",
	      np_name, para_list[i].para_name);
    }
    fprintf(func_fp, "  return 1;\n}\n\n");

    fprintf(def_fp, "typedef struct{\n");
    get_para_definition(para_list, num_of_para);
    fprintf(def_fp, "} %sPar;\n", np_name);
    return num_of_para;
  }
  else{
    while((token = method_lex()) != '}');
    while((token = method_lex()) != ';');
    return -1;
  }
}

int get_para_definition(para_data para_list[], int num_of_para)
{
  int i;
  for(i = 0; i < num_of_para; i++){
    fprintf(def_fp, "  CDATA %s;\n", para_list[i].para_name);
    switch(check_common_type_type(para_list[i].para_type)){
    case INT_TYPE:
      fprintf(def_fp, "  int int_%s;\n", para_list[i].para_name);
      break;
    case BOOL_TYPE:
      fprintf(def_fp, "  int bool_%s;\n", para_list[i].para_name);
      break;
    case STR_TYPE:
      fprintf(def_fp, "  char *str_%s;\n", para_list[i].para_name);
      break;
    case LIST_TYPE:
      fprintf(def_fp, "  char list_%s[BUFSIZE];\n", para_list[i].para_name);
      break;
    case VEC_TYPE:
      fprintf(def_fp, "  char vec_%s[BUFSIZE];\n", para_list[i].para_name);
      break;
    case TUPLE_TYPE:
      fprintf(def_fp, "  char tuple_%s[BUFSIZE];\n", para_list[i].para_name);
      break;
    }
  }
  return TRUE;
}
/* np_para_parser.c */
