/* nego_parser.c
 *        $B8r>D@oN,MQ$N%Q!<%5!<(B
 *        $B$3$N%Q!<%5!<$O!"3F5-=R$4$H$K4X?t$r@8@.$7$F$$$/!#(B
 */
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parsers.h>
#include <parser.h>
#include <tokens.h>
#include <check_type.h>
#include <np_proc_sig_parser.h>
#include <comp_exp_parser.h>

extern int method_lex(void);
extern FILE *func_fp;

static int def_level;

static char external_proc_list[]={"
  sendMsg = MakeAskMessage(to, manage, WItid, method, data);
  send_message(sendMsg);
  
"};

static char substance_proc_list[]={"
  sub_proc_mode = check_substance_type(method);
  tmp1 = CCommonToStruct(data);
  sub_info = CAPPSubstanceCommonLocal(method, tmp1);
  CDelete(tmp1);
  if(sub_proc_mode == CALL){
    call_id = CallSubstanceProc(sub_info, call_id);
  }
  else if(sub_proc_mode == QUERY){
    PutResultToSubstance(sub_info, node->query_id);
  }
  free(sub_info);

"};

static char return_proc_list[]={"
  sendMsg = MakeReplyMessage(data, WIstart_msg);
  CQEnqueue(NPQ, sendMsg);

"};

static char np_proc_list[]={"
  sendMsg = MakeAskMessage(\"%s\", %s, WItid, method, data);
  memset(buffer, \'\\0\', BUFSIZE);
  sprintf(buffer, \"%%d\", WIworld);
  CSMPutMidStr(sendMsg, buffer);
  WIstart_msg = sendMsg;
  WIPush(%s, %s_init, new_tid());
  sendMsg = CSMDuplicateMessage(sendMsg);
  CSMPutTidStr(sendMsg, WItid);
  CQEnqueue(NPQ, sendMsg);

"};

static char finish_proc_list[]={"
  if(WIstate == %s_finish){
    WIPop();
  }
  return TRUE;
}
"};


static int skip_end_of_sentence(void){
  int token;
  while(1){
    if((token = method_lex()) == ';') break;
  }
  return TRUE;
}

static int skip_end_of_def(int level){
  int token;
  while(def_level >= level){
    CLCLEX(token, FAIL);
    if(token == '{')      def_level += 1;
    else if(token == '}') def_level -= 1;
  }
  while(1){
    CLCLEX(token, FAIL);
    if(token == ';') break;
  }
  return TRUE;
}

int nego_parser(void)
{
  int token;
  int result;
  int indent;
  int proc_type;
  int event_type;
  
  char *state_list[LIST_MAX];
  para_data nego_para_list[LIST_MAX];
  int num_of_nego_para;
  para_data arg_id[ARG_MAX]; /* arg_id[i] has the name of parameter "#*" */
  int  num_of_arg;
  int num_of_state;
  char nego_name[BUFSIZE];
  char state[BUFSIZE];
  char buffer[BUFSIZE], *ptr;
  char signature[BUFSIZE];
  char np_name[BUFSIZE];
  int i;
  
  def_level = 0;
  result = TRUE;
  num_of_nego_event = -1;
  indent = 0;
  for(i = 0; i < ARG_MAX; i++){
    arg_id[i].para_name = NULL;
    arg_id[i].para_init = NULL;
    arg_id[i].para_type = NULL;
  }
 EACH_STRATEGY:
  /*------------------
   * $B8r>D@oN,L>$N3MF@(B
   -------------------*/
  CLCLEX(token, FAIL);
  if(token == STRING){
    strcpy(nego_name, clcword);
    np_name_list[num_of_np_name++]=strdup(clcword);
  }
  else if(token_is_keyword(token) == TRUE){
    clcunlex(token);
    goto STRATEGY_FINISH;
  }
  else{
    warning("illegal negotiation strategy name");
    skip_end_of_def(def_level);
  }
    
  /*---------------------
   *$B8r>D@oN,$N=hM}$N3MF@(B
   ----------------------*/
  CLCLEX(token, FAIL);
  if(token != '{'){
    warning("not find {");
    clcunlex(token);
  }
  def_level += 1;
    
  /*------------
   * $B>uBV$N<hF@(B
   -------------*/
  CLCLEX(token, FAIL);
  if(token == STATE_DEF){
    num_of_state = np_state_parser(NEGO, nego_name, state_list, LIST_MAX);
    if(num_of_state < 0) result = FAIL;
  }
    
  /*-----------------
   *$B%Q%i%a!<%?$N<hF@(B
   ------------------*/
  CLCLEX(token, FAIL);
  if(token == PARA_DEF){
    num_of_nego_para = np_para_parser(NEGO, nego_name,
				      nego_para_list, ARG_MAX);
    if(num_of_nego_para < 0) result = FAIL;
  }
  else{
    clcunlex(token);
  }
    
  /*------------------------------
   * $B>uBV$4$H$N%$%Y%s%H$NFI$_9~$_(B
   -------------------------------*/
 EACH_STATE:
  /*--------------
   * $B>uBVL>$N3NG'(B
   ---------------*/
  CLCLEX(token, FAIL);
  if(token == STRING){
    memset(buffer, '\0', BUFSIZE);
    sprintf(buffer, "%s_%s", nego_name, clcword);
    if(check_list(buffer, state_list) != -1){
      strcpy(state, buffer);
    }
    else{
      warning("undefined state");
      fprintf(stderr, "undefined state = %s\n", buffer);
      skip_end_of_def(def_level);
      result = FAIL;
      goto EACH_STATE;
    }
  }
  else if(token == '}'){
    def_level -= 1;
    CLCLEX(token, FAIL);
    goto EACH_STRATEGY;
  }
  else{
    warning("illegal state description");
      skip_end_of_def(def_level);
      result = FAIL;
      goto EACH_STATE;
  }
  CLCLEX(token, FAIL);
  if(token != ':'){
    warning("not find :");
  }

 EACH_EVENT:
  CLCLEX(token, FAIL);
  /*----------------------------
   * $B3F%$%Y%s%H$N5-=R$N<h$j9~$_(B
   -----------------------------*/
  if(token == '}'){
    def_level -= 1;
    CLCLEX(token, FAIL);
    if(token != ';'){
      warning("illegal end of event");
    }
    goto EACH_STRATEGY;
  }
  else if(token == STRING){
    clcunlex(token);
    goto EACH_STATE;
  }
  else if(token != EXTERNAL && token != CAPSULE && token != SUBSTANCE &&
	  token != NEGO_RESULT && token != PROC_RESULT){
    warning("illegal evnet definition");
    skip_end_of_def(def_level);
    goto EACH_EVENT;
  }
  if(++num_of_nego_event == NEGO_MAX){
    warning("negotiation event table is overflow");
    result = FAIL;
  }
  event_type = token;
  nego_event_list[num_of_nego_event].np_name = strdup(nego_name);
  nego_event_list[num_of_nego_event].state = strdup(state);
  memset(buffer,'\0', BUFSIZE);
  ptr = buffer;
  switch(token){
  case EXTERNAL:
    /* $B8r>D$G$OA4$F$,(B ASK $B%a%C%;!<%8(B */
    nego_event_list[num_of_nego_event].mtype = ASK;
    nego_event_list[num_of_nego_event].queue = MSGQ;
    sprintf(ptr, "%s_External_", state);
    break;
  case SUBSTANCE:
    /* ASK/REPLY $B$O4X78$7$J$$(B */
    nego_event_list[num_of_nego_event].mtype = -1;
    nego_event_list[num_of_nego_event].queue = SIQ;
    sprintf(ptr, "%s_SubInfo_", state);
    break;
  case CAPSULE:
    /* $B<jB3$-!&8r>D$+$i$N8r>D5/F0(B */
    nego_event_list[num_of_nego_event].mtype = ASK;
    nego_event_list[num_of_nego_event].queue = NPQ;
    sprintf(ptr, "%s_NegoProc_", state);
    break;
  case NEGO_RESULT:
    /* $B8r>D$+$i$N7k2L<u$1<h$j(B */
    nego_event_list[num_of_nego_event].mtype = NEGO_RESULT;
    nego_event_list[num_of_nego_event].queue = NPQ;
    sprintf(ptr, "%s_NegoResult_", state);
    break;
  case PROC_RESULT:
    /* $B<jB3$-$+$i$N7k2L<u$1<h$j(B */
    nego_event_list[num_of_nego_event].mtype = PROC_RESULT;
    nego_event_list[num_of_nego_event].queue = NPQ;
    sprintf(ptr, "%s_ProcResult_", state);
    break;
  }
  ptr = strchr(ptr, '\0');
  /*----------------
   * $B%a%=%C%I$N<hF@(B
   -----------------*/
  CLCLEX(token, FAIL);
  if(token != STRING){
    warning("illegal event method description");
    result = FAIL;
    skip_end_of_def(def_level);
    goto EACH_EVENT;
  }
  /*--------------
   * $B4X?tL>$N@8@.(B
   ---------------*/
  nego_event_list[num_of_nego_event].method = strdup(clcword);
  sprintf(ptr, "%s", clcword);
  nego_event_list[num_of_nego_event].func_name = strdup(buffer);
  fprintf(func_fp, "int %s(SMessage smg){\n", buffer);
  fprintf(func_fp, "  char method[BUFSIZE];\n");
  fprintf(func_fp, "  char to[BUFSIZE];\n");
  fprintf(func_fp, "  char manage[BUFSIZE];\n");
  fprintf(func_fp, "  char data[BUFSIZE], *strPtr;\n");
  fprintf(func_fp, "  char *sub_info;\n");
  fprintf(func_fp, "  SMessage sendMsg;\n");
  fprintf(func_fp, "  CDATA tmp0, tmp1;\n\n");

  for(i = 0; i < ARG_MAX; i++){
    if(arg_id[i].para_name != NULL) free(arg_id[i].para_name);
    if(arg_id[i].para_init != NULL) free(arg_id[i].para_init);
    if(arg_id[i].para_type != NULL) free(arg_id[i].para_type);
    arg_id[i].para_name = NULL;
    arg_id[i].para_init = NULL;
    arg_id[i].para_type = NULL;
  }
  num_of_arg = 0;
  CLCLEX(token, FAIL);
  if(token == '@'){
    /*----------------------
     * $BF~NO%G!<%?$N<h$j9~$_(B
     -----------------------*/
    ptr = signature;
    memset(signature, '\0', BUFSIZE);
    while(1){
      CLCLEX(token, FAIL);
      if(token == FROM || token == METHOD_SEP) break;
      else if(token == VARIABLE){
	if(num_of_arg > ARG_MAX){
	  warning("table of event arg is overflow.");
	  while(1){
	    CLCLEX(token, FAIL);
	    if(token == METHOD_SEP){
	      clcunlex(token);
	      break;
	    }
	  }
	  result = FAIL;
	  break;
	}
	sprintf(ptr, "#%s", clcword);
	ptr = strchr(ptr, '\0');
	arg_id[num_of_arg].para_name = strdup(clcword);
	CLCLEX(token, FAIL);
	if(token != ':'){
	  warning("illegal separator of data and type");
	}
	CLCLEX(token, FAIL);
	if(token != STRING){
	  warning("illegal data type");
	}
	arg_id[num_of_arg].para_type = strdup(clcword);
	switch(check_common_type_type(clcword)){
	case INT_TYPE:
	  fprintf(func_fp, "  int int_%s;\n", arg_id[num_of_arg].para_name);
	  break;
	case STR_TYPE:
	  fprintf(func_fp, "  char *str_%s;\n", arg_id[num_of_arg].para_name);
	  break;
	case BOOL_TYPE:
	  fprintf(func_fp, "  int bool_%s;\n", arg_id[num_of_arg].para_name);
	  break;
	default:
	  break;
	}
	num_of_arg++;
	if(check_common_type_type(clcword) == NO_TYPE){
	  result = FAIL;
	}
	sprintf(ptr, ":%s", clcword);
	ptr = strchr(ptr, '\0');
      }
      else if(token == STRING){
	sprintf(ptr, "%s", clcword);
	ptr = strchr(ptr, '\0');
      }
      else if(clcword[0] == '\0'){
	sprintf(ptr, "%c", (char)token);
	ptr = strchr(ptr, '\0');
      }
      else warning("illegal signature description");
    }

    /* $BJQ?t@k8@$N=PNO(B */
    fprintf(func_fp, "  CDATA args;\n");
    fprintf(func_fp, "  CDATA tmps;\n");
    fprintf(func_fp, "  CDATA arg[%d];\n", num_of_arg);
    fprintf(func_fp, "  char arg_str[BUFSIZE];\n");

    /* $BJV?.%a%C%;!<%8$N@8@.$HAw?.(B */
    fprintf(func_fp, "  sendMsg = MakeReplyMessage(\"<true>\", smg);\n");
    fprintf(func_fp, "  send_message(sendMsg);\n");

    /* $BF~NO%G!<%?$N<h$j9~$_(B */
    if(event_type == SUBSTANCE){
      fprintf(func_fp, 
	      "  args = CAPPSubstanceConvLocalCommon(CSMGetMethodStr(smg),
					             CSMGetDataStr(smg));\n");
      
    }
    if(event_type == EXTERNAL || event_type == NEGO_RESULT ||
       event_type == PROC_RESULT || event_type == CAPSULE){
      fprintf(func_fp, "  tmps = CCommonToStruct(CSMGetDataStr(smg));\n");
      fprintf(func_fp, "  args = CCommonParse(\"%s\", tmps);\n", signature);
    }
    for(i = 0; i < num_of_arg; i++){
      fprintf(func_fp, "  tmp1 = CTGetElement(args, \"#%s\");\n", arg_id[i].para_name);
      fprintf(func_fp, "  arg[%d] = CLGetElement(tmp1, 0);\n", i);
      fprintf(func_fp, "  CDelete(tmp1);\n");
    }
    if(event_type == EXTERNAL || event_type == NEGO_RESULT ||
       event_type == PROC_RESULT || event_type == CAPSULE){
      fprintf(func_fp, "  CDelete(tmps);\n");
    }
    fprintf(func_fp, "  CDelete(args);\n");
    fprintf(func_fp, "  sendMsg = CSMInit();\n\n");
  }
  if(token == FROM){
    CLCLEX(token, FAIL);
    if(token == PARAMETER){
      if(check_common_type(clcword, nego_para_list, num_of_nego_para)
	 != NO_TYPE){
	fprintf(func_fp,
		"  WIlPar.%s_par.%s = CCommonToStruct(CSMGetFromAidStr(smg));\n",
		nego_name, clcword);
      }
      else if(check_common_type(clcword, para_list, num_of_para) != NO_TYPE){
	fprintf(func_fp,
		"  if(AIcPar.%s == NULL)\n    CDelete(AIcPar.%s);\n",
		clcword, clcword);
	fprintf(func_fp,
		"  AIcPar.%s = CCommonToStruct(CSMGetFromAisStr(smg));\n",
		clcword);
      }
      else{
	warning("unknwon such parameter");
	fprintf(stderr, "\t$%s is not defined.\n", clcword);
	result = FAIL;
      }
    }
    else{
      warning("you must use a parameter at source address");
      result = FAIL;
    }
  }
  else{
    clcunlex(token);
  }

  /*----------------
   * $B=hM}$N<h$j9~$_(B
   -----------------*/
  CLCLEX(token, FAIL);
  if(token != METHOD_SEP){
    warning("illegal definition");
  }
  CLCLEX(token, FAIL);
  if(token == '{'){
    def_level += 1;
  }
  else{
    warning("illegal definition");
  }
 EACH_PROCEDURE:
  CLCLEX(token, FAIL);
  if(token == '}'){
    def_level -= 1;
    CLCLEX(token, FAIL);
    if(token != ';'){
      warning("illegal end of definition");
      result = FAIL;
      clcunlex(token);
    }
    fprintf(func_fp, finish_proc_list, nego_name);
    goto EACH_EVENT;
  }
  proc_type = token;
  if(proc_type == EXTERNAL ||
     proc_type == SUBSTANCE || proc_type == RETURN ||
     proc_type == CALL_PROC || proc_type == CALL_NEGO){
    /* $BAw?.@h$N<h$j9~$_(B     */
    CLCLEX(token,FAIL);
    if(proc_type == CALL_PROC || proc_type == CALL_NEGO){
      if(token != STRING){
	warning("illegal negotiation strategy name/capsule procedure name");
      }
      strcpy(np_name, clcword);
    }
    else if(proc_type == EXTERNAL && token != '!'){
      fprintf(func_fp, "  memset(to , \'\\0\', BUFSIZE);\n");
      fprintf(func_fp, "  memset(manage, \'\\0\', BUFSIZE);\n");
      fprintf(func_fp, "  strPtr = to;\n");
      clcunlex(token);
      result = np_proc_from_parser(nego_name,
				   arg_id, num_of_arg,
				   para_list, num_of_para,
				   nego_para_list, num_of_nego_para,
				   0);
    }
    else{
      clcunlex(token);
    }
    /* $B%a%=%C%I$N<h$j9~$_$H%a%C%;!<%8$NAw?.(B */
    CLCLEX(token, FAIL);
    if(token == STRING){
      fprintf(func_fp, "  strcpy(method, \"%s\");\n", clcword);
    }
    else{
      warning("illegal substance procedure");
      skip_end_of_def(def_level);
      goto EACH_PROCEDURE;
      result = FAIL;
    }
    /* $B%G!<%?$N<h$j9~$_(B */
    CLCLEX(token, FAIL);
    fprintf(func_fp, "  memset(data, \'\\0\', BUFSIZE);\n");
    if(token == '@'){
      fprintf(func_fp, "  strPtr = data;\n");
      result = np_proc_args_parser(nego_name,
				   arg_id, num_of_arg,
				   para_list, num_of_para,
				   nego_para_list, num_of_nego_para,
				   0, NO_TYPE, 0, ';');
      fprintf(func_fp, "  *(--strPtr) = \'\\0\';\n");
    }
    else if(token != ';'){
      warning("illegal method separator");
      clcunlex(token);
      result = FAIL;
    }
    if(proc_type == EXTERNAL){
      fprintf(func_fp, external_proc_list);
    }
    else if(proc_type == SUBSTANCE){
      fprintf(func_fp, substance_proc_list);
    }
    else if(proc_type == RETURN){
      fprintf(func_fp, return_proc_list);
    }
    else if(proc_type == CALL_PROC || proc_type == CALL_NEGO){
      fprintf(func_fp, np_proc_list, np_name, "NULL", np_name, nego_name);
    }
  }
  else if(proc_type == NEXT_ST){
    CLCLEX(token, FAIL);
    if(token == STRING){
      memset(buffer, '\0', BUFSIZE);
      sprintf(buffer, "%s_%s", nego_name, clcword);
      if(check_list(buffer, state_list) != -1){
	fprintf(func_fp, "  WIChangeState(%s);\n", buffer);
      }
      else{
	warning("unknown state");
	result = FAIL;
      }
      skip_end_of_sentence();
    }
  }
  else if(proc_type == STRING || strcmp(clcword, "if") == 0){ /* if $B$J$i$P(B */
    CLCLEX(token, FAIL);
    if(token != '('){
      warning("illegal syntax of if");
    }
    fprintf(func_fp, "  if(");
    result = compare_exp_parser(nego_name,
				arg_id, num_of_arg,
				para_list, num_of_para,
				nego_para_list, num_of_nego_para);
    CLCLEX(token, FAIL);
    if(token != ')'){
      warning("illegal syntax of if");
    }
    fprintf(func_fp, ")");
  }
  else if(proc_type == STRING && strcmp(clcword, "else") == 0){ /* if $B$J$i$P(B */
    fprintf(func_fp, "else");
  }
  else if(proc_type == VARIABLE || proc_type == PARAMETER){ /* $B<jB3$-$J$i$P(B */
    clcunlex(token);
    result = assign_exp_parser(nego_name,
			       arg_id, num_of_arg,
			       para_list, num_of_para,
			       nego_para_list, num_of_nego_para);
  }
  else if(token == '{'){
    def_level += 1;
    fprintf(func_fp, "{\n");
  }
  else if(token == '}'){
    def_level -= 1;
    if(def_level > 1){
      fprintf(func_fp, "}\n");
    }
    else{
      CLCLEX(token, FAIL);
      if(token != ';') clcunlex(token);
      goto EACH_EVENT;
    }
  }
  goto EACH_PROCEDURE;
 STRATEGY_FINISH:
  num_of_nego_event++;
  return result;
}
/* end of nego_parser.c */
