/* method_sig_parser.c */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "define.h"
#include "capldata.h"
#include "warn.h"
#include "lex.h"
#include "parsers.h"
#include "parser.h"
#include "tokens.h"
#include "check_type.h"
#include "np_proc_sig_parser.h"

extern int method_lex(void);
extern FILE *func_fp;

#define CHG_FLAG(flag) ((++flag)%2)

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int method_args_parser(char *np_name,
		       char *args[], int num_of_args,
		       para_data para_list[], int num_of_para,
		       int top, int type, int flag, char mark)
{
  int token;
  int result;

  result = TRUE;
  CLCLEX(token, FAIL);
  if(token == mark){
    return TRUE;
  }
  clcunlex(token);
  while(1){
    CLCLEX(token, FAIL);
    if(type == TUPLE_TYPE){
      if(token != STRING){
	fprintf(stderr, "illegal common data description of siganture");
      }
      CLCLEX(token, FAIL);
      if(token != '='){
	fprintf(stderr, "illegal common data description of siganture");
      }
    }
    if(token == PARAMETER ||token == VARIABLE){
      result = np_proc_arg_parser(np_name,
				  args, num_of_args,
				  para_list, num_of_para,
				  token, token, flag);
    }
    else if(token == STRING || token == QSTRING || token == NUMBER){
      fprintf(func_fp, "  sprintf(strPtr, \"%s\");\n", clcword);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
    else if(token == '['){
      fprintf(func_fp, "  sprintf(strPtr, \"[\");\n");
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
      result = np_proc_args_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   token, LIST_TYPE, flag, ']');
    }
    else if(token == '<'){
      fprintf(func_fp, "  sprintf(strPtr, \"<\");\n");
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
      result = np_proc_args_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   token, VEC_TYPE, flag, '>');
    }
    else if(token == '('){
      fprintf(func_fp, "  sprintf(strPtr, \"(\");\n");
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
      result = np_proc_args_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   token, TUPLE_TYPE, flag, ')');
    }
    else{
      warning("illegal signature of procedure");
    }
    CLCLEX(token, FAIL);
    if(token == mark){
      break;
    }
    else if(clcword[0] == '\0'){
      fprintf(func_fp, "  sprintf(strPtr, \"%c\");\n", token);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
  }
  if(result == TRUE){
    fprintf(func_fp, "  sprintf(strPtr, \"%c\");\n", mark);
    fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
  }
  else{
    return FAIL;
  }
  return result;
}

int method_arg_parser(char *np_name,
		      char *args[], int num_of_args,
		      para_data para_list[], int num_of_para,
		      int top, int type, int flag)
{
  int i;
  int pre_flag;
  int token;
  int result;
  result = TRUE;
  if(top == PARAMETER){
    if(check_common_type(clcword, np_para_list, num_of_np_para) != NO_TYPE){
      fprintf(func_fp, "  tmp%d = CDuplicate(WIlPar.%s_par.%s);\n",
	      flag, np_name, clcword);
    }
    else if(check_common_type(clcword, para_list, num_of_para) != NO_TYPE){
      fprintf(func_fp, "  tmp%d = CDuplicate(AIcPar.%s);\n",
	      flag, clcword);
    }
    else{
      result = FAIL;
      warning("undefined parameter");
      fprintf(stderr, "\t$%s is not defined.", clcword);
    }
  }
  else if(top == VARIABLE){
    for(i = 0; i < num_of_args; i++){
      if(strcmp(clcword, args[i]) == 0) break;
    }
    if(i < num_of_args){
      fprintf(func_fp, "  tmp%d = CDuplicate(arg[%d]);\n", flag, i);
    }
    else{
      result = FAIL;
      warning("undefine data");
      fprintf(stderr, "\t#%s dose not exit in event signature.\n", clcword);
    }
  }
  else{
    fprintf(stderr, "capl compiler errorin np_proc_arg_parser()\n");
  }

  while(1){
    CLCLEX(token, FAIL);
    if(token == '.'){
      CLCLEX(token, FAIL);
      if(token == STRING){
	pre_flag = flag;
	flag = (++flag)%2;
	fprintf(func_fp,
		"  tmp%d = CLGetElement(tmp%d, \"%s\");\n",
		flag, pre_flag, clcword);
	fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
	fprintf(func_fp, "  CDelete(tmp%d);\n", pre_flag);
      }
      else if(token == NUMBER){
	pre_flag = flag;
	flag = (++flag)%2;
	fprintf(func_fp,
		"tmp%d = CLGetElement(tmp%d, %s);\n", flag, pre_flag, clcword);
	fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
	fprintf(func_fp, "  CDelete(tmp%d);\n", pre_flag);
      }
    }
    else{
      clcunlex(token);
      break;
    }
  }
  if(result == TRUE){
    fprintf(func_fp,
	    "  sprintf(strPtr, \"\%%s\", CStructToCommon(tmp%d));\n", flag);
    fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    fprintf(func_fp, "  CDelete(tmp%d);\n", flag);
    return TRUE;
  }
  else{
    return FAIL;
  }
}

int np_proc_from_parser(char *np_name,
			char *args[], int num_of_args,
			para_data para_list[], int num_of_para,
			int flag)
			
{
  /*
   * - member #1 #2 , bag_of ! 
   * + #1 #2 #3 , bag_of !
   * meeting , bag_of !
   * &external_reply meeting1 ! method @
   * &exernal_reply ! meeting
   */
  int token;
  int result;

  result = TRUE;
  while(1){
    CLCLEX(token, FAIL);
    if(token == STRING || token == NUMBER){
      fprintf(func_fp, "  sprintf(strPtr, \"%s \");\n", clcword);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
    else if(token == PARAMETER || token == VARIABLE){
      result = method_arg_parser(np_name,
				 args, num_of_args,
				 para_list, num_of_para,
				 token, token, flag);
    }
    else if(token == ','){
      fprintf(func_fp, "  CCommonToTOstring(buffer, to);\n");
      CLCLEX(token, FAIL);
      if(token == STRING){
	fprintf(func_fp, "  sprintf(manage, \"%s\");\n", clcword);
      }
      else{
	warning("illegal destination address.");
	result = FAIL;
      }
      CLCLEX(token, FAIL);
      if(token != '!'){
	warning("separtor between address and method.");
      }
      break;
    }
    else if(token == '!'){
      fprintf(func_fp, "  CCommonToTOstring(buffer, to);\n");
      break;
    }
    else if(clcword[0] == '\0'){ 
      fprintf(func_fp, "  sprintf(strPtr, \"%c \");\n", (char)token);
      fprintf(func_fp, "  strPtr = strchr(strPtr, \'\\0\');\n");
    }
  }
  return result;
}

/* end of method_sig_parser.c */
