/* method_lex.c
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include "warn.h"
#include "lex.h"
#include "tokens.h"

int method_lex(void)
{
  int token;
  int c;

  if(ungettoken != 0){
    token = ungettoken;
    ungettoken = 0;
    return token;
  }

  memset(clcword, '\0', BUFSIZE);
  while((c = clcgetc()) != EOF){
    if(c == '%'){ /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while((c = clcgetc()) != '\n');
      lineno += 1;
      continue;
    }
    else if(c == ' ' || c == '\t') continue;
    else if(c == '\n'){
      lineno += 1;
      continue;
    }
    else if(c == '-'){
      if((c = clcgetc()) == '>') return SIG_SEP;
      else{
	clcungetc(c);
	return '-';
      }
    }
    else if(c == '='){
      if((c = clcgetc()) == '>') return METHOD_SEP;
      else if(c == '=') return EQL;
      else{
	clcungetc(c);
	return '=';
      }
    }
    else if(c == ':'){
      c = clcgetc();
      if(c == '=') return ASSIGN;
      else{
	clcungetc(c);
	return ':';
      }
    }
    else if(c == '<'){
      if((c = clcgetc()) == '='){
	if((c = clcgetc()) == '>'){
	  return CONV_SEP;
	}
	else{
	  clcungetc(c);
	  return LESSEQ;
	}
      }
      else{
	clcungetc(c);
	return '<';
      }
    }
    else if(c == '>'){
      if((c = clcgetc()) == '='){
	return GREATEREQ;
      }
      else{
	clcungetc(c);
	return '>';
      }
    }
    else if(c == '!'){
      if((c = clcgetc()) == '='){
	return NOT_EQ;
      }
      else{
	clcungetc(c);
	return '!';
      }
    }
    else if(isdigit(c)){
      clc_get_number(c);
      return NUMBER;
    }
    else if(c == '&'){
      clc_get_string('\0');
      return check_keyword_id(keyword_list);
    }
    else if(isalpha(c) || c == '_'){
      clc_get_string(c);
      return STRING;
    }
    else if(c == '"'){
      clc_get_qstring();
      return QSTRING;
    }
    else if(c == '#'){
      clc_get_number('\0');
      return VARIABLE;
    }
    else if(c == '$'){
      clc_get_string('\0');
      return PARAMETER;
    }
    else return c;
  }
  return c;
}
/* end of method_lex.c */
