/* make_table_file.c */

#include <stdio.h>
#include <define.h>
#include <tokens.h>
#include <capldata.h>
#include <check_type.h>

extern FILE *table_fp;

static void make_method_procedure_table(void)
{
  int i;

  fprintf(table_fp, "NPMethodData MethodList[]={\n");
  for(i = 0; i < num_of_import; i++){
    fprintf(table_fp, "  { ASK, MSGQ, NORMAL, QUERY_WAIT, ");
    if(import[i].dist == CALL_SUB){
      fprintf(table_fp, "ASKtoCALL, \"%s\"},\n", import[i].out_method);
    }
    else if(import[i].dist == CALL_PROC || import[i].dist == CALL_NEGO){
      fprintf(table_fp, "ASKto_%s, \"%s\" },\n", import[i].np_name, import[i].out_method);
      fprintf(table_fp,
	      "  { REPLY, SIQ, NORMAL, NP_RUNNING, %s_toREPLY, \"%s\" },\n",
	      import[i].np_name, import[i].out_method);
    }
    if(lock_swt == OFF){
      fprintf(table_fp, "  { ASK, MSGQ, NORMAL, REPLY_WAIT, ");
      if(import[i].dist == CALL_SUB){
	fprintf(table_fp, "ASKtoCALL, \"%s\" },\n", import[i].out_method);
      }
      else if(import[i].dist == CALL_PROC || import[i].dist == CALL_NEGO){
	fprintf(table_fp, "ASKto_%s, \"%s\" },\n", import[i].np_name, import[i].out_method);
	fprintf(table_fp,
		"  { REPLY, SIQ, NORMAL, NP_RUNNING, %s_toREPLY, \"%s\" },\n",
		import[i].np_name, import[i].out_method);
      }
    }
  }
  for(i = 0; i < num_of_export; i++){
    fprintf(table_fp,
	    "  { REPLY, MSGQ, NORMAL, REPLY_WAIT, RESULTtoREPLY, \"%s\" },\n",
	    export[i].out_method);
  }
  for(i = 0; i < num_of_query; i++){
    fprintf(table_fp,
	    "  { ASK, SIQ, NORMAL, RUNNING, ");
    if(query[i].dist == EX_ASK){
      fprintf(table_fp, "QUERYtoCALL, \"%s\"},\n", query[i].out_method);
    }
    else if(query[i].dist == CALL_PROC || query[i].dist == CALL_NEGO){
      fprintf(table_fp,
	      "QUERYto_%s, \"%s\"},\n",
	      query[i].np_name, query[i].out_method);
      fprintf(table_fp,
	      "  {REPLY, NPQ, NORMAL, NP_RUNNING, %s_toRESULT, \"%s\"},\n",
	      query[i].np_name, query[i].out_method);
    }
  }
  for(i = 0; i < num_of_call; i++){
    fprintf(table_fp,
	    "  {REPLY, NPQ, NORMAL, RUNNING, RESULTtoREPLY, \"%s\"},\n",
	    call[i].out_method);
  }

  for(i = 0; i < num_of_nego_event; i++){
    fprintf(table_fp, "  { %d, %d, %s, %s, %s, \"%s\"},\n",
	    nego_event_list[i].mtype,
	    nego_event_list[i].queue,
	    nego_event_list[i].np_name,
	    nego_event_list[i].state,
	    nego_event_list[i].func_name,
	    nego_event_list[i].method);
  }
  for(i = 0; i < num_of_proc_event; i++){
    fprintf(table_fp, "  { %d, %d, %s, %s, %s, \"%s\"},\n",
	    proc_event_list[i].mtype,
	    proc_event_list[i].queue,
	    proc_event_list[i].np_name,
	    proc_event_list[i].state,
	    proc_event_list[i].func_name,
	    proc_event_list[i].method);
  }
  fprintf(table_fp, "  {-1, -1, -1, -1, NULL, NULL}\n");
  fprintf(table_fp, "};\n\n");
}

static void make_nego_proc_init_free_table(void)
{
  int i;

  fprintf(table_fp, "NPInitFreeList npInitFreeList[]={\n");
  for(i = 0; i < num_of_np_name; i++){
    fprintf(table_fp, "  { %s, ParaInit_%s, ParaFree_%s },\n",
	    np_name_list[i], np_name_list[i], np_name_list[i]);
  }
  fprintf(table_fp, "  { -1, NULL, NULL }\n");
  fprintf(table_fp, "};\n\n");
}

static void make_ask_proc_table(void)
{
  int i;
  
  fprintf(table_fp, "AskProc askPro[]={\n");
  for(i = 0; i < num_of_export; i++){
    fprintf(table_fp, "  {\"%s\", ASK_PROC_%s}\n", export[i].in_method);
  }
  fprintf(table_fp, "{NULL, NULL}\n");
  fprintf(table_fp, "};\n\n");
}

/*
static void make_query_to_nego_proc(void)
{
}

static viod make_ask_query_to_nego_proc(void)
{
}

static void nego_proc_result_to_reply(void)
{
}

static void nego_proc_result_to_result(void)
{
}
*/

void make_method_table(void){
  make_nego_proc_init_free_table();
  make_method_procedure_table();
  make_ask_proc_table();
}
/* end of make_table_file.c */
