/* make_table.c
 */
/*
 * external_method_table
 * NORMAL$B$N>uBV$K$*$1$k30It$+$i$N%a%C%;!<%8$X$NBP1~(B
 *   <table> ::= <common method> <inner method> <type> <method procedure>
 *   <type> ::= ASK | REPLY
 *   <method procedure> ::= AskToCall | ReplyToResult
 *                        | AskToNEGO<negotiation stratetegy>  % by CAPL
 *                        | QueryToPROC<capsule strategy>      % by CAPL
 */

#include <stdio.h>
#include <string.h>
#include "capldata.h"
#include "warn.h"
#include "tokens.h"
#include "parser.h"
#include "check_type.h"

extern FILE *table_fp;
static char default_method_list[]={"
  { IMPORT, -1, \"begin_transaction\", NULL, NORMAL, \"NORMAL\", ASKBeginTransaction, NULL },
  { IMPORT, -1, \"commit\",            NULL, NORMAL, \"NORMAL\", ASKCommit,           NULL },
  { IMPORT, -1, \"begin_negotiation\", NULL, NORMAL, \"NORMAL\", ASKBeginNegotiation, NULL },
"};

static char agent_info_definition[]={
"typedef struct {
  int  subFd;
  int  activity;
  char agentName[BUFSIZE];
  char agentID[BUFSIZE];
  CommonPar cPar;
} AgentInfo;
AgentInfo agentInfo;
"};

static char world_info_definition[]={
"typedef struct {
  int  wtype;  /* NORMAL/0, PROC/1, NEGO/2 */
  World world;
  World preWorld;
  int stateID;
  State state[STACK_SIZE];
  char tid[BUFSIZE];
  LocalPar lPar;
  SMessage start_smg;
} WorldInfoM;
typedef WorldInfoM *WorldInfo;

#define WI         (worldInfo[worldID])
#define WIstate    (worldInfo[worldID]->state[worldInfo[worldID]->stateID])
#define WIstateID  (worldInfo[worldID]->stateID)
#define WItid      (worldInfo[worldID]->tid)
#define WIworld    (worldInfo[worldID]->world)
#define WIpreWorld (worldInfo[worldID]->preWorld)
#define WIlPar     (worldInfo[worldID]->lPar)

int       worldID = -1;
WorldInfo worldInfo[WORLD_SIZE];

"};

int make_state(void){
  int i;

  fprintf(table_fp, "typedef enum {\n");
  fprintf(table_fp, "  NO_STATE = -1,\n");
  fprintf(table_fp, "  QUERY_WAIT,\n");
  fprintf(table_fp, "  REPLY_WAIT,\n");
  fprintf(table_fp, "  RUNNING,\n");
  fprintf(table_fp, "  RUNNING2,\n");
  fprintf(table_fp, "  N_RUNNING,\n");
  fprintf(table_fp, "  P_RUNNING,\n");
  for(i = 0; i < num_of_np_state; i++){
    fprintf(table_fp, "  %s,\n", np_state[i]);
  }
  fprintf(table_fp,"} State;\n\n");
  return TRUE;
}

int make_world(void){
  int i, j, n;
  char *np_name[TABLE_MAX];
  int np_type[TABLE_MAX];

  n = 0;
  for(i = 0; i < num_of_import; i++){
    if(import_list[i].dist != SUB_CALL){
      for(j = 0; j < n; j++){
	if(strcmp(np_name[j], import_list[i].np_name) == 0) break;
      }
      if(j == n){
	np_type[n] = import_list[i].dist;
	np_name[n] = strdup(import_list[i].np_name);
	n++;
      }
    }
  }
  for(i = 0; i < num_of_query; i++){
    if(query_list[i].dist != EX_ASK){
      for(j = 0; j < n; j++){
	if(strcmp(np_name[j], query_list[i].np_name) == 0) break;
      }
      if(j == n){
	np_type[n] = query_list[i].dist;
	np_name[n] = strdup(query_list[i].np_name);
	n++;
      }
    }
  }
  fprintf(table_fp, "typedef enum {\n");
  fprintf(table_fp, "  NO_WORLD = -1,\n");
  fprintf(table_fp, "  NORMAL,\n");
  for(i = 0; i < n; i++){
    fprintf(table_fp, "  %s,\n", np_name[i]);
  }
  fprintf(table_fp, "} World;\n\n");

  fprintf(table_fp, "struct {\n");
  fprintf(table_fp, "  char *world_name; World world; State init;\n");
  fprintf(table_fp, "} world_list[] = {\n");
  for(i = 0; i < n; i++){
    fprintf(table_fp, "  {\"%s\", %s, ", np_name[i], np_name[i]);
    if(np_type[i] == CALL_PROC){
      fprintf(table_fp, "PROC_%s_init },\n", np_name[i]);
    }
    else if(np_type[i] == CALL_NEGO){
      fprintf(table_fp, "NEGO_%s_init },\n", np_name[i]);
    }
  }
  fprintf(table_fp, "  { \"NORMAL\", NORMAL, NO_STATE },\n");
  fprintf(table_fp, "  { NULL, NO_WORLD, NO_STATE }\n};\n");

  fprintf(table_fp, "typedef union {\n");
  for(i = 0; i < n; i++){
    fprintf(table_fp, "  %sPar %s;\n", np_name[i], np_name[i]);
  }
  fprintf(table_fp, "} LocalParM;\n");
  fprintf(table_fp, "typedef LocalParM *LocalPar;\n");
  fprintf(table_fp, world_info_definition);

  return TRUE;
}
int make_method_table(void){
  int i;

  fprintf(table_fp, "MethodData MethodList[]={");
  fprintf(table_fp, default_method_list);
  for(i = 0; i < num_of_import; i++){
    if(import_list[i].dist == SUB_CALL){
      fprintf(table_fp,
	      "  { IMPORT, SUB_CALL, \"%s\", \"%s\",\n    NORMAL, \"NORMAL\", ASKtoCALL, NULL },\n",
	      import_list[i].common_method, import_list[i].inner_method);
    }
    else if(import_list[i].dist == CALL_NEGO){
      fprintf(table_fp,
	      "  { IMPORT, NEGO, \"%s\", \"%s\",\n    %s, \"%s\", ASKtoNEGO, NULL },\n",
	      import_list[i].common_method, import_list[i].inner_method,
	      import_list[i].np_name, import_list[i].np_name);
    }
    else if(import_list[i].dist == CALL_PROC){
      fprintf(table_fp,
	      "  { IMPORT, PROC, \"%s\", \"%s\",\n    %s, \"%s\", ASKtoPROC, NULL },\n",
	      import_list[i].common_method, import_list[i].inner_method,
	      import_list[i].np_name, import_list[i].np_name);
    }
  }

  for(i = 0; i < num_of_export; i++){
    fprintf(table_fp,
	    "  { EXPORT, RESULT, \"%s\", \"%s\",\n    NORMAL, \"NORMAL\", RESULTtoREPLY, ASK_%s },\n",
	    export_list[i].common_method, export_list[i].inner_method,
	    export_list[i].inner_method);
  }

  for(i = 0; i < num_of_call; i++){
    fprintf(table_fp,
	    "  { SUB_CALL, REPLY, \"%s\", \"%s\",\n    NORMAL, \"NORMAL\", RESULTtoREPLY, NULL },\n",
	    call_list[i].sub_proc, call_list[i].method);
  }
  for(i = 0; i < num_of_query; i++){
    if(query_list[i].dist == EX_ASK){
      fprintf(table_fp,
	      "  { SUB_QUERY, EX_ASK, \"%s\", \"%s\",\n    NORMAL, \"NORMAL\", QUERYtoASK, NULL },\n",
	      query_list[i].sub_proc, query_list[i].method);
    }
    else if(query_list[i].dist == CALL_NEGO){
      fprintf(table_fp,
	      "  { SUB_QUERY, NEGO, \"%s\", \"%s\",\n    %s, \"%s\", QUERYtoNEGO, NULL },\n",
	      query_list[i].sub_proc, query_list[i].method,
	      query_list[i].np_name, query_list[i].np_name);
    }
    else if(query_list[i].dist == CALL_PROC){
      fprintf(table_fp,
	      "  { SUB_QUERY, PROC, \"%s\", \"%s\",\n    %s, \"%s\", QUERYtoPROC, NULL },\n",
	      query_list[i].sub_proc, query_list[i].method,
	      query_list[i].np_name, query_list[i].np_name);
    }
  }
  fprintf(table_fp, "  { -1, -1, NULL, NULL, -1, NULL, NULL, NULL },\n");
  fprintf(table_fp, "};\n");
  return TRUE;
}

int make_nego_proc_procedure_table(void){
  int i;

  fprintf(table_fp, "nego_proc_proc_data nego_proc_proc_list[]={\n");
  for(i = 0; i < num_of_nego_event; i++){
    fprintf(table_fp, "  { NEGO, %s, %s, %d, %d,\n    \"%s\", %s },\n",
	    nego_event_list[i].np_name,
	    nego_event_list[i].state,
	    nego_event_list[i].queue,
	    nego_event_list[i].mtype,
	    nego_event_list[i].method,
	    nego_event_list[i].func_name);
  }
  for(i = 0; i < num_of_proc_event; i++){
    fprintf(table_fp, "  { PROC, %s, %s, %d, %d,\n    \"%s\", %s },\n",
	    proc_event_list[i].np_name,
	    proc_event_list[i].state,
	    proc_event_list[i].queue,
	    proc_event_list[i].mtype,
	    proc_event_list[i].method,
	    proc_event_list[i].func_name);
  }
  fprintf(table_fp, "  { -1, -1, -1, -1, -1, NULL, NULL },\n");
  fprintf(table_fp, "};\n\n");
  return TRUE;
}

int make_nego_proc_table(void)
{
  int i, j, n1, n2;
  char *np_name[TABLE_MAX];

  n1 = 0;
  fprintf(table_fp, "nego_proc_data nego_proc_list[]={\n");

  for(i = 0; i < num_of_import; i++){
    if(import_list[i].dist == CALL_NEGO){
      for(j = 0; j < n1; j++){
	if(strcmp(np_name[j], import_list[i].np_name) == 0) break;
      }
      if(j == n1){
	np_name[n1++] = strdup(import_list[i].np_name);
      }
      if(n1 == TABLE_MAX){
	warning("nego/proc name table is overflow");
	return FAIL;
      }
    }
  }
  for(i = 0; i < n1; i++){
    if(query_list[i].dist == CALL_NEGO){
      for(j = 0; j < n1; j++){
	if(strcmp(np_name[j], query_list[i].np_name) == 0) break;
      }
      if(j == n1){
	np_name[n1++] = strdup(query_list[i].np_name);
      }
      if(n1 == TABLE_MAX){
	warning("nego/proc name table is overflow");
	return FAIL;
      }
    }
  }
  for(i = 0; i < n1; i++){
    fprintf(table_fp,
	    "  { NEGO, %s,\n    NEGO_ParaInit_%s, NEGO_ParaFree_%s },\n",
	    np_name[i], np_name[i], np_name[i]);
  }

  n2 = n1;
  for(i = 0; i < num_of_import; i++){
    if(import_list[i].dist == CALL_PROC){
      for(j = 0; j < n2; j++){
	if(strcmp(np_name[j], import_list[i].np_name) == 0) break;
      }
      if(j == n2){
	np_name[n2++] = strdup(import_list[i].np_name);
      }
      if(n2 == TABLE_MAX){
	warning("nego/proc name table is overflow");
	return FAIL;
      }
    }
  }
  for(i = 0; i < n2; i++){
    if(query_list[i].dist == CALL_PROC){
      for(j = 0; j < n2; j++){
	if(strcmp(np_name[j], query_list[i].np_name) == 0) break;
      }
      if(j == n2){
	np_name[n2++] = strdup(query_list[i].np_name);
      }
      if(n2 == TABLE_MAX){
	warning("nego/proc name table is overflow");
	return FAIL;
      }
    }
  }
  for(i = n1; i < n2; i++){
    fprintf(table_fp,
	    "  { PROC, %s,\n    PROC_ParaInit_%s, PROC_ParaFree_%s },\n",
	    np_name[i], np_name[i], np_name[i]);
  }
  fprintf(table_fp, "  { -1, -1, -1, -1, -1, NULL, NULL },\n");
  fprintf(table_fp, "};\n\n");
  return TRUE;
}

int make_agent_info(void)
{
  fprintf(table_fp, "typedef struct {\n");
  get_para_definition(para_list, num_of_para);
  fprintf(table_fp, "} CommonParM;\n");
  fprintf(table_fp, "typedef CommonParM *CommonPar;\n");
  fprintf(table_fp, agent_info_definition);
  return TRUE;
}

int get_para_definition(para_data para_list[], int num_of_para)
{
  int i;
  for(i = 0; i < num_of_para; i++){
    fprintf(table_fp, "  CDATA %s;\n", para_list[i].para_name);
    switch(check_common_type_type(para_list[i].para_type)){
    case INT_TYPE:
      fprintf(table_fp, "  int int_%s;\n", para_list[i].para_name);
      break;
    case BOOL_TYPE:
      fprintf(table_fp, "  int bool_%s;\n", para_list[i].para_name);
      break;
    case STR_TYPE:
      fprintf(table_fp, "  char *str_%s;\n", para_list[i].para_name);
      break;
    case LIST_TYPE:
      fprintf(table_fp, "  char list_%s[BUFSIZE];\n", para_list[i].para_name);
      break;
    case VEC_TYPE:
      fprintf(table_fp, "  char vec_%s[BUFSIZE];\n", para_list[i].para_name);
      break;
    case TUPLE_TYPE:
      fprintf(table_fp, "  char tuple_%s[BUFSIZE];\n", para_list[i].para_name);
      break;
    }
  }
  return TRUE;
}

/* end of make_table.c */
