/* make_func.c
 */

#include <stdio.h>
#include <capldata.h>
#include <define.h>


extern FILE *func_fp;

static char default_method_proc_list[] ={
"
static char *new_tid()
{
  char buffer[BUFSIZE];
  static int no = -1;

  no = (no+1)%1000;
  sprintf(buffer, \"%%s_%%s\", agent_id, no);
  return strdup(buffer);
}

int QUERYtoASK(SMessage smg)
{
  CDATA tmps;
  char *data;
  char *inner_method;
  int i;
  int (*func)(char*, SMessage);

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPMethodConvCommonEnv(inner_method tmps);
    CDelete(tmps);
    func = SelectAskProcedure(EXPORT, inner_method);
    if(func != NULL) func(data, smg);
    free(data);
  }
  else{
    fprintf(stderr, \"Convert error from substance to common \\n\");
    fprintf(stderr, \"method = %%s\\n\", inner_method);
    fprintf(stderr, \"data   = %%s\\n\", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ASKtoQUERY */
int ASKtoCALL(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  char call_id[BUFSIZE];
  char errorSmg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    call_id = CallSubstanceProcedure(data, call_id);
    CREnqueue(smg, EXTERNAL, SUBSTANCE, call_id, worldID, Off);
    free(data);
  }
  else{
    fprintf(stderr, \"Convert error from common to substance \\n\");
    fprintf(stderr, \"method = %%s\\n\", inner_method);
    fprintf(stderr, \"data   = %%s\\n\", CSMGetDataStr(smg));
    AIactivity == EXIT;
    errorSmg = MakeErrorMessage(smg);
    send_message(errorSmg);
  }
  return TRUE;
}

/* ReplyToResult */
int REPLYtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPMethodConvEnvCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPSubstanceConvCommonLocal(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(SUBSTANCE, EXTERNAL,
		    CSMGetMisStr(smg), worldID, ON);
    PutResultToSubstance(data, node->query_id);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, \"Convert error from common to substance.\\n\");
    fprintf(stderr, \"method = \%s\\n\", inner_method);
    fprintf(stderr, \"data   = \%s\\n\", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ResultToReply */
int RESULTtoREPLY(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char *data;
  CRNode node;
  SMessage reply_smg;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CAPMethodConvCommonEnv(inner_method, tmps);
    CSMDelete(tmps);
    node = CRSelect(ECTERNAL, SUBSTANCE,
		    CSMGetMisStr(smg), worldID, ON);
    reply_smg = MakeReplyMessage(node->smg, data);
    send_message(reply_smg);
    free(data);
    CRNDelete(node);
  }
  else{
    fprintf(stderr, \"Convert error from substance to common.\\n\");
    fprintf(stderr, \"method = %%s\\n\", inner_method);
    fprintf(stderr, \"data   = %%s\\n\", CSMGetDataStr(smg));
    AIactivity == EXIT;
    reply_smg = MakeErrorMessage(node->smg);
    send_message(reply_smg);
  }
  return TRUE;
}

/* QUERYtoNEGO */
int QUERYtoNEGO(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char data[BUFSIZE];
  char *tid;
  SMessage new_smg;
  World world;
  char world_name[BUFSIZE];
  State init;

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    CREnqueue(smg, SUBSTANCE, NEGOTIATION, 
    data = CStructToCommon(tmps, data);
    tid = new_tid();
    new_smg = CSMDulicate(smg);
    CSMPutMethodStr(inner_method, new_smg);
    CSMPutDataStr(data, new_smg);
    CSMPutTidStr(tid, new_smg);
    CQEnqueue(SIQ, new_smg);
    world = SelectNegotiationStrategy(QUERY, CSMGetMethodStr(smg), world_name);
    init = SelectWorldInit(world);
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  else{
    fprintf(stderr, \"illegal data of method.\\n\");
    fprintf(stderr, \"method = %%s\\n\", inner_method);
    fprintf(stderr, \"data   = %%s\\n\", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* QUERYtoPROC */
int QUERYtoPROC(SMessage smg)
{
  CDATA tmps;
  char *inner_method;
  char data[BUFSIZE];
  char *tid;
  SMessage new_smg;
  World world;
  State init;
  char world_name[BUFSIZE];

  inner_method = CSMGetMethodStr(smg);
  tmps = CAPSubstanceConLocalCommon(inner_method, CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CStructToCommon(tmps, data);
    tid = new_tid();
    new_smg = CSMDulicate(smg);
    CSMPutMethodStr(inner_method, new_smg);
    CSMPutDataStr(data, new_smg);
    CSMPutTidStr(tid, new_smg);
    CQEnqueue(SIQ, new_smg);
    world = SelectCapsuleProcedure(QUERY, CSMGetMethodStr(smg), world_name);
    CREnqueue(smg, SUBSTANCE, PROCEDURE, world_name, worldID, OFF);
    init = SelectWorldInit(world);
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  else{
    fprintf(stderr, \"illegal data of method.\\n\");
    fprintf(stderr, \"method = %%s\\n\", inner_method);
    fprintf(stderr, \"data   = %%s\\n\", CSMGetDataStr(smg));
    AIactivity == EXIT;
  }
  return TRUE;
}

/* ASKtoNEGO */
int ASKtoNEGO(SMessage smg)
{
  char *tid;
  SMessage new_smg;
  Wolrd world;
  State init;
  char world_name[BUFSIZE];

  new_smg = CSMDuplicateMssage(smg);
  tid = new_tid();
  CSMPutTidStr(tid, new_smg);
  CQEnqueue(MsgQ, new_smg);
  world = SelectNegotiationStrategy(IMPORT, CSMGetMethodStr(smg), world_name);
  init = SelectWorldInit(world);
  CREnqueue(smg, EXTERNAL, NEGOTIATION, world_name, worldID, ON);
  WIPush(world, init, tid);
  NP_ParaInit(world)();
  return TRUE;
}

/* ASKtoPROC */
int ASKtoPROC(SMessage smg)
{
  char *tid;
  SMessage new_smg;
  Wolrd world;
  State init;
  char world_name[BUFSIZE];

  new_smg = CSMDuplicateMessage(smg);
  tid = new_tid();
  CSMPutTidStr(tid, new_smg);
  CQEnqueue(MSGQ, new_smg);
  world = SelectCapsuleProcedure(IMPORT, CSMGetMethodStr(smg), world_name);
  init = SelectWorldInit(world);
  CREnqueue(smg, EXTERNAL, PROCEDURE, world_name, worldID, ON);
  WIPush(world, init, tid);
  NP_ParaInit(world)();
  return TRUE;
}

/* NEGO_PROC_RESULTtoREPLY */
int NEGO_PROC_RESULTtoRESULT(SMessage smg)
{
  CDATA tmps;
  char *data;
  CRNode node;

  tmps = CCommonToStruct(CSMGetDataStr(smg));
  data = CAPSubstanceConvCommonLocal(CSMGetMethodStr(smg), tmps);
  CDelete(tmps);
  node = CRSelect(SUBSTANCE, NEGO_PROC,
		  CSMGetMidStr(smg), worldID, ON);
  PutResultToSubstance(data, node->query_id);
  CRNDelete(node);
  free(data);
  return TRUE;
}

/* NEGO_PROC_RESULTtoREPLY */
int NEGO_PROC_RESULTtoREPLY(SMessage smg)
{
  CRNode node;
  SMessage reply_smg;

  CDelete(tmps);
  node = CRSelect(EXTERNAL, NEGO_PROC,
		  CSMGetMidStr(smg), worldID, ON);
  reply_smg = MakeReplyMessage(node->smg, CSMGetDataStr(data));
  send_message(reply_smg);
  free(data);
  CRNDelete(node);
  return TRUE;
}

char *SelectInnerMethod(int mtype, char *method, char *inner_method)
{
  int i;

  for(i = 0; MethodDataList[i].mtype != -1; i++){
    if(mtype == MethodDataList[i].mtype &&
       strcmp(method, MethodDataList[i].proc) == 0) break;
  }
  if(MethodDataList[i].mtype != -1){
    strcpy(inner_method, MethodDataList[i].inner_method);
    return inner_method;
  }
  else{
    return NULL;
  }
}

int ASKBeginTransaction(SMessage smg)
{
  char *tid;
  SMessage replySmg;

  tid = new_tid;
  WItid = tid;
  replySmg = MakeReplyMessage(\"true\", smg);
  send_message(reply_Smg);
  CDelete(smg);
  return TRUE;
}

int ASKCommit(SMessage smg)
{
  if(WItid != NULL){
    free(WItid);
    WItid = NULL;
  }
  replySmg = MakeReplyMessage(\"true\", smg);
  send_message(reply_Smg);
  CDelete(smg);
  return TRUE;
}

int ASKBeginNegotiation(SMessage smg)
{
  char *tid;
  World world;

  world = SelectNP_id(CSMGetDataStr(smg));
  if(world != NO_WORLD){
    tid = strdup(CSMGetTidStr(smg));
    WIPush(world, init, tid);
    NP_ParaInit(world)();
  }
  return TRUE;
}

int (*SelectAskProc(int mtype, char *inner_method))(char*, SMessage)
{
  int i;

  for(i = 0; MethodDataList[i].event_type != -1; i++){
    if(MethodDataList[i].event_type == mtype &&
       strcmp(inner_method, MethodDataList[i].inner_method) == 0)
      return MethodDatalist[i].send_proc;
  }
  return NULL;
}

State SelectWorldInit(World world)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(world_list[i].world_id == world)
      world_list[i].init;
  }
  return NO_STATE;
}

char *CCommonToTOstring(char *org, char *to)
{
  int i;

  for(i = 0; org[i] != NULL; i++){
    if(org == \'[\' || org == \']\' || org == \'<\' || org == \'<\' ||
       org == \'(\' || org == \')\' || org == \'=\' || org == \',\'){
      to[i] = \' \';
    }
    else{
      to[i] = org[i];
    }
  }
  return to;
}
/* begin_transactin */
"};

int make_default_method_proc(void)
{
  fprintf(func_fp, default_method_proc_list);
  return TRUE;
}
