/* make_main.c
 */

#include <stdio.h>
#include <define.h>
#include <capldata.h>

extern FILE *main_fp;

static char sub_cap_interface_list[]={
"char
  *CallSubstance(char *call, char *procID)
{
  int callID;

  callID = call_%s_%s_substance(call);
  sprintf(procID, \"%%d\", callID);
  return procID;
}

"};

static char main_proc_list[] = {"
AgentInfo agentInfo;
WorldInfo worldInfo[STACK_SIZE];
int worldID;

char *LOGICAL_AGENT_NAME = \"%s\";
char *PHYSICAL_AGENT_ID = \"%s\";
char *PATH = %s;
char *SUBSTANCE_NAME = \"%s\";
int lock_swt = %d;
int
  main(int argc, char *argv)
{
  InitializeAgentProcess(argc, argv);
  AgentProcessMainLoop();
  TerminateAgentProcess();
  exit(0);
}

int InitializeAgentProcess(int argc, char *argv[])
{
  int fd;
  char *agent_name;

  if (argc != 2){
    fprintf(stderr, \"usage : %%s port-number\\n\", argv[0]);
    exit(1);
  }
    
  agent_name = rindex (argv[0], \'/\');
  if (agent_name == NULL)  agent_name = argv[0];
  else                     agent_name++;
    
  if (init_comm(atoi(argv[1]), 0) < 0) exit (1);
  init_environment(argc, argv);
  if ((fd = init_%s_%s_substance(PATH, LOGICAL_AGENT_NAME, SUBSTANCE_NAME)) < 0){
    fprintf(stderr, \"cannot connect to substance.\\n\");
    exit(1);
  }
/*  signal(SIGQUIT, agentCatchupSigQuit);*/
  AIInit(LOGICAL_AGENT_NAME, PHYSICAL_AGENT_ID, fd);

}

int TerminateAgentProcess(void){
  close_environment();
  exit_application();
  close_simple_agent();
}

int AgentProcessMainLoop()
{
  SMessage smg;
  int      event_type;
  int      event_data;

  CQNew(3);

  WIPush(NORMAL, QUERY_WAIT, (char *)NULL);

  while(agentInfo.activity == ON){
    if((smg = CQDequeue(MSGQ, CONTROL, NULL, NULL, NULL)) != NULL) {
      appHandleDebugFlag(smg);
      CSMDelete(smg);
    }
    if(SelectMessageAndProcedure() == FAIL){
      event_type = select_event(&event_data);
      switch(event_type){
      case EVENT_EXIT:
	agentInfo.activity = OFF;
	break;
      case EVENT_MESSAGE_SEND_READY:
	flush_message();
	break;
      case EVENT_MESSAGE_RECEIVE_READY:
	while(receive_message(&smg) == 0)
	  CQEnqueue(MSGQ, smg);
	break;
      case EVENT_IO_READY:
	if (event_data == agentInfo.subFd){
	  while(ReceiveFromSubstance(&smg) == 0)
	    CQEnqueue(SIQ, smg);
	}
	else{
	  fprintf(stderr, \"receive data from unkown I/O.\\n\");
	}
	break;
      }
    }
  }
  return 0;
}
/* end of main.c */
"
};

static void make_main_loop(void)
{
  fprintf(main_fp, main_proc_list,
	  agent_name, agent_id, path,
	  inside_sub, lock_swt, insides[0], connect_name);
}

void make_cap_para_init(void)
{
  int i;

  fprintf(main_fp, "int\n  AICommonParInit()\n{\n");
  fprintf(main_fp, "  char buffer[BUFSIZE];\n");
  for(i = 0; i < num_of_para; i++){
    if(para_list[i].para_init != NULL){
      fprintf(main_fp, "  agentInfo.CPAR.%s = CCommonToStruct(\"%s\");\n",
	      para_list[i].para_name, para_list[i].para_init);
    }
    else{
      fprintf(main_fp, "  agentInfo.CPAR.%s = NULL;\n",
	      para_list[i].para_name);
    }
  }
  fprintf(main_fp, "  return TRUE;\n}\n\n");
}

static void make_sub_cap_IF_for_other_process(void){
  fprintf(main_fp, sub_cap_interface_list,
	  insides[0], connect_name, insides[0], insides[0]);
}

void make_main_file(void)
{
  make_main_loop();
  if(connect_type == PIPE)
    make_sub_cap_IF_for_other_process();
  make_cap_para_init();
}

/* end of make_main.c */
