/* make_include_file.c */

#include <stdio.h>
#include <define.h>
#include <tokens.h>
#include <capldata.h>
#include <check_type.h>

extern FILE *inc_fp;
static char include_file_list[]={
"#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <comm.h>
#include <Henv.h>
#include <event.h>
#include <AgentFlags.h>
#include <SMessage.h>
#include <CommonType.h>
#include <commonConst.h>
#include <commonParse.h>
#include <libcommon.h>
#include <CAppConv.h>
#include <make_message.h>
#include <%s_%s.h>
#include <CQueue.h>
#include <CRecord.h>
#include <CaplDef.h>
"};

static char macro_operator_list[] ={"
#define WI          (worldInfo[worldID])
#define WIstate     (worldInfo[worldID].state[worldInfo[worldID].sid])
#define WIsid       (worldInfo[worldID].sid)
#define WItid       (worldInfo[worldID].tid)
#define WIworld     (worldInfo[worldID].world)
#define WIpreWorld  (worldInfo[worldID].preWorld)
#define WIlPar      (worldInfo[worldID].LPAR)
#define WIstart_msg (worldInfo[worldID].start_msg)

#define AIsubFD    (agentInfo.subFD)
#define AIname     (agentInfo.agent_name)
#define AIid       (agentInfo.agent_id)
#define AIcPar     (agentInfo.CPAR)
#define AIactvity  (agentInfo.activity)

 "};

static void make_macro_operator_list(void)
{
  fprintf(inc_fp, macro_operator_list);
}


static void make_include_list(void)
{
  fprintf(inc_fp, include_file_list, insides[0], connect_name);
}

static void make_world_list(void)
{
  int i;
  fprintf(inc_fp, "#define NO_WORLD -1\n");
  fprintf(inc_fp, "#define NORMAL    0\n");
  for(i = 0; i < num_of_np_name; i++){
    fprintf(inc_fp, "#define %s %d\n", np_name_list[i], i+1);
  }
  fprintf(inc_fp, "\n");
}

static void make_state_list(void)
{
  int i;

  fprintf(inc_fp, "#define QUERY_WAIT 0\n");
  fprintf(inc_fp, "#define REPLY_WAIT 1\n");
  fprintf(inc_fp, "#define RUNNING    2\n");
  fprintf(inc_fp, "#define RUNNING2   3\n");
  fprintf(inc_fp, "#define NP_RUNNING  4\n");
  for(i = 0; i < num_of_np_state; i++){
    fprintf(inc_fp, "#define %s %d\n", np_state[i], i+5);
  }
  fprintf(inc_fp, "\n");
}


void make_include_file(void)
{
  make_include_list();
  make_macro_operator_list();
  make_world_list();
  make_state_list();
}

