/* make_header_file.c */

#include <stdio.h>
#include <define.h>
#include <tokens.h>
#include <capldata.h>
#include <check_type.h>

extern int make_world_list(void);
extern int make_state_list(void);
extern int make_agent_info(void);
extern int make_world_info(void);
extern int make_default_method_procedure_list(void);
extern int make_nego_proc_method_procedure_list(void);
extern int make_nego_proc_init_free_list(void);

extern FILE *inc_fp;
extern FILE *def_fp;

int make_header_file(void)
{
  make_default_method_procedure_list();
  make_nego_proc_method_procedure_list();
  return 1;
}

/* $B8r>DL>!?@oN,L>$KHV9f$r$U$k(B
 * $B8r>DL>!?@oN,L>$O(B world_list[%d] $B$G$H$l$k(B
 -------------------------------------------*/
int make_world_list(void)
{
  int i;
  fprintf(def_fp, "char world_name[%d] ={\n", num_of_np_name+2);
  fprintf(def_fp, "  \"NORMAL\",\n");
  for(i = 0; i < num_of_np_name; i++){
    fprintf(def_fp, " \"%s\",\n", np_name_list[i]);
  }
  fprintf(def_fp, "};\n\n");

  return 1;
}


int make_default_method_procedure_list(void)
{
  int i;
  fprintf(inc_fp, "extern int ASKtoCALL(SMessage smg);\n");
  fprintf(inc_fp, "extern int QUERYtoASK(SMessage smg);\n");
  fprintf(inc_fp, "extern int REPLYtoRESULT(SMessage smg);\n");
  fprintf(inc_fp, "extern int RESULTtoREPLY(SMessage smg);\n");
  fprintf(inc_fp, "extern int ASKtoNP(SMessage smg);\n");
  fprintf(inc_fp, "extern int QUERYtoNP(SMessage smg);\n");
  fprintf(inc_fp, "extern int NPtoREPLY(SMessage smg);\n");
  fprintf(inc_fp, "extern int NPtoRESULT(SMessage smg);\n");
  for(i = 0; i < num_of_export; i++){
    fprintf(inc_fp, "extern int ASK_SEND_%s(char *method, char *data, SMessage smg);\n",
	    export[i].in_method);
  }

  fprintf(inc_fp, "typedef struct {\n");
  fprintf(inc_fp, "  int eventType;\n");
  fprintf(inc_fp, "  char *out_method;\n");
  fprintf(inc_fp, "  char *in_method;\n");
  fprintf(inc_fp, "  int procType;\n");
  fprintf(inc_fp, "  int procId;\n");
  fprintf(inc_fp, "  int (*methodProc)(SMessage smg);\n");
  fprintf(inc_fp, "  int (*askProc)(char *data, SMessage smg);\n");
  fprintf(inc_fp, "} MethodData;\n");

  fprintf(def_fp, "MethodData normalMethodList[]={\n");

  for(i = 0; i < num_of_import; i++){
    fprintf(def_fp, "  { IMPORT, \"%s\", \"%s\", ",
	    import[i].out_method, import[i].in_method);
    if(import[i].dist == CALL_SUB)
      fprintf(def_fp, "CALL_SUB, NORMAL, ASKtoCALL, NULL },\n");
    else if(import[i].dist == CALL_PROC)
      fprintf(def_fp, "CALL_PROC, %s, ASKtoNP, NULL },\n", import[i].np_name);
    else if(import[i].dist == CALL_NEGO)
      fprintf(def_fp, "CALL_NEGO, %s, ASKtoNP, NULL },\n", import[i].np_name);
  }
  for(i = 0; i < num_of_export; i++){
    fprintf(def_fp, "  { EXPORT, \"%s\", \"%s\", ",
	    export[i].out_method, export[i].in_method);
    fprintf(def_fp, "EX_ASK, NORMAL, REPLYtoRESULT, NULL },\n");
  }
  for(i = 0; i < num_of_query; i++){
    fprintf(def_fp, "  { QUERY, \"%s\", \"%s\", ",
	    query[i].out_method, query[i].in_method);
    if(query[i].dist == EX_ASK)
      fprintf(def_fp, "EX_ASK, NORMAL, QUERYtoASK, ASK_SEND_%s },\n", query[i].in_method);
    else if(query[i].dist == CALL_PROC)
      fprintf(def_fp, "CALL_PROC, %s, QUERYtoNP, NULL },\n", query[i].np_name);
    else if(query[i].dist == CALL_NEGO)
      fprintf(def_fp, "CALL_NEGO, %s, ASKtoNP, NULL },\n", query[i].np_name);
  }
  for(i = 0; i < num_of_call; i++){
    fprintf(def_fp, " { CALL, \"%s\", \"%s\",", call[i].out_method, call[i].in_method);
    fprintf(def_fp, "EX_REPLY, NORMAL, RESULTtoREPLY, NULL },\n");
  }
  fprintf(def_fp, "  { -1, NULL, NULL, -1, -1, NULL, NULL }\n");
  fprintf(def_fp, "};\n");

  return 1;
}

int make_nego_proc_method_procedure_list(void)
{
  fprintf(inc_fp, "typedef struct {\n");
  fprintf(inc_fp, "  int  npType\n");
  fprintf(inc_fp, "  int  world;\n");
  fprintf(inc_fp, "  int  state;\n");
  fprintf(inc_fp, "  int  eventType\n");
  fprintf(inc_fp, "  char *method\n");
  fprintf(inc_fp, "  int  (*methodProc)(SMessage smg);\n");
  fprintf(inc_fp, "} NPMethodData;\n");

  return 1;
}

int make_nego_proc_init_free_list(void)
{
  int i;
  for(i = 0; i < num_of_np_name; i++){
    fprintf(inc_fp, "extern int ParaInit_%s(void);\n", np_name_list[i]);
    fprintf(inc_fp, "extern int ParaFree_%s(void);\n", np_name_list[i]);
  }

  fprintf(inc_fp, "typedef struct {\n");
  fprintf(inc_fp, "  int  np_id;\n");
  fprintf(inc_fp, "  int  (*initFunc)(void);\n");
  fprintf(inc_fp, "  int  (*freeFunc)(void);\n");
  fprintf(inc_fp, "} NPInitFreeList;\n");

  fprintf(def_fp, "NPInitFreeList npInitFreeList[] =\n");
  for(i = 0; i < num_of_np_name; i++){
    fprintf(def_fp, "  { %s, ParaInit_%s, ParaFree_%s },\n",
	    np_name_list[i], np_name_list[i], np_name_list[i]);
  }
  fprintf(def_fp, "  { -1, NULL, NULL },\n");
  fprintf(def_fp, "}\n");


  return 1;
}
/* end of make_header_file.c */
