/* make_func.c
 */

#include <stdio.h>
#include <define.h>
#include <capldata.h>
#include <tokens.h>

extern FILE *func_fp;

static char ask_to_nego_proc[] = {"
int ASKto_%s(SMessage smg)
{
  char *tid;
  SMessage new_smg;
  int world;
  int init;
  char world_name[BUFSIZE];

  new_smg = CSMDuplicate(smg);
  tid = new_tid();
  CSMPutTidStr(tid, new_smg);
  CQEnqueue(MSGQ, new_smg);
  CREnqueue(smg, EXTERNAL, PROCEDURE, \"%s\", worldID, ON);
  WIPush(%s, %s_init, tid);
  NP_ParaInit(%s)();
  return TRUE;
}

"};

static char nego_proc_to_reply[]={"
int %s_toREPLY(SMessage smg)
{
  CRNode node;
  SMessage reply_smg;

  CDelete(tmps);
  node = CRSelect(NULL, CSMGetMethodStr(smg), EXTERNAL, NEGO_PROC,
		  \"%s\", worldID, ON);
  reply_smg = MakeReplyMessage(node->smg, CSMGetDataStr(data));
  send_message(reply_smg);
  free(data);
  CRNDelete(node);
  return TRUE;
}

"};

static char query_to_nego_proc[]={"
int QUERYto_%s(SMessage smg)
{
  CDATA tmps;
  char data[BUFSIZE];
  char *tid;
  SMessage new_smg;
  int world;
  char world_name[BUFSIZE];

  tmps = CAPSubstanceConLocalCommon(\"%s\", CSMGetDataStr(smg));
  if(tmps != NULL){
    data = CStructToCommon(tmps, data);
    tid = new_tid();
    new_smg = CSMDuplicate(smg);
    CSMPutMethodStr(inner_method, new_smg);
    CSMPutDataStr(data, new_smg);
    CSMPutTidStr(tid, new_smg);
    CQEnqueue(SIQ, new_smg);
    CREnqueue(smg, SUBSTANCE, NEGO_PROC, \"%s\", worldID, Off);
    WIPush(%s, %s_init, tid);
    NP_ParaInit(%s)();
  }
  else{
    fprintf(stderr, \"illegal data of method.\\n\");
    agentInfo.activity == EXIT;
  }
  return TRUE;
}

"};

static char nego_proc_to_result[] ={"
int %s_toRESULT(SMessage smg)
{
  CDATA tmps;
  char *data;
  CRNode node;

  tmps = CCommonToStruct(CSMGetDataStr(smg));
  data = CAPSubstanceConvCommonLocal(CSMGetMethodStr(smg), tmps);
  CDelete(tmps);
  node = CRSelect(NULL, CSMGetMethodStr(smg), SUBSTANCE, NEGO_PROC,
		  \"%s\", worldID, ON);
  PutResultToSubstance(data, node->query_id);
  CRNDelete(node);
  free(data);
  return TRUE;
}


"};

static char agent_info_funcs[] ={"
int
  AIInit(char *agentName, char *agentID, int fd)
{
  agentInfo.subFd = fd;
  agentInfo.activity = ON;
  if(agentName != (char *)NULL)
    strcpy(agentInfo.agentName, agentName);
  if(agentID != (char *)NULL)
    strcpy(agentInfo.agentID, agentID);
  AICommonParInit();
  return TRUE;
}

void
  appHandleDebugFlag(SMessage smg)
{
  char		*method;

  if ((method = CSMGetMethodStr(smg)) != NULL) {
    if (!strcmp(method, \"trace_on\")) {
      CDebugFlagWrite(agentInfo.agentID, CSMGetFromAidStr(smg));
    } else if (!strcmp(method, \"trace_off\")) {
      CDebugFlagWrite(agentInfo.agentID, NULL);
    }
  }
}

int SelectWorldInit(int world)
{
  int i;

  for(i = 0; world_list[i].world_name != NULL; i++){
    if(world_list[i].world_id == world)
      world_list[i].init;
  }
  return NO_STATE;
}
"};

static char cap_sub_interface_proc_list[] = {"
char
  *CallSubstance(char *call, char *procID)
{
  int callID;

  callID = call_%s_%s_substance(call);
  sprintf(procID, \"%%d\", callID);
  return procID;
}

int
  PutResultToSubstance(char *procID, char *result)
{
  put_result_to_%s_%s_substance(result);
  return 0;
}

int
  ReceiveFromSubstance(SMessage smg)
{
  SMessage smg;
  char data[BUFSIZE], id[10];
  int  event;
  int  i;

  switch(event = getdata_%s_%s_substance(data, id)){
  case REQUEST:
    CRSetSubstanceReqFlagOn(record, data);
    if(WIstate == RUNNING){
      WIPushState(REPLY_WAIT);
    }
    else if(WIstate == RUNNING2){
      WIChangeState(REPLY_WAIT);
    }
    else {
      fprintf(stderr, \"illegal result request from substance\");
      return event;
    }
    CRSetSubstanceReqFlagOn(record, data);
    smg = NULL;
    return event;
  case RESULT:
    smg = CSMInit();
    i = SelectConvLocalToCommon(SUBSTANCE_CALL, data);
    CSMTypeReply(smg);
    CSMPutMethodStr(smg, methodConvTable[i].commonMethod);
    CSMPutDataStr(smg, data);
    CSMPutMidStr(smg, id);
    CQEnqueue(SIQ, smg);
    return event;
  case QUERY:
    smg = CSMInit();
    i = SelectConvLocalToCommon(SUBSTANCE_QUERY, data);
    CSMTypeAsk(smg);
    CSMPutMethodStr(smg, methodConvTable[i].commonMethod);
    CSMPutDataStr(smg, data);
    CSMPutMidStr(smg, id);
    CQEnqueue(SIQ, smg);
    return event;
  case NO_DATA:
    smg = NULL;
    return event;
  default:
    fprintf(stderr, \"capsule gets illegal data from substance\\n\");
    return NO_DATA;
  }
}

int
  PutResultToSubstance(char *procID, char *result)
{
  put_result_to_%s_%s_substance(result);
  return 0;
}

int
  ReceiveFromSubstance(SMessage *smg)
{
  char data[BUFSIZE], id[10];
  char sub_proc[BUFSIZE];
  char method[BUFSIZE];
  int  event;
  int  i;

  switch(event = getdata_from_%s_%s_substance(sub_proc, data, id)){
  case REQUEST:
    CRSetSubstanceReqFlagOn(id);
    if(WIstate == RUNNING){
      WIPushState(REPLY_WAIT);
    }
    else if(WIstate == RUNNING2){
      WIChangeState(REPLY_WAIT);
    }
    else {
      fprintf(stderr, \"illegal result request from substance\");
      return event;
    }
    *smg = NULL;
    return event;
  case RESULT:
    SelectInnerMethod(CALL, sub_proc, method);
    CSMTypeReply(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case QUERY:
    SelectInnerMethod(QUERY, sub_proc, method);
    CSMTypeAsk(*smg);
    CSMPutMethodStr(*smg, method);
    CSMPutDataStr(*smg, data);
    CSMPutMidStr(*smg, id);
    return event;
  case NO_DATA:
    *smg = NULL;
    return event;
  default:
    fprintf(stderr, \"capsule gets illegal data from substance\\n\");
    return NO_DATA;
  }
}
"};

void make_nego_proc_method_procedure(void)
{
  int i;
  for(i = 0; i < num_of_import; i++){
    if(import[i].dist == CALL_NEGO || import[i].dist == CALL_PROC){
      fprintf(func_fp, ask_to_nego_proc,
	      import[i].np_name, import[i].np_name,
	      import[i].np_name, import[i].np_name, import[i].np_name);
      fprintf(func_fp, nego_proc_to_reply,
	      import[i].np_name, import[i].np_name);
    }
  }
  for(i = 0; i < num_of_query; i++){
    if(query[i].dist == CALL_NEGO || query[i].dist == CALL_PROC){
      fprintf(func_fp, query_to_nego_proc,
	      query[i].np_name, query[i].in_method, query[i].np_name,
	      query[i].np_name, query[i].np_name, query[i].np_name);
      fprintf(func_fp, nego_proc_to_result,
	      query[i].np_name, query[i].np_name);
    }
  }

  fprintf(func_fp, agent_info_funcs);
  fprintf(func_fp, cap_sub_interface_proc_list,
	  insides[0], connect_name, insides[0], connect_name,
	  insides[0], connect_name, insides[0], connect_name,
	  insides[0], connect_name);
}

/* end of make_func.c */
