/* make_extern_def_file.c */
/* make_def_file.c */

#include <stdio.h>
#include <define.h>
#include <tokens.h>
#include <capldata.h>
#include <check_type.h>

extern FILE *ext_fp;

static void make_default_method_procedure_list(void)
{
  int i;
  fprintf(ext_fp, "extern int ASKtoCALL(SMessage smg);\n");
  fprintf(ext_fp, "extern int QUERYtoASK(SMessage smg);\n");
  fprintf(ext_fp, "extern int REPLYtoRESULT(SMessage smg);\n");
  fprintf(ext_fp, "extern int RESULTtoREPLY(SMessage smg);\n");
  for(i = 0; i < num_of_import; i++){
    if(import[i].dist == CALL_NEGO || import[i].dist == CALL_PROC){
      fprintf(ext_fp, "extern int ASKto_%s(SMessage smg);\n", import[i].np_name);
      fprintf(ext_fp, "extern int %s_toREPLY(SMessage smg);\n", import[i].np_name);
    }
  }
  for(i = 0; i < num_of_query; i++){
    if(import[i].dist == CALL_NEGO || import[i].dist == CALL_PROC){
      fprintf(ext_fp, "extern int QUERYto_%s(SMessage smg);\n", query[i].np_name);
      fprintf(ext_fp, "extern int %s_toRESULT(SMessage smg);\n", query[i].np_name);
    }
  }

  for(i = 0; i < num_of_export; i++){
    fprintf(ext_fp,
	    "extern int ASK_SEND_%s(char *method, char *data, SMessage smg);\n",
	    export[i].in_method);
  }
  fprintf(ext_fp, "\n");
}
static void make_nego_proc_method_proc_list(void)
{
  int i;
  for(i = 0; i < num_of_proc_event; i++){
    fprintf(ext_fp, "extern int %s(SMessage smg);\n",
	    proc_event_list[i].func_name);
  }
  for(i = 0; i < num_of_nego_event; i++){
    fprintf(ext_fp, "extern int %s(SMessage smg);\n",
	    nego_event_list[i].func_name);
  }
  fprintf(ext_fp, "\n");
}

static void make_nego_proc_init_free_list(void)
{
  int i;
  for(i = 0; i < num_of_np_name; i++){
    fprintf(ext_fp, "extern int ParaInit_%s(void);\n", np_name_list[i]);
    fprintf(ext_fp, "extern int ParaFree_%s(void);\n", np_name_list[i]);
  }
  fprintf(ext_fp, "\n");
}

void make_extern_def_file(void)
{
  fprintf(ext_fp, "extern NPMethodData NPMethodList[];\n");
  fprintf(ext_fp, "extern AskProc askProc[];\n");
  fprintf(ext_fp, "extern NPInitFreeList npInitFreeList[];\n");

  fprintf(ext_fp, "extern AgentInfo agentInfo;\n");
  fprintf(ext_fp, "extern WorldInfo worldInfo[];\n");
  fprintf(ext_fp, "extern int worldID;\n");

  make_default_method_procedure_list();
  make_nego_proc_method_proc_list();
  make_nego_proc_init_free_list();
}

/* end of make_extern_def_file.c */
