/* make_def_file.c */

#include <stdio.h>
#include <define.h>
#include <tokens.h>
#include <capldata.h>
#include <check_type.h>

extern FILE *def_fp;


static char ask_proc_list[]={"
typedef struct {
  char *method;
  int  (*askProc)(char *data, SMessage smg);
} AskProc;

"};

static char nego_proc_method_type_def_list[] ={"
typedef struct {
  int  npType;   /* ASK | QUERY */
  int  world;    /* <negotiation strategy> | <capsule procedure> */
  int  state;    /* <state> */
  int  qType;    /* MSGQ | SIQ | NPQ */
  char *method;
  int  (*methodProc)(SMessage smg);
} NPMethodData;

"};

static char np_init_free_type_def_list[]={"
typedef struct {
  int  world;     /* <negotiation strategy> | <capsule procedure> */
  int  (*initFunc)(void);
  int  (*freeFunc)(void);
} NPInitFreeList;

"};

static void make_agent_info(void)
{
  int i;
  int type;
  fprintf(def_fp, "typedef struct {\n");
  fprintf(def_fp, "  int  activity;\n");
  fprintf(def_fp, "  int  subFd;\n");
  fprintf(def_fp, "  char *agent_name;\n");
  fprintf(def_fp, "  char *agent_id;\n");
  fprintf(def_fp, "  struct {\n");
  for(i = 0; i < num_of_para; i++){
    fprintf(def_fp, "    CDATA %s;\n",para_list[i].para_name);
    if((type = check_common_type_type(para_list[i].para_type)) == INT_TYPE){
      fprintf(def_fp, "    int int_%s;\n", para_list[i].para_name);
    }
    else if(type == BOOL_TYPE){
      fprintf(def_fp, "    int bool_%s;\n", para_list[i].para_name);
    }
    else if(type == STR_TYPE){
      fprintf(def_fp, "    char *str_%s;\n", para_list[i].para_name);
    }
    else if(type == LIST_TYPE){
      fprintf(def_fp, "    char list_%s[BUFSIZE];\n", para_list[i].para_name);
    }
    else if(type == VEC_TYPE){
      fprintf(def_fp, "    char vec_%s[BUFSIZE];\n", para_list[i].para_name);
    }
    else if(type == TUPLE_TYPE){
      fprintf(def_fp, "    char tuple_%s[BUFSIZE];\n", para_list[i].para_name);
    }
  }
  fprintf(def_fp, "  } CPAR;\n");
  fprintf(def_fp, "} AgentInfo;\n\n");
}

static void make_world_info(void)
{
  int i;

  fprintf(def_fp, "typedef struct{\n");
  for(i = 0; i < num_of_np_name; i++){
    fprintf(def_fp, "  %sPar %s_par;\n", np_name_list[i], np_name_list[i]);
  }
  fprintf(def_fp, "} LocalPar;\n");

  fprintf(def_fp, "typedef struct{\n");
  fprintf(def_fp, "  int wtype;\n");
  fprintf(def_fp, "  int world;\n");
  fprintf(def_fp, "  int sid;");
  fprintf(def_fp, "  int state[%d];\n", STACK_SIZE);
  fprintf(def_fp, "  char *tid;\n");
  fprintf(def_fp, "  LocalPar LPAR;\n");
  fprintf(def_fp, "  SMessage start_msg;\n");
  fprintf(def_fp, "} WorldInfo;\n\n");
}

static void make_ask_proc_list_type(void)
{
  fprintf(def_fp, ask_proc_list);
}

/*
static void make_method_list_type(void)
{
  fprintf(def_fp, method_data_type_def_list);
  fprintf(def_fp, method_proc_list);
}
*/
static void make_method_proc_list_type(void)
{
  fprintf(def_fp, nego_proc_method_type_def_list);
}

static void make_init_free_proc_type(void)
{
  fprintf(def_fp, np_init_free_type_def_list);
}

void make_type_def_file(void)
{
  make_world_info();
  make_agent_info();
/*  make_method_list_type(); */
/*  make_method_select_list_type();*/
#if 0
  make_method_proc_list_type();
  make_ask_proc_list_type();
  make_init_free_proc_type();
#endif
}

/* end make_def_file.c */
