/*
 */

#define __main__

#include <stdio.h>
#include <string.h>
#include <define.h>
#include <capldata.h>
#include <file.h>
#include <generator.h>
#include <check_type.h>
FILE *cpl_fp;  /* file point of CAPL file */

char *inc_file = "#inc.h";
FILE *inc_fp;
char *ext_file = "#ext.h";
FILE *ext_fp;
char *def_file = "#def.h";
FILE *def_fp;
char *table_file = "#table.c";
FILE *table_fp;
char *main_file = "#main.c";
FILE *main_fp;
char *func_file = "#func.c";
FILE *func_fp;
char *conv_file = "#conv.dat";
FILE *conv_fp; 
char *select_file = "#select.c";
FILE *select_fp;

FILE *tbl_fp;  /* agentTable.c */

extern int info_parser(void);
extern int act_parser(void);
extern int get_agent_process_info(void);

extern void make_main_file(void);
extern void make_include_file(void);
extern void make_type_def_file(void);
extern void make_extern_def_file(void);
void make_nego_proc_method_procedure(void);

int main(int argc, char *argv[])
{
  int result;

  /* $B=i4|2=(B */
  if(argc != 2 && argc != 3){
    fprintf(stderr, "usage : clc <capl file> [<application name>].\n");
    exit(1);
  }

  /* capl $B%U%!%$%k$r3+$/(B */
  if((cpl_fp = open_capl_file(argv[1], argv[2])) == NULL){
    fprintf(stderr, "fail in opening capl file %s\n", argv[1]);
    exit(1);
  }
  fprintf(stderr, "open capl file %s.\n", argv[1]);


  if((def_fp = fopen(def_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", def_file);
    exit(1);
  }
  if((ext_fp = fopen(ext_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", ext_file);
    exit(1);
  }
  if((inc_fp = fopen(inc_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", inc_file);
    exit(1);
  }

  if((main_fp = fopen(main_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", main_file);
    exit(1);
  }
  if((func_fp = fopen(func_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", func_file);
    exit(1);
  }
  if((conv_fp = fopen(conv_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", conv_file);
    exit(1);
  }
  if((table_fp = fopen(table_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", table_file);
    exit(1);
  }
  if((select_fp = fopen(select_file, "w")) == NULL){
    fprintf(stderr, "fail in opening %s.\n", select_file);
    exit(1);
  }

  /* $B%X%C%@$NItJ,$N=q$-9~$_(B */
  /* capl $B%U%!%$%k$rFI$_9~$`(B */
  result = TRUE;
  result = info_parser();
  result = make_common_type_table(argv[2]);
  if(agent_type == SIMPLE) fprintf(conv_fp, "simple\n");
  else                     fprintf(conv_fp, "complex\n");
  fprintf(conv_fp, "%s\n", agent_name);
  fprintf(conv_fp, "%s\n", agent_id);
  fprintf(conv_fp, "%s\n", sub_type);

  num_of_np_state = 0;
  result = act_parser();
  if(agent_type == SIMPLE){
/* new */
    make_include_file();
    make_type_def_file();
    make_extern_def_file();
    make_method_table();
    make_main_file();
    make_nego_proc_method_procedure();
  }

#ifndef HDINFO_TEST
  result = get_agent_process_info();
#else
  ap_name[0] = strdup("meeting1");
  ap_name[1] = strdup("meeting2");
  ap_name[2] = strdup("meeting3");
  ap_name[3] = NULL;
#endif HDINFO_TEST
  /* helios.hia, capl$B%U%!%$%k(B, $B@8@.$7$?%U%!%$%k$rJD$8$k(B */
  fclose(cpl_fp);

  fclose(inc_fp);
  fclose(ext_fp);
  fclose(def_fp);
  fclose(main_fp);
  fclose(func_fp);
  fclose(conv_fp);
  fclose(table_fp);
  fclose(select_fp);

  if(result == TRUE){
    /* tbl $B%U%!%$%k$N=PNO(B */
    generate_tbl_file(argv[2]);

    /* $B@8@.$7$?%U%!%$%k$r3F!9$N%G%#%l%/%H%j$K%3%T!<$9$k(B */
    copy_temp_files_to_cmd_directories(argv[2]);

    /* $B@8@.$7$?%U%!%$%k$r>C5n$9$k(B */
#if 0
    unlink(main_file);
    unlink(func_file);
    unlink(conv_file);
    unlink(table_file);
    unlink(select_file);
#endif
  }
  /* $B=*N;=hM}(B */
  return 0;
}
