/* lex.c
 *        $B3F;z6g2r@OIt$,6&DL$KMxMQ$9$k4X?t$rDj5A$9$k(B
 *        
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <capldata.h>
#include <define.h>
#include <tokens.h>
#include <lex.h>

int ungetchar;
int ungettoken;
int lineno = 1;

word keyword_list[] = {
/* top level keyword */
  { "type",                 AGENT_TYPE },
  { "agent",                AGENT_NAME },
  { "parameter",            PARA_DEF },
  { "inside",               INSIDE },
  { "substance_type",       SUBSTANCE_TYPE },
  { "connect",              CONNECT },
  { "lock",                 LOCK },
  { "transaction",          TRANSACTION },
  { "import_method",        IMPORT_METHOD },
  { "export_method",        EXPORT_METHOD },
  { "substance_query",      SUBSTANCE_QUERY },
  { "substance_call",       SUBSTANCE_CALL },
  { "negotiation_strategy", NEGOTIATION_STRATEGY },
  { "capsule_procedure",    CAPSULE_PROCEDURE },
  { "self_model",           SELF_MODEL },
  { "conv",                 CONV_DEF },
  { "environment",          ENVIRONMENT },
/* for inside */
  { "sub",                  INSIDE_SUB },
  { "lib",                  LIBRARY },
/* for export method, substance query */
  { "negotiation",          CALL_NEGO },
  { "procedure",            CALL_PROC },
/* for negotiation, procedure */
  { "state",                STATE_DEF },
  { "var",                  VAR_DEF },
  { "from",                 FROM },
  { "external",             EXTERNAL },
  { "external_ask",         EXTERNAL_ASK },
  { "external_reply",       EXTERNAL_REPLY },
  { "substance",            SUBSTANCE },
  { "capsule",              CAPSULE },
  { "next",                 NEXT_ST },
  { "return",               RETURN },
  { "negotiation_result",   NEGO_RESULT },
  { "procedure_result",     PROC_RESULT },
  { "external_error",       EXTERNAL_ERROR },
/* for self model */
  { "comment",              COMMENT },
/* for environment */
  { "user",                 USER },
/* end of keyword list */
  { (char *)NULL,           0 },
};

/* $BJ8;z$rFI$_9~$`(B */
int clcgetc(void)
{
  int c;
  if(ungetchar){
    c = ungetchar;
    ungetchar = 0;
    return c;
  } else {
    return fgetc(cpl_fp);
  }
}

/* $BFI$_9~$s$@J8;z$rB`Hr$9$k(B */
int clcungetc(int c)
{
  ungetchar=c;
  return ungetchar;
}

/* $BFI$_9~$s$@C18l$rB`Hr$9$k(B */
int clcunlex(int token)
{
  ungettoken = token;
  return ungettoken;
}

void clc_get_string(int top)
{
  int i;
  int c;

  i = 0;
  if(top != '\0') clcword[i++] = top;
  while(1){
    c = clcgetc();
    if(!isalpha(c) && !isdigit(c) && c != '_') break;
    clcword[i++] = c;
  }
  clcungetc(c);
  clcword[i] = '\0';
}

void clc_get_qstring(void)
{
  int i;
  int c;

  i = 0;
  clcword[i++] = '\\';
  clcword[i++] = '"';
  while(1){
    c = clcgetc();
    if(c == '"'){
      clcword[i++] = '\\';
      clcword[i++] = '"';
      break;
    }
    else{
      clcword[i++] = c;
    }
  }
  clcword[i] = '\0';
}

void clc_get_number(int top)
{
  int i;
  int c;

  i = 0;
  if(top != '\0') clcword[i++] = top;
  while(1){
    c = clcgetc();
    if(!isdigit(c)) break;
    clcword[i++] = c;
  }
  clcungetc(c);
  clcword[i] = '\0';
}

int check_keyword_id(word word_list[])
{
  int i;
  i = 0;

  for(i = 0; word_list[i].word != NULL; i++){
    if(strcmp(word_list[i].word, clcword) == 0) break;
  }
  if(word_list[i].word != NULL){
    return word_list[i].token;
  }
  else{
    return 0;
  }
}

int check_list(char *word, char *word_list[])
{
  int i;

  for(i = 0; i < LIST_MAX && word_list[i] != NULL; i++){
    if(strcmp(word_list[i], word) == 0) return i;
  }
  return -1;
}

/* end of lex.c */
