/* inside_parser.c
 *        $B%(!<%8%'%s%H$NCf?H$NDj5A$N%Q!<%5!<(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <tokens.h>

extern int inside_lex(void);

int inside_parser(void)
{
  int token;
  int result;
  int loop;
  int i;
  char *ptr, *tmp;
  char buffer[BUFSIZE];

  result = TRUE;
  for(i = 0; i < ARG_MAX; i++) insides[i] = NULL;
  for(i = 0; i < LIB_MAX; i++) lib[i] = NULL;
  inside_sub = NULL;

  for(i = 0; i < ARG_MAX; i++){
    if((token = inside_lex()) != STRING) break;
    insides[i] = strdup(clcword);
  }
  ptr = strrchr(insides[0], '/');
  if(ptr != 0){
    *tmp = insides[0];
    *ptr++ = NULL;
    sprintf(buffer, "\"%s\"", insides[0]);
    insides[0] = strdup(ptr);
    free(tmp);
  }
  else{
    sprintf(buffer, "NULL");
  }
  path = strdup(buffer);
  if(i == ARG_MAX){
    warning("inside definition is overflow");
    fprintf(stderr, "(token, i) = (%d, %d)\n", token, i);
    result = FAIL;
  }
  else{
    clcunlex(token);
  }

  for(loop = TRUE; loop == TRUE; ){
    switch(token = inside_lex()){
    case INSIDE_SUB:
      if((token = inside_lex()) == STRING) inside_sub = strdup(clcword);
      else{
	warning("illegal inside definition");
	clcunlex(token);
	result = FAIL;
      }
      break;
    case LIBRARY:
      for(i = 0; i < LIB_MAX; i++){
	if((token = inside_lex()) != STRING) break;
	lib[i] = strdup(clcword);
      }
      if(i == LIB_MAX){
	warning("overflow of UNIX libaray table");
	result = FAIL;
      }
      else{
	clcunlex(token);
      }
      break;
    case ';':
      loop = FAIL;
      break;
    default:
      warning("illegal definision of inside");
      result = FAIL;
      break;
    }
  }
#ifdef DEBUG
  for(i = 0; insides[i] != NULL; i++)
    fprintf(stderr, "insides[%d] = %s\n", i, insides[i]);
  if(inside_sub != NULL)
    fprintf(stderr, "inside sub = %s\n", inside_sub);
  for(i = 0; lib[i] != NULL; i++)
    fprintf(stderr, "lib[%d] = %s\n", i, lib[i]);
#endif
  return result;
}

/* end of inside_parser.c */
