/* inside_lex.c
 *        $B%(!<%8%'%s%H$NCf?H$NDj5AMQ$N;z6g2r@OIt(B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <warn.h>
#include <lex.h>
#include <tokens.h>

int inside_lex(void)
{
  int token;
  unsigned int c;
  int i;
  if(ungettoken != 0){
    token = ungettoken;
    ungettoken = 0;
    return token;
  }

  memset(clcword, '\0', BUFSIZE);
  while((c = clcgetc()) != EOF){
  loop:
    if(c == '%'){ /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while((c = clcgetc()) == '\n');
      lineno += 1;
      continue;
    }
    else if(c == ' ' || c == '\t') continue;
    else if(c == '\n'){
      lineno += 1;
      continue;
    }
    else if(c == '&'){
      clc_get_string('\0');
      return check_keyword_id(keyword_list);
    }
    else if(c == ';') return c;
    else if(0 < c && c < 256){
      i = 0;
      clcword[i++] = c;
      while(1){
	c = clcgetc();
	if(c == 0 || 256 <= c || c == '%' ||
	   c == ' ' || c == '\n' || c == '\t' || c == ';'){
	  clcword[i] = '\0';
	  clcungetc(c);
	  return STRING;
	}
	else if(c == EOF){
	  return c;
	}
	clcword[i++] = c;
      }
    }
    else if(c == '&'){
      clc_get_string('\0');
      return check_keyword_id(keyword_list);
    }
  }
  return c;
}

/* end of inside_lex.c */
