/* info_parser.c
 *     $B4X?t(B main() $B$,8F$S=P$9%H%C%W%l%Y%k$N(B parser
 *     $B%(!<%8%'%s%H$N>pJs$@$1$r<h$j=P$9!#(B
 *
 */

#include <stdio.h>
#include <define.h>
#include <warn.h>
#include <parsers.h>
#include <tokens.h>
#include <lex.h>

char clcword[BUFSIZE];
extern int method_lex(void);

int info_parser()
{
  int token;
  int result;

  rewind(cpl_fp); /* $B%U%!%$%k%]%$%s%?$r@hF,$K;}$C$F$$$/(B */
  result = TRUE;
  while((token = method_lex()) != EOF){
    switch(token){
    case AGENT_TYPE:
      fprintf(stderr, "enter a parser for agent type.\n");
      result = type_parser();
      break;
    case AGENT_NAME:
      fprintf(stderr, "enter a parser for agent name.\n");
      result = name_parser();
      break;
    case INSIDE:
      fprintf(stderr, "enter a parser for inside.\n");
      result = inside_parser();
      break;
    case SUBSTANCE_TYPE:
      fprintf(stderr, "enter a parser for substance type.\n");
      result = sub_type_parser();
      break;
    case ENVIRONMENT:
      fprintf(stderr, "enter a parser for environment.\n");
      result = env_parser();
      break;
    case CONNECT:
      fprintf(stderr, "enter a parser for connect.\n");
      result = connect_parser();
      break;
    case LOCK:
      fprintf(stderr, "enter a parser for lock.\n");
      result = lock_parser();
      break;
    case TRANSACTION:
      fprintf(stderr, "enter a parser for transaction.\n");
      result = trans_parser();
      break;
    case SELF_MODEL:
      fprintf(stderr, "enter a parser for self model.\n");
      result = self_model_parser();
      break;
    }
  }
  return result;
}

/* end of info_parser.c */
