/* import_parser.c
 *        $BM"F~%a%=%C%IDj5AMQ$N%Q!<%5!<(B
 *        $BM"F~%a%=%C%I$NDj5A$+$i$O0J2<$K<($9%3!<%I$r@8@.$9$k(B
 *          $B!&%a%=%C%I(B-$B%a%=%C%IBP1~I=(B
 *                $BJQ494X?tL>$O@8@.$9$k(B
 *          $B!&%a%=%C%I(B-$B=hM}BP1~I=(B
 *                $B=hM}4X?t$O%G%U%)%k%H(B or $B@8@.(B
 *                AskTo...
 *          $B!&>uBV(B-$B%a%=%C%IBP1~I=(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);
extern FILE *conv_fp;
extern FILE *table_fp;

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    CLCLEX(token, FAIL);
  return TRUE;
}

int import_parser(void)
{
  int token;
  int result;
  int each_result;
  int i;
  char buffer[BUFSIZE], *ptr;
  
  result = TRUE;
  each_result = TRUE;
  num_of_import = -1;
  while(1){
    if(each_result == TRUE){
      num_of_import += 1;
      if(num_of_import == TABLE_MAX){
	warning("overflow of import method table");
	result = FAIL;
	break;
      }
    }
    else{
      result = FAIL;
    }
    each_result = TRUE;
    
    /* $B%a%C%;!<%8$G<u$1<h$k%a%=%C%IL>$N3MF@(B */
    CLCLEX(token, result);
    if(token == STRING){
      import[num_of_import].out_method = strdup(clcword);
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      break;
    }
    else{
      warning("illegal import method definition");
      skip_end_of_def();
      each_result = FAIL;
      continue;
    }
    CLCLEX(token, FAIL);
    if(token == '@'){
      ptr = buffer;
      memset(buffer, '\0', BUFSIZE);
      while((token = method_lex()) != METHOD_SEP){
	if(token == EOF){
	  return FAIL;
	}
	else if(token == VARIABLE){
	  sprintf(ptr, "#%s", clcword);
	}
	else if(token == STRING || token == NUMBER){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	else{
	  warning("illegal signature description");
	}
	ptr = strchr(ptr, '\0');
      }
      import[num_of_import].out_sig = strdup(buffer);
    }
    else{
      skip_end_of_def();
      each_result = FAIL;
      continue;
    }
    
    CLCLEX(token, FAIL);
    if(token_is_keyword(token) == TRUE){
      clcunlex(token);
    }
    else if(token != '!'){
      clcunlex(token);
      memset(buffer, '\0', BUFSIZE);
      ptr = buffer;
      import[num_of_import].to = NULL;
      import[num_of_import].manage = NULL;
      while(1){
	CLCLEX(token, FAIL);
	if(token == STRING){
	  sprintf(ptr, "%s ", clcword);
	}
	else if(token == VARIABLE || token == PARAMETER){
	  warning("I cannot understande parameter a in method signatue");
	  result = FAIL;
	}
	else if(token == ','){
	  if(buffer != ptr) *(ptr-1) = '\0';
	  if(buffer[0] != '\0')
	    import[num_of_import].to = strdup(buffer);
	  CLCLEX(token, FAIL);
	  if(token == STRING){
	    import[num_of_import].manage = strdup(clcword);
	  }
	  else{
	    warning("illegal destination management name");
	    each_result = FAIL;
	  }
	  CLCLEX(token, FAIL);
	  if(token != '!'){
	    warning("illegal destination description");
	    each_result = FAIL;
	  }
	  break;
	}
	else if(token == '!'){
	  if(buffer != ptr) *(ptr-1) = '\0';
	  if(buffer[0] != '\0')
	    import[num_of_import].to = strdup(buffer);
	  break;
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c ", (char)token);
	}
	ptr = strchr(ptr, '\0');
      }
    }
    
    /* $BCf4V%a%=%C%IL>(B or &negotiation or &procedure $B$N3MF@(B */
    CLCLEX(token, FAIL);
    if(token == STRING){
      import[num_of_import].in_method = strdup(clcword);
      import[num_of_import].dist = CALL_SUB;
      if((token = method_lex()) == EOF){
	return FAIL;
      }
      else if(token == '@'){
	ptr = buffer;
	memset(buffer, '\0', BUFSIZE);
	while((token = method_lex()) != ';'){
	  if(token == EOF){
	    return FAIL;
	  }
	  else if(token == VARIABLE){
	    sprintf(ptr, "#%s", clcword);
	  }
	  else if(token == STRING || token == NUMBER){
	    sprintf(ptr, "%s", clcword);
	  }
	  else if(token == SIG_SEP){
	    sprintf(ptr, "->");
	  }
	  else if(clcword[0] == '\0'){
	    sprintf(ptr, "%c", (char)token);
	  }
	  else{
	    warning("illegal signature description");
	  }
	  ptr = strchr(ptr, '\0');
	}
	import[num_of_import].in_sig = strdup(buffer);
	import[num_of_import].np_name = NULL;
	clcunlex(token);
      }
      else{
	skip_end_of_def();
	each_result = FAIL;
	continue;
      }
    }
    else if(token == CALL_NEGO || token == CALL_PROC){
      import[num_of_import].dist = token;
      /* $B8r>DL>!&<jB3$-L>$N3MF@(B */
      if((token = method_lex()) == EOF){
	return FAIL;
      }
      else if(token == STRING){
	import[num_of_import].in_method
	  = strdup(import[num_of_import].out_method);
	import[num_of_import].np_name = strdup(clcword);
      }
      else{
	warning("illegal import method definition");
	skip_end_of_def();
	result = FAIL;
	continue;
      }
    }
    else{
      warning("illegal import method definition");
      skip_end_of_def();
      result = FAIL;
      continue;
    }
    
    /* $BDj5A$N=*$j$^$GFI$_9~$`(B */
    skip_end_of_def();
    continue;
  }

  fprintf(conv_fp, "import\n");
  for(i = 0; i < num_of_import; i++){
    if(import[i].dist == CALL_SUB){
      if(import[i].to == NULL){
	fprintf(conv_fp, "%s@%s=>!%s@%s\n",
		import[i].out_method, import[i].out_sig,
		import[i].in_method,  import[i].in_sig);
      }
      else if(import[i].manage == NULL){
	fprintf(conv_fp, "%s@%s=>%s!%s@%s\n",
		import[i].out_method, import[i].out_sig,
		import[i].to,
		import[i].in_method,  import[i].in_sig);
      }
      else{
	fprintf(conv_fp, "%s@%s=>%s,%s!%s@%s\n",
		import[i].out_method, import[i].out_sig,
		import[i].to,import[i].manage,
		import[i].in_method,  import[i].in_sig);
      }
    }
  }
    
#ifdef DEBUG
  for(i = 0; i < num_of_import; i++){
    if(import[i].dist == CALL_SUB){
      fprintf(stderr, "%s => %s\n",
	      import[i].out_method, import[i].in_method);
    } else if(import[i].dist == CALL_NEGO){
      fprintf(stderr, "%s => nego %s\n",
	      import[i].out_method, import[i].in_method);
    } else if(import[i].dist == CALL_PROC){
      fprintf(stderr, "%s => proc %s\n",
	      import[i].out_method, import[i].in_method);
    }
  }
#endif
  return result;
}
/* end of import_parser.c */
