/* hia_info.c
 *
 */
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <dirent.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <heliosd.h>
#include <hdMessage.h>
#include <hExternStdFunc.h>
#include <hdAgentInfo.h>
#include <hdHiaInfo.h>
#include <hdcommon.h>

#include <define.h>
#include <capldata.h>
#include <hia_info.h>

extern HdBoolean hdGetHiaInfo();

static HdBoolean hdGetMachInfo();
static HMachInfo hdMakeDataOfMachInfo();

int get_agent_process_info(void)
{
  int i;
  HeliosdCtlInfo hdCtlInfo;  /* hia $B%U%!%$%k$+$iFI$_9~$`>pJs(B */
  HeliosdErrorMsgType eMsgType;
  HAgentInfo      agentInfo;
  char *helios_dir;
  char conf_dir[BUFSIZE];

  if((helios_dir = getenv("HELIOSDIR")) != NULL)
    sprintf(conf_dir, "%s/config/", helios_dir);
  else
    sprintf(conf_dir, "../config/");
  hdCtlInfo.fullPath = HdMallocString(conf_dir);

    /*
     *	$B%^%7%s>pJs$N3MF@(B
     */
    if (hdGetMachInfo(&hdCtlInfo, &(hdCtlInfo.machInfo)) == HdFalse) {
	eMsgType = HdEMsg_GetMachInfoError;
	return FAIL;
    }

  /* helios.hia $B$+$i$N>pJs$NFI$_9~$_(B */
  if (hdGetHiaInfo(&hdCtlInfo, &hdCtlInfo.allAgents) == HdFalse){
    eMsgType = HdEMsg_HiaFileError;
    return FAIL;
  }
  
  /* $B%(!<%8%'%s%HL>$K$h$k%(!<%8%'%s%H>pJs$N8!:w(B */
  if((agentInfo = hdSearchAgentInfoFromName(hdCtlInfo.allAgents, agent_name))
     == NULL){
    fprintf(stderr, "%s does not exist in helios.hia.\n", agent_name);
    return FAIL;
  }
  
  /* $B%(!<%8%'%s%H<1JL;R$N3MF@(B */
  agent_id = strdup(agentInfo->agentId);
  
  /* $B%(!<%8%'%s%H%W%m%;%9L>$N3MF@(B */
  for(i = 0; i < AP_MAX+1; i++) ap_name[i] = NULL;
  get_agent_process_name(agentInfo, 0);
  return TRUE;
}

int get_agent_process_name(HAgentInfo agentInfo, int i)
{
  if(i >= AP_MAX){
    fprintf(stderr, "process name table is overflow");
    return i;
  }
  if(agentInfo->type == HdAT_Single){
    ap_name[i] =strdup(agentInfo->agentName);
    i += 1;
  }
  else{
    for(agentInfo = agentInfo->child;
	agentInfo != NULL; agentInfo = agentInfo->next){
      i = get_agent_process_name(agentInfo, i);
      if(i >= AP_MAX) break;
    }
  }
  return i;
}

HAgentInfo hdSearchAgentInfoFromName(allAgents, agentName)
     HAgentInfo		allAgents;
     char		*agentName;
{
  HAgentInfo		agentInfo;
  
  for (; allAgents != NULL; allAgents = allAgents->next){
    if (allAgents->agentName != NULL){
      if (strcmp(allAgents->agentName, agentName) == 0){
	return allAgents;
      }
    }
    if ((agentInfo = hdSearchAgentInfoFromName(allAgents->child, agentName))
	!= NULL){
      return agentInfo;
    }
  }
  
  return NULL;
}

/*
 *	$B%^%7%s>pJs$N3MF@(B
 */
static HdBoolean hdGetMachInfo(hdCtlInfo, hMachInfo)
    HeliosdCtlInfo	*hdCtlInfo;
    HMachInfo		*hMachInfo;
{
    char		hostname[HostNameLen_Lim];
    HeliosdErrorMsgType	eMsgType;

    /* $B%5!<%P$r5/F0$7$?%^%7%s$N%[%9%HL>(B */
    if (gethostname(hostname, HostNameLen_Lim) == ERROR_FLAG) {
	hdPerror();
	eMsgType = HdEMsg_NotFindHostName;
	goto Error_Rtn;
    }

#ifdef _DEBUG_HELIOSD_HOSTNAME
    fprintf(stderr, "host name : %s\n", hostname);
#endif /* _DEBUG_HELIOSD */

    if ((*hMachInfo = hdMakeDataOfMachInfo(hostname)) == NULL) {
	eMsgType = HdEMsg_MakeDataOfMachInfoError;
	goto Error_Rtn;
    }

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *	Make data of MachInfo structure
 */
static HMachInfo hdMakeDataOfMachInfo(hostname)
    char		*hostname;
{
    HMachInfo		machInfo;
    struct hostent	*myhost;
    struct sockaddr_in	*sockAddr;
    HeliosdErrorMsgType	eMsgType;


    if ((myhost = gethostbyname(hostname)) == NULL) {
	eMsgType = HdEMsg_BadHostName;
	goto Error_Rtn;
    }

    if ((machInfo = (HMachInfo)HdMalloc(sizeof(MachInfo))) == NULL) {
	eMsgType = HdEMsg_HdMallocError;
	goto Error_Rtn;
    }

    if ((machInfo->hostName = HdMallocString(hostname)) == NULL) {
	eMsgType = HdEMsg_HdMallocStringError;
	goto Error_Rtn;
    }

    machInfo->addressSize = sizeof(machInfo->sockAddress);
    sockAddr = &(machInfo->sockAddress);

    bzero((char *)sockAddr, machInfo->addressSize);
    sockAddr->sin_family = AF_INET;

    bcopy(myhost->h_addr, (char *)&(sockAddr->sin_addr), myhost->h_length);

#ifdef _Heliosd_Static_Port_Num

    sockAddr->sin_port = HeliosdPortNum;

#else

    sockAddr->sin_port = 0;
    sockAddr->sin_addr.s_addr = INADDR_ANY;

#endif

    return machInfo;

 Error_Rtn:
    hdFreeMachInfo(&machInfo);

    hdPutsErrorMsg(eMsgType);
    return NULL;
}
/* end of hia_info.c */
