/* file.c
 *        file handling module.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <define.h>
#include <capldata.h>
#include <file.h>

extern char *inc_file;
extern char *ext_file;
extern char *def_file;
extern char *table_file;
extern char *main_file;
extern char *func_file;
extern char *conv_file;
extern char *select_file;

FILE *open_capl_file(char *capl_file, char *app_name)
{
  char file[BUFSIZE];
  char app_dir[BUFSIZE];

  if(get_app_dir(app_name, app_dir) == NULL){
    fprintf(stderr, "%s is not exist.\n", app_dir);
    return NULL;
  }
  sprintf(file, "%s/cpl/%s", app_dir, capl_file);
  return fopen(file, "r");
}

FILE *open_cty_file(char *env_name, char *app_name)
{
  char file[BUFSIZE];
  char app_dir[BUFSIZE];

  if(get_app_dir(app_name, app_dir) == NULL){
    fprintf(stderr, "%s is not exist.\n", app_dir);
    return NULL;
  }
  sprintf(file, "%s/evl/%s.cty", app_dir, env_name);
  return fopen(file, "r");
}

FILE *open_agent_file(char *file_name, char *app_name){
  char file[BUFSIZE];
  char app_dir[BUFSIZE];

  if(get_app_dir(app_name, app_dir) == NULL){
    fprintf(stderr, "%s is not exist.\n", app_dir);
    return NULL;
  }
  sprintf(file, "%s/%s", app_dir, file_name);
  return fopen(file, "w");
}

char *get_app_dir(char *app_name, char *app_dir)
{
  char *helios_dir;
  struct stat sbuf;

  if(app_name == NULL){
    sprintf(app_dir , "..");
  }
  else if((helios_dir = getenv("HELIOSDIR")) != NULL){
    sprintf(app_dir, "%s/app/%s", helios_dir, app_name);
  }
  else{
    sprintf(app_dir, "..");
  }
  if(stat(app_dir, &sbuf) == -1 || (sbuf.st_mode &S_IFMT) != S_IFDIR){
    fprintf(stderr, "%s is not exist.\n", app_dir);
    return NULL;
  }
  return app_dir;
}

FILE *open_hia_file(void)
{
  char file[BUFSIZE];
  char *helios_dir;
  FILE *fp;

  fp = NULL;
  if((helios_dir = getenv("HELIOSDIR")) != NULL){
    sprintf(file, "%s/configure/helios.hia", helios_dir);
  }
  else{
    sprintf(file, "../../../configure/helios.hia");
  }
  return fopen(file, "rw");
}

int generate_tbl_file(char *app_name)
{
  int i;
  int result;
  FILE *fp;
  char file[BUFSIZE];
  char app_dir[BUFSIZE];

  if(get_app_dir(app_name, app_dir) == NULL){
    fprintf(stderr, "%s is not exist.\n", app_dir);
    return FAIL;
  }
  result = TRUE;
  for(i = 0; ap_name[i] != NULL; i++){
    sprintf(file, "%s/cmd_%s/%s.tbl", app_dir, ap_name[i], agent_name);
    if((fp = fopen(file, "w")) == NULL){
      fprintf(stderr, "fail in opening %s.\n", file);
      result = FAIL;
      continue;
    }
    fprintf(fp, "#AgentName\n%s\n\n",agent_name);
    fprintf(fp, "#AgentID\n%s\n\n", agent_id);
    fprintf(fp, "#AgentType\n%d\n\n", agent_type);
    fprintf(fp, "#Comment\n%s\n\n", comment);
    /*
     * $BM"F~%a%=%C%I(B Import {}
     * $BM"=P%a%=%C%I(B Export {}
     */
    /*
     * $B%(!<%8%'%s%H%G%#%l%/%H%j$H%U%!%s%/%7%g%s%G%#%l%/%H%j$O(B
     * ENVL $B%3%s%Q%$%i$K@8@.$7$F$b$i$&!#(B
     */
    fclose(fp);
  }
  return result;
}

int copy_temp_files_to_cmd_directories(char *app_name)
{
  char dist[BUFSIZE];
  char app_dir[BUFSIZE];
  int i;

  if(get_app_dir(app_name, app_dir) == NULL){
    fprintf(stderr, "%s is not exist.\n", app_dir);
    return FAIL;
  }
  for(i = 0; ap_name[i] != NULL; i++){
    sprintf(dist, "%s/cmd_%s/%sConv.dat", app_dir, ap_name[i], agent_name);
    copy_file_to_file(conv_file, dist);
  }
  if(agent_type == SIMPLE){
    for(i = 0; ap_name[i] != NULL; i++){
      sprintf(dist, "%s/cmd_%s/%sMain.c", app_dir, ap_name[i], agent_name);
      copy_file_to_file(inc_file, dist);
      append_file_to_file(def_file, dist);
      append_file_to_file(ext_file, dist);
      append_file_to_file(main_file, dist);
    }
    for(i = 0; ap_name[i] != NULL; i++){
      sprintf(dist, "%s/cmd_%s/%sFunc.c", app_dir, ap_name[i], agent_name);
      copy_file_to_file(inc_file, dist);
      append_file_to_file(def_file, dist);
      append_file_to_file(ext_file, dist);
      append_file_to_file(table_file, dist);
      append_file_to_file("./#func.c", dist);
    }
  }
  return TRUE;
}

int copy_file_to_file(char *source, char *dist)
{
  FILE *sfp, *dfp;
  char buffer[BUFSIZ];

  if((sfp = fopen(source, "r")) == NULL){
    fprintf(stderr, "fail in opening %s\n", source);
    return FAIL;
  }
  if((dfp = fopen(dist, "w")) == NULL){
    fprintf(stderr, "fail in opening %s\n", dist);
    return FAIL;
  }
  while(fgets(buffer, BUFSIZ, sfp) != NULL){
    fputs(buffer, dfp);
  }
  fclose(sfp);
  fclose(dfp);
  return TRUE;
}

int append_file_to_file(char *source, char *dist)
{
  FILE *sfp, *dfp;
  char buffer[BUFSIZ];

  if((sfp = fopen(source, "r")) == NULL){
    fprintf(stderr, "fail in opening %s\n", source);
    return FAIL;
  }
  if((dfp = fopen(dist, "a")) == NULL){
    fprintf(stderr, "fail in opening %s\n", dist);
    return FAIL;
  }
  while(fgets(buffer, BUFSIZ, sfp) != NULL){
    fputs(buffer, dfp);
  }
  fclose(sfp);
  fclose(dfp);
  return TRUE;
}

/* end of file.c */
