/* export_parser.c
 *
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);
extern FILE *func_fp;
extern FILE *conv_fp;

static char ask_send_proc_list[]={
"int ASK_SEND_%s(char *method, char *data, SMessage smg)
{
  SMessage askSmg;
  askSmg = MakeAskMessage(%s, %s, worldInfo[NOW].tid, method, data);
  CREnqueu(smg, SUBSTANCE, EXTERNAL, CSMGetMidStr(askSmg), NOW, OFF);
  send_message(askSmg);
  return 1;
}
"};


static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int export_parser(void)
{
  int token;
  int result;
  int each_result;
  int i;
  char buffer[BUFSIZE], *ptr;
  char to[BUFSIZE], manage[BUFSIZE];

  num_of_export = -1;
  result = TRUE;
  each_result = TRUE;
  while(1){
    if(each_result == TRUE){
      num_of_export += 1;
      if(num_of_export == TABLE_MAX){
	warning("overflow of export method table");
	break;
      }
    }
    else{
      result = FAIL;
    }
    each_result = TRUE;

    /* $B%a%C%;!<%8$G<u$1<h$k%a%=%C%IL>$N3MF@(B
     */
    CLCLEX(token, FAIL);
    if(token == STRING){
      export[num_of_export].in_method =strdup(clcword);
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      break;
    }
    else{
      warning("illegal export method definition");
      if(skip_end_of_def() == FAIL) return FAIL;
      each_result = FAIL;
      continue;
    }

    CLCLEX(token, FAIL);
    if(token == '@'){
      ptr = buffer;
      memset(buffer, '\0', BUFSIZE);
      while(1){
	CLCLEX(token, FAIL);
	if(token == METHOD_SEP){
	  break;
	}
	else if(token == VARIABLE){
	  sprintf(ptr, "#%s", clcword);
	}
	else if(token == STRING || token == NUMBER){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	else{
	  warning("illegal signature description");
	}
	ptr = strchr(ptr, '\0');
      }
      export[num_of_export].in_sig = strdup(buffer);
    }
    else{
      if(skip_end_of_def() == FAIL) return FAIL;
      each_result = FAIL;
      continue;
    }

    /* $BAw?.@h$N3MF@(B */
    memset(buffer, '\0', BUFSIZE);
    ptr = buffer;
    export[num_of_export].to = NULL;
    export[num_of_export].manage = NULL;
    while(1){
      CLCLEX(token, FAIL);
      if(token == ','){
	if(buffer != ptr) *(ptr-1) = '\0';
	if(buffer[0] != '\0')
	  export[num_of_export].to = strdup(buffer);
	CLCLEX(token, FAIL);
	if(token == STRING){
	  export[num_of_export].manage = strdup(clcword);
	}
	else{
	  warning("illegal destination management name");
	  each_result = FAIL;
	}
	CLCLEX(token, FAIL);
	if(token != '!'){
	  warning("illegal destination description");
	  each_result = FAIL;
	}
	break;
      }
      else if(token == '!'){
	if(buffer != ptr) *(ptr-1) = '\0';
	if(buffer[0] != '\0')
	  export[num_of_export].to = strdup(buffer);
	break;
      }
      else if(token == STRING){
	sprintf(ptr, "%s ", clcword);
      }
      else if(token == VARIABLE || token == PARAMETER){
	warning("I cannot understande parameter a in method signatue");
	result = FAIL;
      }
      else if(clcword[0] == '\0'){
	sprintf(ptr, "%c ", (char)token);
      }
      ptr = strchr(ptr, '\0');
    }
    /* $BAw?.$9$k%a%C%;!<%8$N%a%=%C%I$N3MF@(B */
    CLCLEX(token, FAIL);
    if(token == STRING){
      export[num_of_export].out_method = strdup(clcword);
    }
    else{
      warning("illegal method description");
      each_result = FAIL;
    }

    CLCLEX(token, FAIL);
    if(token == '@'){
      ptr = buffer;
      memset(buffer, '\0', BUFSIZE);
      while(1){
	CLCLEX(token, FAIL);
	if(token == ';'){
	  break;
	}
	else if(token == VARIABLE){
	  sprintf(ptr, "#%s", clcword);
	}
	else if(token == PARAMETER){
	  sprintf(ptr, "$%s", clcword);
	}
	else if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	else{
	  warning("illegal common method signature description");
	  each_result = FAIL;
	}
	ptr = strchr(ptr, '\0');
      }
      export[num_of_export].out_sig = strdup(buffer);
      clcunlex(token);
    }
    else{
      warning("illegal export method description");
      if(skip_end_of_def() == FAIL) return FAIL;
      each_result = FAIL;
      continue;
    }

    /* $BDj5A$N=*$j$^$GFI$_9~$`(B */
    if(skip_end_of_def() == FAIL) return FAIL;
    continue;
    }
  fprintf(conv_fp, "export\n");
  for(i = 0; i < num_of_export; i++){
    if(export[i].manage != NULL){
      fprintf(conv_fp, "%s@%s=>%s,%s!%s@%s\n",
	      export[i].in_method, export[i].in_sig,
	      export[i].to, export[i].manage,
	      export[i].out_method, export[i].out_sig);
    }
    else{
      fprintf(conv_fp, "%s@%s=>%s!%s@%s\n",
	      export[i].in_method, export[i].in_sig,
	      export[i].to,
	      export[i].out_method, export[i].out_sig);
    }
  }

  for(i = 0; i < num_of_export; i++){
    sprintf(to, "\"%s\"", export[i].to);
    if(export[i].manage != NULL)
      sprintf(manage, "\"%s\"", export[i].manage);
    else
      sprintf(manage, "NULL");
    fprintf(func_fp, ask_send_proc_list, to, manage);
  }

  return result;
}
/* end of export_parser.c */

