/* exp_parser.c
 * <exp> := <compare exp> | <calculate exp>
 * <compare exp> := <var/par> <comp op> <var/par>
 *                | <var/par> <comp op> <const>
 *                | <const>   <comp op> <var/par>
 *                | <const>   <comp op> <const>
 * <comp op> := == | > | >= | < | <=
 * <calc> := <var/par> := <calculate>;
 * <calculate> := <function> | <numerical calulate>
 */

int method_lex(void);

int compare_exp_parser(char *np_name,
		       para_data args[], int num_of_args,
		       para_data para_list[], int num_of_para,
		       para_data np_para_list[], int num_of_np_para)
{
  int token;
  int lhs_type;
  int rhs_type;
  char lhs_arg[BUFSIZE];
  char rhs_arg[BUFSIZE];
  int comp_op;
  int result;

  result = TRUE;
  lhs_type = compare_exp_arg_parser(np_name,
				    args, num_of_args,
				    para_list, num_of_para,
				    np_para_list, num_of_np_para,
				    lhs_arg);
  comp_op = compare_exp_op_parser();
  rhs_type = compare_exp_arg_parser(np_name,
				    args, num_of_args,
				    para_list, num_of_para,
				    np_para_list, num_of_np_para,
				    rhs_arg);
  if(lhs_type != -1 && rhs_type != -1 && lhs_type == rhs_type && comp_op != FAIL){
    if(lhs_type == INT_TYPE || lhs_type == BOOL_TYPE){
      fprintf(func_fp, "    %s ", lhs_arg);
      if(comp_op == EQ) fprintf(func_fp, "== ");
      else if(comp_op == '>') fprintf(func_fp, "> ");
      else if(comp_op == '<') fprintf(func_fp, "< ");
      else if(comp_op == GREATEREQ) fprintf(func_fp, "<= ");
      else if(comp_op == LESSEQ) fprintf(func_fp, " >= ");
      else if(comp_op == NOT_EQ) fprintf(func_fp, "!=");
      else result = FAIL;
      fprintf(func_fp, "%s ", rhs_arg);
      return TRUE;
    }
    else if(lhs_type == STR_TYPE){
      if(comp_op == EQ)
	fprintf(func_fp, "    strcmp(%s,%s) == 0", lhs_arg, rhs_arg);
      else if(comp_op == NOT_EQ)
	fprintf(func_fp, "    strcmp(%s,%s) != 0", lhs_arg, rhs_arg);
      else result = FAIL;
    }
  }
  else{
    result = FAIL;
  }
  return result;
}

int compare_exp_arg_parser(char *np_name,
			   para_data args[], int num_of_args,
			   para_data para_list[], int num_of_para,
			   para_data np_para_list[], int num_of_np_para,
			   char arg_name[]);
{
  int type;

  CLCLEX(token, FAIL);
  if(token == VARIABLE){
    type = check_common_type(clcword, args);
    if(type == INT_TYPE){
      fprintf(func_fp, "    int_%s = CBGetInt(arg[%s]),\n", clcword, clcword);
      sprintf(arg_name, "int_%s", clcword);
    }
    else if(type == BOOL_TYPE){
      fprintf(func_fp, "    bool_%s = CBGetBool(arg[%s]),\n", clcword, clcword);
      sprintf(arg_name, "bool_%s", clcword);
    }
    else if(type == STR_TYPE){
      fprintf(func_fp, "    str_%s = CBGetString(arg[%s]),\n", clcword, clcword);
      sprintf(arg_name, "str_%s", clcword);
    }
    else if(type == LIST_TYPE){
      fprintf(func_fp, "    list_%s = CStructToCommon(arg[%s], list_%s),\n", clcword, clcword);
      sprintf(arg_name, "str_%s", clcword);
    }
    else if(type == VEC_TYPE){
      fprintf(func_fp, "    vec_%s = CStructToCommon(arg[%s], vec_%s),\n", clcword, clcword);
      sprintf(arg_name, "str_%s", clcword);
    }
    else{
      result= FAIL;
      warning("unknown parameter");
    }
  }
  else if(token == PARAMETER){
    type = check_common_type(clcword, np_para_list);
    if(type == INT_TYPE){
      fprintf(func_fp,
	      "    WIlPar.%s_par.int_%s = CBGetInt(WIlPar.%s_par.%s),\n",
	      np_name, clcword, np_name, clcword);
      sprintf(arg_name, "WIlPar.%s_par.int_%s", np_name, clcword);
    }
    else if(type == BOOL_TYPE){
      fprintf(func_fp,
	      "    WIlPar.%s_par.bool_%s = CBGetBool(WIlPar.%s_par.%s),\n",
	      np_name, clcword, np_name, clcword);
      sprintf(arg_name, "WIlPar.%s_par.bool_%s", np_name, clcword);
    }
    else if(type == STR_TYPE){
      fprintf(func_fp,
	      "    WIlPar.%s_par.str_%s = CBGetString(WIlPar.%s_par.%s),\n",
	      np_name, clcword, np_name, clcword);
      sprintf(arg_name, "WIlPar.%s_par.str_%s", np_name, clcword);
    }
    else if(type == LIST_TYPE){
      fprintf(func_fp,
	      "    WIlPar.%s_par.list_%s = CStructToCommon(WIlPar.%s_par.%s, WIlPar.%s.list_%s),\n",
	      np_name, clcword, np_name, clcword, np_name, clcword);
      sprintf(arg_name, "WIlPar.%s_par.list_%s", np_name, clcword);
    }
    else if(type == VEC_TYPE){
      fprintf(func_fp,
	      "    WIlPar.%s_par.vec_%s = CStructToCommon(WIlPar.%s_par.%s, WIlPar.%s_par.vec_%s),\n",
	      np_name, clcword, np_name, clcword, np_name, clcword);
      sprintf(arg_name, "WIlPar.%s_par.vec_%s", np_name, clcword);
    }
    else if(type == NO_TYPE){
      type = check_common_type(clcword, para_list);
      if(type == INT_TYPE){
	fprintf(func_fp,
		"    AIcPar.int_%s = CBGetInt(AIcPar.%s),\n", clcword, clcword);
	sprintf(arg_name, "AIcPar.int_%s", clcword);
      }
      else if(type == BOOL_TYPE){
	fprintf(func_fp,
		"    AIcPar.bool_%s = CBGetBool(AIcPar.%s),\n", clcword, clcword);
	sprintf(arg_name, "AIcPar.bool_%s", clcword);
      }
      else if(type == STR_TYPE){
	fprintf(func_fp,
		"    AIcPar.str_%s = CBGetString(AIcPar.%s),\n", clcword, clcword);
	sprintf(arg_name, "AIcPar.str_%s", clcword);
      }
      else if(type == LIST_TYPE){
	fprintf(func_fp,
		"    AIcPar.list_%s = CStructToCommon(AIcPar.%s, AIcPar.list_%s),\n",
		clcword, clcword, clcword);
	sprintf(arg_name, "AIcPar.list_%s", clcword);
      }
      else if(type == VEC_TYPE){
	fprintf(func_fp,
		"    AIcPar.vec_%s = CStructToCommon(AIcPar.%s, AIcPar.vec_%s),\n",
		clcword, clcword, clcword);
	sprintf(arg_name, "AIcPar.vec_%s", clcword);
      }
    }
    if(type == NO_TYPE || TUPLE_BOOL){
      result= FAIL;
      warning("unknown parameter");
    }
  }
  else if(token == NUMBER){
    type = INT_TYPE;
    fprintf(func_fp, "    %s_int = %s,\n");
  }
  else if(token == STRING){
    if(strcmp(token, true) == 0){
      type = BOOL_TYPE;
      
  }
  else{
    warning("...");
    result = FAIL;
  }
  if(result == TRUE) return type;
  else return -1;
}

int compare_exp_op_parser(void)
{
  int token;

  CLCLEX(token, FAIL);
  if(token == EQL ||
     token == GREATEREQ || token == '>' ||
     token == LESSEQ    || token == '<'){
    return token;
  }
  else{
    warning("illegal compare operator.");
    return FAIL;
  }
}

/* end of exp_parser.c */
