/* cty_lex.c
 *        $B3F;z6g2r@OIt$,6&DL$KMxMQ$9$k4X?t$rDj5A$9$k(B
 *        
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <capldata.h>
#include <define.h>
#include <tokens.h>

extern FILE *cty_fp;

static int ungetchar;
static int ungettoken;
static int lineno = 1;

char ctyword[BUFSIZE];

/* $BJ8;z$rFI$_9~$`(B */
static int ctygetc(void)
{
  int c;
  if(ungetchar){
    c = ungetchar;
    ungetchar = 0;
    return c;
  } else {
    return fgetc(cty_fp);
  }
}

/* $BFI$_9~$s$@J8;z$rB`Hr$9$k(B */
int ctyungetc(int c)
{
  ungetchar=c;
  return ungetchar;
}

static void cty_get_string(int top)
{
  int i;
  int c;

  i = 0;
  if(top != '\0') ctyword[i++] = top;
  while(1){
    c = ctygetc();
    if(!isalpha(c) && !isdigit(c) && c != '_') break;
    ctyword[i++] = c;
  }
  ctyungetc(c);
  ctyword[i] = '\0';
}

/* $BFI$_9~$s$@C18l$rB`Hr$9$k(B */
int ctyunlex(int token)
{
  ungettoken = token;
  return ungettoken;
}

int ctylex(void)
{
  int token;
  int c;

  if(ungettoken != 0){
    token = ungettoken;
    ungettoken = 0;
    return token;
  }

  memset(ctyword, '\0', BUFSIZE);
  while((c = ctygetc()) != EOF){
    if(c == '%'){ /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while((c = ctygetc()) == '\n');
      lineno += 1;
      continue;
    }
    else if(c == ' ' || c == '\t') continue;
    else if(c == '\n'){
      lineno += 1;
      continue;
    }
    else if(c == ':'){
      c = ctygetc();
      if(c == '=') return ASSIGN;
      else{
	ctyungetc(c);
	return ':';
      }
    }
    else if(isalpha(c) || c == '_'){
      cty_get_string(c);
      return STRING;
    }
    else return c;
  }
  return c;
}

/* end of lex.c */
