/* conv_parser.c
 *        $B<B$N8F$S=P$7Dj5A$N$?$a$N%Q!<%5!<(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);
extern FILE *conv_fp;

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int conv_parser(void)
{
  int token;
  int result;
  int each_result;
  char buffer[BUFSIZE], *ptr;
  
  result = TRUE;
  each_result = TRUE;
  num_of_call = -1;
  fprintf(conv_fp, "conv\n");
  while(1){
    if(each_result == TRUE){
      num_of_call += 1;
      if(num_of_call == TABLE_MAX){
	warning("overflow of call method table");
	result = FAIL;
	break;
      }
    }
    else{
      result = FAIL;
    }

    if((token = method_lex()) == EOF){
      return result;
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      break;
    }
    clcunlex(token);
    /* $B6&DL7?$N%G!<%?$r<u$1<h$k(B */
    memset(buffer, '\0', BUFSIZE);
    ptr = buffer;
    while((token = method_lex()) != CONV_SEP){
      if(token == EOF){
	return FAIL;
      }
      else if(token == STRING || token == NUMBER || token == QSTRING){
	sprintf(ptr, "%s", clcword);
      }
      else if(token == VARIABLE){
	sprintf(ptr, "#%s", clcword);
      }
      else if(token == PARAMETER){
	sprintf(ptr, "$%s", clcword);
      }
      else if(clcword[0] == '\0'){
	sprintf(ptr, "%c", (char)token);
      }
      ptr = strchr(ptr, '\0');
    }
    fprintf(conv_fp,"%s<=>",buffer);

    memset(buffer, '\0', BUFSIZE);
    ptr = buffer;
    while((token = method_lex()) != ';'){
      if(token == EOF){
	return FAIL;
      }
      else if(token == STRING || token == NUMBER || token == QSTRING){
	sprintf(ptr, "%s", clcword);
      }
      else if(token == VARIABLE){
	sprintf(ptr, "#%s", clcword);
      }
      else if(token == PARAMETER){
	sprintf(ptr, "$%s", clcword);
      }
      else if(clcword[0] == '\0'){
	sprintf(ptr, "%c", (char)token);
      }
      ptr = strchr(ptr, '\0');
    }
    fprintf(conv_fp, "%s\n", buffer);
    clcunlex(token);

    /* $BDj5A$N=*$j$^$GFI$_9~$`(B */
    skip_end_of_def();
    continue;
  }
  
  return result;
}
/* end of conv_parser.c */
