/* common_parser.c
 *        $B%(!<%8%'%s%H$NO@M}L>$r<h$j=P$9(B
 *        <logical name defnition> ::= &agent <string> ;
 */
#include <stdio.h>
#include <string.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);
extern int check_common_type(void);

int name_parser(void)
{
  int token;

  if((token = method_lex()) == STRING){
    agent_name = strdup(clcword);
#ifdef DEBUG
    fprintf(stderr, "agent name = %s\n", agent_name);
#endif
  }
  else{
    warning("illegal agent name");
    agent_name[0] = '\0';
    return FAIL;
  }
  if((token = method_lex()) == ';'){
    return TRUE;
  }
  else{
    clcunlex(token);
    warning("not find end of definition ';'");
    if(agent_name[0] != '\0'){
      fprintf(stderr, "\t clc set agent logical name \"%s\"\n", agent_name);
      return TRUE;
    }
    else{
      return FAIL;
    }
  }
}

int type_parser(void)
{
  int token;

  if((token = method_lex()) == STRING){
    if(strcmp(clcword, "simple") == 0) agent_type = SIMPLE;
    else if(strcmp(clcword, "complex") == 0) agent_type = COMPLEX;
    else warning("illegal agent type");
  }
#ifdef DEBUG
  if(agent_type == SIMPLE)
    fprintf(stderr, "\tcapl compiler set agent type SIMPLE\n");
  else if(agent_type == COMPLEX)
    fprintf(stderr, "\tcapl compiler set agent type COMPLEX\n");
#endif

  if((token = method_lex()) == ';'){
    return TRUE;
  }
  else{
    clcunlex(token);
    warning("not find end of definition ';'");
    if(agent_type == SIMPLE)
      fprintf(stderr, "\tcapl compiler set agent type SIMPLE\n");
    else if(agent_type == COMPLEX)
      fprintf(stderr, "\tcapl compiler set agent type COMPLEX\n");
    return TRUE;
  }
}

int lock_parser(void)
{
  int token;

  if((token = method_lex()) == STRING){
    if(strcmp(clcword, "on") == 0) lock_swt = ON;
    else if(strcmp(clcword, "off") == 0) lock_swt = OFF;
    else{
      warning("illegal lock definiton, you must set on or off");
      fprintf(stderr, "\tcapl compiler set lock off(default)");
      lock_swt = OFF;
    }
  }
#ifdef DEBUG
  if(lock_swt == ON)
    fprintf(stderr, "\tcapl compiler set lock ON\n");
  else if(lock_swt == OFF)
    fprintf(stderr, "\tcapl compiler set lock OFF\n");
#endif

  if((token = method_lex()) == ';'){
    return TRUE;
  }
  else{
    clcunlex(token);
    warning("not find end of definition ';'");
    if(lock_swt == ON)
      fprintf(stderr, "\tcapl compiler set lock switch ON\n");
    else if(lock_swt == OFF)
      fprintf(stderr, "\tcapl compiler set lock switch OFF\n");
    return TRUE;
  }
}

int trans_parser(void)
{
  int token;

  if((token = method_lex()) == STRING){
    if(strcmp(clcword, "on") == 0) trans_swt = ON;
    else if(strcmp(clcword, "off") == 0) trans_swt = OFF;
    else{
      warning("illegal transaction definition, you must set on or off");
      fprintf(stderr, "\tcapl compiler set transaction on(default)");
      trans_swt = ON;
    }
  }

#ifdef DEBUG
  if(trans_swt == ON)
    fprintf(stderr, "\tcapl compiler set transaction ON\n");
  else if(trans_swt == OFF)
    fprintf(stderr, "\tcapl compiler set transaction OFF\n");
#endif

  if((token = method_lex()) == ';'){
    return TRUE;
  }
  else{
    clcunlex(token);
    warning("not find end of definition ';'");
    if(trans_swt == ON)
      fprintf(stderr, "\tcapl compiler set transaction ON\n");
    else if(trans_swt == OFF)
      fprintf(stderr, "\tcapl compiler set transaction OFF\n");
    return TRUE;
  }
}

int connect_parser(void)
{
  int token;

  if((token = method_lex()) == STRING){
    if(strcmp(clcword, "same_process") == 0){
      connect_type = SAME_PROC;
      connect_name = strdup("SAME_PROC");
    }
    else if(strcmp(clcword, "pipe") == 0){
      connect_type = PIPE;
      connect_name = strdup("PIPE");
    }
    else if(strcmp(clcword, "socket") == 0){
      connect_type = SOCKET;
      connect_name = strdup("SOCKET");
    }
  }
  else{
    warning("illegal connect definiton");
    return FAIL;
  }

#ifdef DEBUG
  if(connect_type == SAME_PROC)
    fprintf(stderr, "\tcapl compiler set connect type same process\n");
  else if(connect_type == PIPE)
    fprintf(stderr, "\tcapl compiler set connect type pipe\n");
  else if(connect_type == SOCKET)
    fprintf(stderr, "\tcapl compiler set connect type socket\n");
#endif

  if((token = method_lex()) == ';'){
    return TRUE;
  }
  else{
    clcunlex(token);
    warning("not find end of definition ';'");
    if(connect_type == SAME_PROC){
      fprintf(stderr, "\tcapl compiler set connect type same process\n");
      return TRUE;
    }
    else if(connect_type == PIPE){
      fprintf(stderr, "\tcapl compiler set connect type pipe\n");
      return TRUE;
    }
    else if(connect_type == SOCKET){
      fprintf(stderr, "\tcapl compiler set connect type socket\n");
      return TRUE;
    }
    else return FAIL;
  }
}

int env_parser(void)
{
  int token;

  if((token = method_lex()) == EOF){
    return FAIL;
  }
  else if(token == STRING){
    env_name = strdup(clcword);
  }
  else if(token_is_keyword(token) == USER){
    env_name = NULL;
  }
  else{
    warning("illegal agent name");
    agent_name[0] = '\0';
    return FAIL;
  }

  if((token = method_lex()) == EOF){
    return FAIL;
  }
  else if(token != ';'){
    warning("cannot find end of definiton");
    clcunlex(token);
  }
  return TRUE;
}
/* end of common_parser.c */
