/* common_lex.c
 *        $B$$$/$D$+$N%Q!<%5!<$GMxMQ$9$k6&DL$N;z6g2r@OIt(B
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <warn.h>
#include <lex.h>
#include <tokens.h>

int common_lex(void)
{
  int token;
  int c;
  if(ungettoken != 0){
    token = ungettoken;
    ungettoken = 0;
    return token;
  }

  memset(clcword, '\0', BUFSIZE);
  while((c = clcgetc()) != EOF){
    if(c == '%'){ /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while((c = clcgetc()) == '\n');
      lineno += 1;
      continue;
    }
    else if(c == ' ' || c == '\t') continue;
    else if(c == '\n'){
      lineno += 1;
      continue;
    }
    else if(c == ';') return ';';
    else if(isalpha(c) || c == '_'){
      clc_get_string(c);
      return STRING;
    }
    else return c;
  }
  return token;
}

/* end of common_lex.c */
