/* check_type.c 
 *        $B8r>D@oN,!?8r>D<jB3$-$G;HMQ$9$kJQ?t$N8!::$KI,MW(B
 */

#include <stdio.h>
#include <string.h>

#include <define.h>
#include <capldata.h>
#include <file.h>
#include <tokens.h>
#include <lex.h>
#include <parser.h>

extern int ctylex(void);
extern char ctyword[];

FILE *cty_fp;

static int skip_end_of_def(void)
{
  int token;
  while((token = ctylex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}
int make_common_type_table(char *app_name)
{
  int token;
  int i;
  int result;
  int each_result;

  if(env_name != NULL){
    if((cty_fp = open_cty_file(env_name, app_name)) == NULL){
      fprintf(stderr, "fail in opening %s.cty\n", env_name);
      return FAIL;
    }
  }
  else{
    return TRUE;
  }

  result = TRUE;
  each_result = TRUE;
  type_list[0].type_name = strdup("int");
  type_list[0].type_type = INT_TYPE;
  type_list[1].type_name = strdup("bool");
  type_list[1].type_type = BOOL_TYPE;
  type_list[2].type_name = strdup("string");
  type_list[2].type_type = STR_TYPE;
  for(i = 3; i < TYPE_MAX+1; i++){
    if(each_result == FAIL){
      result = FAIL;
      each_result = FAIL;
    }
    if((token = ctylex()) == EOF){
      break;
    }
    else if(token == STRING){
      type_list[i].type_name = strdup(ctyword);
    }
    else{
      fprintf(stderr, "illegal common type name\n");
      each_result = FAIL;
      skip_end_of_def();
      continue;
    }

    if((token = ctylex()) == EOF){
      result = FAIL;
      return FAIL;
    }
    else if(token == ASSIGN){
      if((token = ctylex()) == EOF){
	result = FAIL;
	break;
      }
      else if(token == '['){
	type_list[i].type_type = LIST_TYPE;
      }
      else if(token == '<'){
	type_list[i].type_type = VEC_TYPE;
      }
      else if(token == '('){
	type_list[i].type_type = TUPLE_TYPE;
      }
      else if(token == STRING){
	if(strcmp(ctyword, "int") == 0){
	  type_list[i].type_type = INT_TYPE;
	}
	else if(strcmp(ctyword, "string") == 0){
	  type_list[i].type_type = STR_TYPE;
	}
	else if(strcmp(ctyword, "bool") == 0){
	}
	else{
	  fprintf(stderr, "illegal common type name");
	  each_result = FAIL;
	  skip_end_of_def();
	  continue;
	}
      }
      else{
	fprintf(stderr, "illegal common type name");
	each_result = FAIL;
	skip_end_of_def();
	continue;
      }
      skip_end_of_def();
      continue;
    }
    else{
      fprintf(stderr, "illegal common type name");
      each_result = FAIL;
      skip_end_of_def();
      continue;
    }
  }
  fclose(cty_fp);
  if(i <= TYPE_MAX){
    num_of_type = i;
  }
  else{
    result = FAIL;
  }

#ifdef DEBUG
  for(i = 0; i < num_of_type; i++){
    fprintf(stderr, "common type %s is ", type_list[i].type_name);
    if(type_list[i].type_type == INT_TYPE){
      fprintf(stderr, "INT_TYPE\n");
    }
    else if(type_list[i].type_type == STR_TYPE){
      fprintf(stderr, "STR_TYPE\n");
    }
    else if(type_list[i].type_type == BOOL_TYPE){
      fprintf(stderr, "BOOL_TYPE\n");
    }
    else if(type_list[i].type_type == LIST_TYPE){
      fprintf(stderr, "LIST_TYPE\n");
    }
    else if(type_list[i].type_type == VEC_TYPE){
      fprintf(stderr, "VEC_TYPE\n");
    }
    else if(type_list[i].type_type == TUPLE_TYPE){
      fprintf(stderr, "TUPLE_TYPE\n");
    }
    else{
      fprintf(stderr, "non type\n");
    }
  }
#endif
  return result;
}


int check_common_type_type(char *type_name)
{
  int i;
  for(i = 0; i < num_of_type; i++){
    if(strcmp(type_name, type_list[i].type_name) == 0)
      return type_list[i].type_type;
  }
  return NO_TYPE;
}

int
  check_common_type(char *variable, para_data para_list[], int num_of_para)
{
  int i;

  for(i = 0; i < num_of_para; i++){
    if(strcmp(variable, para_list[i].para_name) == 0) break;
  }
  if(i == num_of_para) return NO_TYPE;
  else return check_common_type_type(para_list[i].para_type);
}

/* end of check_type.c */
