/* cds_lex.c (for Common Data Signature)
 *        CAPL$B$K$*$1$k6&DL7?$N5-=R$rFI$_9~$`$?$a$N;z6g2r@OIt(B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <warn.h>
#include <lex.h>
#include <tokens.h>

int cds_lex(void)
{
  int token;
  int c;
  int i;
  if(ungettoken != 0){
    token = ungettoken;
    ungettoken = 0;
    return token;
  }

  memset(clcword, '\0', BUFSIZE);
  while((c = clcgetc()) != EOF){
    if(c == '%'){ /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while((c = clcgetc()) == '\n');
      lineno += 1;
      continue;
    }
    else if(c == ' ' || c == '\t') continue;
    else if(c == '\n'){
      lineno += 1;
      continue;
    }
    else if(c == '-'){
      if((c = clcgetc()) == '>') return SIG_SEP;
      else{
	clcungetc(c);
	return '_';
      }
    }
    else if(c == '='){
      if((c = clcgetc()) == '>')return METHOD_SEP;
      else{
	clcungetc(c);
	return '=';
      }
    }
    else if(isalpha(c) || c == '_'){
      clc_get_string();
      return STRING;
    }
    else if(c == '#'){
      clc_get_number();
      return VARIABLE;
    }
    else if(c == '$'){
      clc_get_string();
      return PARAMETER;
    }
    else if(isdigit(c)){
      clc_get_number(c);
      return NUMBER;
    }
    else return c;
  }
  return 0;
}
/* end of cds_lex.c */
