/* call_parser.c
 *        $B<B$N8F$S=P$7Dj5A$N$?$a$N%Q!<%5!<(B
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parser.h>
#include <tokens.h>

extern int method_lex(void);
extern FILE *conv_fp;

static int skip_end_of_def(void)
{
  int token;
  while((token = method_lex()) != ';')
    if(token == EOF) return FAIL;
  return TRUE;
}

int call_parser(void)
{
  int token;
  int result;
  int each_result;
  int i;
  char buffer[BUFSIZE], *ptr;

  result = TRUE;
  each_result = TRUE;
  num_of_call = -1;
  while(1){
    if(each_result == TRUE){
      num_of_call += 1;
      if(num_of_call == TABLE_MAX){
	warning("overflow of call in_method table");
	result = FAIL;
	break;
      }
    }
    else{
      result = FAIL;
    }

    /* $B%a%C%;!<%8$G<u$1<h$k%a%=%C%IL>$N3MF@(B
     */
    if((token = method_lex()) == EOF){
      break;
    }
    else if(token == STRING){
      call[num_of_call].in_method = strdup(clcword);
    }
    else if(token_is_keyword(token) == TRUE){
      clcunlex(token);
      break;
    }
    else{
      warning("illegal call in_method definition");
      skip_end_of_def();
      each_result = FAIL;
      continue;
    }

    if((token = method_lex()) == EOF){
      return FAIL;
    }
    else if(token == '@'){
      memset(buffer, '\0', BUFSIZE);
      ptr = buffer;
      while((token = method_lex()) != METHOD_SEP){
	if(token == EOF){
	  return FAIL;
	}
	else if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == VARIABLE){
	  sprintf(ptr, "#%s", clcword);
	}
	else if(token == PARAMETER){
	  sprintf(ptr, "$%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	ptr = strchr(ptr, '\0');
      }
      call[num_of_call].in_sig = strdup(buffer);
    }
    else{
      warning("illegal in_method description in export in_method");
      skip_end_of_def();
      each_result = FAIL;
      continue;
    }

    if((token = method_lex()) == EOF){
      return FAIL;
    }
    else if(token == STRING){
      call[num_of_call].out_method = strdup(clcword);
    }
    else{
      warning("illegal in_method description of substance procedure");
      skip_end_of_def();
      each_result = FAIL;
      continue;
    }
    if((token = method_lex()) == EOF){
      return FAIL;
    }
    else if(token == '@'){
      memset(buffer, '\0', BUFSIZE);
      ptr = buffer;
      while((token = method_lex()) != ';'){
	if(token == EOF){
	  return FAIL;
	}
	else if(token == STRING || token == NUMBER || token == QSTRING){
	  sprintf(ptr, "%s", clcword);
	}
	else if(token == VARIABLE){
	  sprintf(ptr, "#%s", clcword);
	}
	else if(token == PARAMETER){
	  sprintf(ptr, "$%s", clcword);
	}
	else if(token == SIG_SEP){
	  sprintf(ptr, "->");
	}
	else if(clcword[0] == '\0'){
	  sprintf(ptr, "%c", (char)token);
	}
	ptr = strchr(ptr, '\0');
      }
      call[num_of_call].out_sig = strdup(buffer);
      clcunlex(token);
    }
    else{
      warning("illegal in_method description in export in_method");
      skip_end_of_def();
      each_result = FAIL;
      continue;
    }
    /* $BDj5A$N=*$j$^$GFI$_9~$`(B */
    skip_end_of_def();
    continue;
  }

  fprintf(conv_fp, "substance_call\n");
  for(i = 0; i < num_of_call; i++){
    fprintf(conv_fp, "%s@%s=>%s\n",
	    call[i].in_method, call[i].in_sig,
	    call[i].out_sig);
  }
#ifdef DEBUG
  for(i = 0; i < num_of_call; i++){
    fprintf(stderr, "in_method %s => sub proc %s\n",
	    call[i].in_method, call[i].out_sig);
  }
#endif
  return result;
}
/* end of call_parser.c */
