/* assign_exp_parser.c */
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <define.h>
#include <capldata.h>
#include <warn.h>
#include <lex.h>
#include <parsers.h>
#include <parser.h>
#include <tokens.h>
#include <check_type.h>
#include <np_proc_sig_parser.h>
#include <comp_exp_parser.h>
#include <assign_exp_parser.h>

extern int method_lex(void);
extern FILE *func_fp;


int assign_exp_parser(char *np_name,
		      para_data args[], int num_of_args,
		      para_data para_list[], int num_of_para,
		      para_data np_para_list[], int num_of_np_para)
{
  int token;
  int result;
  int lhs_type;
  int rhs_type;
  char lhs_arg[BUFSIZE];
  int flag;

  lhs_type = lhs_assign_exp_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   np_para_list, num_of_np_para,
				   lhs_arg);
  CLCLEX(token, FAIL);
  if(token != ASSIGN){
    warning("...");
    result = FAIL;
  }
  flag = 0;
  rhs_type = rhs_assign_exp_parser(np_name,
				   args, num_of_args,
				   para_list, num_of_para,
				   np_para_list, num_of_np_para,
				   &flag);
  if(lhs_type != -1 && rhs_type != -1 && lhs_type == rhs_type){
    fprintf(func_fp, "  %s = CDuplicate(tmp%d);\n", lhs_arg, flag);
    fprintf(func_fp, "  CDelete(tmp%d);\n", flag);
  }
  else{
    result = FAIL;
  }
  return result;
}


int lhs_assign_exp_parser(char *np_name,
			  para_data args[], int num_of_args,
			  para_data para_list[], int num_of_para,
			  para_data np_para_list[], int num_of_np_para,
			  char *arg_name)
{
  int result;
  int token;
  int type;

  result = TRUE;
  CLCLEX(token, FAIL);
  if(token == PARAMETER){
    type = check_common_type(clcword, np_para_list, num_of_np_para);
    if(type != NO_TYPE){
      fprintf(func_fp, "  if(WIlPar.%s_par.%s != NULL) CDelete(WIlPar.%s_par.%s);\n",
	      np_name, clcword, np_name, clcword);
      sprintf(arg_name, "WIlPar.%s_par.%s", np_name, clcword);
    }
    else {
      type = check_common_type(clcword, para_list, num_of_para);
      fprintf(func_fp, "  if(AIcPar.%s != NULL) CDelete(AIcPar.%s);\n",
	      clcword, clcword);
      sprintf(arg_name, "AIcPar.%s", clcword);
    }
    if(type == NO_TYPE){
      result= FAIL;
      warning("unknown parameter");
    }
  }
  else{
    warning("left hand side of assign expression is only parameter");
    result = FAIL;
  }
  if(result == TRUE) return type;
  else return -1;
}

int rhs_assign_exp_parser(char *np_name,
			  para_data args[], int num_of_args,
			  para_data para_list[], int num_of_para,
			  para_data np_para_list[], int num_of_np_para,
			  int* flag)
{
  int i;
  int result;
  int token;
  int type;
  char arg_name[BUFSIZE];
  int pre_flag;

  result = TRUE;
  CLCLEX(token, FAIL);
  if(token == PARAMETER || token == VARIABLE){
    if(token == PARAMETER){
      type = check_common_type(clcword, np_para_list, num_of_np_para);
      if(type != NO_TYPE){
	sprintf(arg_name, "WIlPar.%s_par.%s", np_name, clcword);
      }
      else{
	type = check_common_type(clcword, para_list, num_of_para);
	if(type != NO_TYPE){
	  sprintf(arg_name, "AIcPar.%s", clcword);
	}
      }
      if(type != NO_TYPE){
	fprintf(func_fp, "  tmp%d = CDuplicate(%s);\n", *flag, arg_name);
      }
      else{
	result = FAIL;
      }
    }
    else if(token == VARIABLE){
      for(i = 0; i < num_of_args; i++){
	if(strcmp(clcword, args[i].para_name) == 0) break;
      }
      if(i < num_of_args){
	type = check_common_type(clcword, args, num_of_args);
	if(type != NO_TYPE){
	  sprintf(arg_name, "arg[%d]", i);
	}
	if(type != NO_TYPE){
	  fprintf(func_fp, "  tmp%d = CDuplicate(%s);\n", *flag, arg_name);
	}
	else{
	  result = FAIL;
	}
      }
      else{
	result = FAIL;
      }
    }
    while(1){
      CLCLEX(token, FAIL);
      if(token == ';'){
	clcunlex(token);
	break;
      }
      else if(token == '.'){
	if(token == STRING){
	  pre_flag = *flag;
	  *flag = (*flag+1)%2;
	  fprintf(func_fp, "  CDelete(tmp%d);\n", pre_flag);
	  fprintf(func_fp, "  tmp%d = CTGetElement(tmp%d, \"%s\");\n",
		  *flag, pre_flag, clcword);
	}
	else if(token == NUMBER){
	  pre_flag = *flag;
	  *flag = (*flag+1)%2;
	  fprintf(func_fp, "  CDelete(tmp%d);\n", pre_flag);
	  fprintf(func_fp, "  tmp%d = CLGetElement(tmp%d, %s);\n",
		  *flag, pre_flag, clcword);
	}
	else{
	  warning("illegal construct type description");
	  result = FAIL;
	}
      }
    }
  }
  else if(token == VARIABLE){
  }
  else if(token == NUMBER){
    type = INT_TYPE;
    fprintf(func_fp, "  tmp1 = CCommonToStruct(%s);\n", clcword);
  }
  else if(token == QSTRING){
    type = STR_TYPE;
    fprintf(func_fp, "  tmp1 = CCommonToStruct(%s);\n", clcword);
  }
  else if(token == STRING){
    if(strcmp(clcword, "true") == 0 || strcmp(clcword, "false") == 0){
      type = BOOL_TYPE;
      fprintf(func_fp, "  tmp1 = CCommonToStruct(%s);\n", clcword);
    }
    else{
      CLCLEX(token, FAIL);
      if(token == ';'){
	clcunlex(token);
	type = STR_TYPE;
	fprintf(func_fp, "  tmp1 = CCommonToStruct(\"%s\");\n", clcword);
      }
      else{
	warning("illegal assign expression");
	result = FAIL;
      }
    }
  }
  else if(token == '['){
    type = LIST_TYPE;
    result = get_construct_constant(arg_name, ']');
  }
  else if(token == '<'){
    type = VEC_TYPE;
    result = get_construct_constant(arg_name, '>');
  }
  else if(token == '('){
    type = TUPLE_TYPE;
    result = get_construct_constant(arg_name, ')');
  }
  CLCLEX(token, FAIL);
  if(token != ';'){
    warning("cannot define end of sentence");
    result = FAIL;
  }
  if(result == TRUE){
    return type;
  }
  else{
    return -1;
  }
}

/* end of assign_exp_parser.c */
